/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.dao;

import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.msg.BizModuleItem;
import com.kingdee.eas.mobile.msg.dao.BizConfigDao;
import com.kingdee.util.Uuid;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BizConfigDaoImpl
implements BizConfigDao {
    private static final Logger logger = Logger.getLogger(BizConfigDaoImpl.class);
    private static BizConfigDaoImpl instance = new BizConfigDaoImpl();

    private BizConfigDaoImpl() {
    }

    public static BizConfigDaoImpl getInstance() {
        return instance;
    }

    @Override
    public boolean saveConfig(BizModuleConfig config, String ais, Connection con) throws SQLException {
        if (con == null) {
            return false;
        }
        boolean ret = false;
        boolean defaultCommit = true;
        PreparedStatement stmt = null;
        Object[] params = null;
        String sql = "";
        try {
            if (BizConfigDaoImpl.HasAISExisted(stmt, ais)) {
                sql = BizConfigDaoImpl.getUpdateAISConfigSQL(ais, config);
                params = new Object[]{config.getHost(), config.getPort(), config.getMsgTypes(), ais};
                this.executeSql(con, stmt, sql, params);
                logger.debug((Object)("update Sql:" + sql));
            } else {
                sql = BizConfigDaoImpl.getAddAISConfigSQL(ais, config);
                params = new Object[]{ais, config.getHost(), config.getPort(), config.getMsgTypes()};
                this.executeSql(con, stmt, sql, params);
                logger.debug((Object)("sql:" + sql));
            }
            sql = BizConfigDaoImpl.getDeleteCommandConfigSQL(ais);
            params = new Object[]{ais};
            this.executeSql(con, stmt, sql, params);
            ArrayList modules = config.getConfigedModules();
            logger.debug((Object)("\u5927\u5c0f\uff1a" + modules.size()));
            for (int i = 0; i < modules.size(); ++i) {
                BizModuleItem module = (BizModuleItem)modules.get(i);
                if (!BizConfigDaoImpl.HasBusinessExisted(stmt, module)) {
                    sql = BizConfigDaoImpl.getAddBusinessSQL(module);
                    params = new Object[]{module.getBizKey(), module.getClassName()};
                    this.executeSql(con, stmt, sql, params);
                    logger.debug((Object)("sql:" + sql));
                }
                sql = BizConfigDaoImpl.getAddCommandSQL(ais, module);
                params = new Object[]{ais, module.getBusiness_id(), module.getCommand()};
                this.executeSql(con, stmt, sql, params);
            }
            ret = true;
        }
        catch (SQLException e) {
            logger.error((Object)(e.getMessage() + " sql:\n" + sql));
            ret = false;
            throw e;
        }
        finally {
            BizConfigDaoImpl.closeAndRelease(stmt);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BizModuleConfig getConfig(String ais, Connection con) {
        if (con == null) {
            return null;
        }
        BizModuleConfig config = new BizModuleConfig();
        ArrayList<BizModuleItem> modules = new ArrayList<BizModuleItem>();
        config.setConfigedModules(modules);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Object[] params = null;
        try {
            String sql = "select FHost,FPort,FChannels from T_Mobile_Solution where FAis=?";
            logger.debug((Object)("getConfig sql is:" + sql));
            params = new Object[]{ais};
            rs = this.executeQuery(con, stmt, sql, params);
            if (rs.next()) {
                config.setHost(rs.getString(1));
                config.setPort(rs.getInt(2));
                config.setMsgTypes(rs.getInt(3));
            }
            sql = "select a.FCommand,a.FLoaded,b.FFuncNo,b.FClassName from (select * from T_Mobile_Command where FAIS=?') a left outer join T_Mobile_Biz b on a.FB_id=b.FB_id";
            logger.debug((Object)("getConfig sql is:" + sql));
            params = new Object[]{ais};
            rs = this.executeQuery(con, stmt, sql, params);
            while (rs.next()) {
                String command = rs.getString(1);
                int isLoaded = rs.getInt(2);
                int bizkey = rs.getInt(3);
                String className = rs.getString(4);
                BizModuleItem module = new BizModuleItem(command, className, bizkey);
                if (isLoaded == 0) {
                    module.setLoaded(false);
                } else {
                    module.setLoaded(true);
                }
                modules.add(module);
            }
            logger.debug((Object)("Modules :" + modules.size()));
            BizConfigDaoImpl.closeAndRelease(rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            BizConfigDaoImpl.closeAndRelease(rs, stmt);
        }
        return config;
    }

    private static final boolean HasAISExisted(PreparedStatement stmt, String ais) throws SQLException {
        String sql = "select * from T_Mobile_Solution where FAis=?";
        logger.info((Object)("HasAISExisted sql is: " + sql + "ais = " + ais));
        stmt.setObject(1, ais);
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            return true;
        }
        rs.close();
        return false;
    }

    private static final boolean HasBusinessExisted(PreparedStatement stmt, BizModuleItem module) throws SQLException {
        String sql = "select FB_id from T_Mobile_Biz where FFuncNo= ? and FClassName= ?";
        logger.info((Object)("HasBusinessExisted sql is: " + sql));
        boolean success = false;
        stmt.setObject(1, module.getBizKey());
        stmt.setObject(2, module.getClassName());
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            module.setBusiness_id(rs.getString(1));
            success = true;
        }
        rs.close();
        return success;
    }

    private static final String getAddAISConfigSQL(String ais, BizModuleConfig bizConfig) {
        String uuid = Uuid.create().toString();
        String sql = "insert into T_Mobile_Solution(FID,FAis,FHost,FPort,FChannels) values('" + uuid + "',?,?,?,?)";
        logger.info((Object)("getAddAISConfigString is: " + sql));
        return sql;
    }

    private static final String getUpdateAISConfigSQL(String ais, BizModuleConfig bizConfig) {
        String sql = "update T_Mobile_Solution set FHost= ?,FPort= ?,FChannels= ? where FAis= ?";
        logger.info((Object)("getUpdateAISConfigString is: " + sql));
        return sql;
    }

    private static final String getDeleteCommandConfigSQL(String ais) {
        String sql = "delete from T_Mobile_Command where FAIS= ?";
        logger.info((Object)("getDeleteCommandConfigString is: " + sql));
        return sql;
    }

    private static final String getAddBusinessSQL(BizModuleItem module) {
        String b_id = Uuid.create().toString();
        String sql = "insert into T_Mobile_Biz(FB_id,FFuncNo,FClassName) values('" + b_id + "',?,?)";
        module.setBusiness_id(b_id);
        logger.info((Object)("getAddBusinessSQL is: " + sql));
        return sql;
    }

    private static final String getAddCommandSQL(String ais, BizModuleItem module) {
        int isLoaded = 0;
        if (module.isLoaded()) {
            isLoaded = 1;
        }
        String uuid = Uuid.create().toString();
        String sql = "insert into T_Mobile_Command(FID,FAIS,FB_id,FCommand,FLoaded) values('" + uuid + "',?,?,?, " + isLoaded + ")";
        logger.info((Object)("getAddCommandSQL is: " + sql));
        return sql;
    }

    private static final void closeAndRelease(Statement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt = null;
    }

    private static final void closeAndRelease(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs = null;
    }

    private static final void closeAndRelease(ResultSet rs, Statement stmt) {
        BizConfigDaoImpl.closeAndRelease(rs);
        BizConfigDaoImpl.closeAndRelease(stmt);
    }

    public static void main(String[] args) {
        BizConfigDaoImpl impl = new BizConfigDaoImpl();
        System.out.println(BizConfigDaoImpl.getAddBusinessSQL(new BizModuleItem("a", "b", 0)));
        System.out.println(BizConfigDaoImpl.getAddAISConfigSQL("ais", new BizModuleConfig()));
        BizConfigDaoImpl.getAddCommandSQL("ais", new BizModuleItem("a", "b", 0));
        BizConfigDaoImpl.getDeleteCommandConfigSQL("ais");
        BizConfigDaoImpl.getUpdateAISConfigSQL("ais", new BizModuleConfig());
        String sql = "select FB_id from T_Mobile_Biz where FFuncNo= ?  and FClassName= ? ";
        System.out.println(sql);
        sql = "select * from T_Mobile_Solution where FAis=?";
        System.out.println(sql);
        sql = "select FB_id from T_Mobile_Biz where FFuncNo= \uff1f  and FClassName= \uff1f";
        System.out.println(sql);
        sql = "select FHost,FPort,FChannels from T_Mobile_Solution where FAis=?";
        System.out.println("getSolutionByName\r\n" + sql);
        sql = "select a.FCommand,a.FLoaded,b.FFuncNo,b.FClassName from (select * from T_Mobile_Command where FAIS= ? ) a left outer join T_Mobile_Biz b on a.FB_id=b.FB_id";
        System.out.println("getCommandsByAis\r\n" + sql);
        sql = "insert into T_Mobile_Command(FID,FAIS,FB_id,FCommand,FLoaded) values('?,?,?,?,?)";
        System.out.println("InsertCommand\r\n" + sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(Connection con, PreparedStatement stmt, String sql, Object[] params) throws SQLException {
        try {
            stmt = con.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                stmt.setObject(i + 1, params[i]);
            }
            stmt.execute(sql);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(Connection con, PreparedStatement stmt, String sql, Object[] params) throws SQLException {
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                stmt.setObject(i + 1, params[i]);
            }
            rs = stmt.executeQuery(sql);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return rs;
    }
}

