/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.dao.jdbc;

import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.mobile.BOSMsgTypeEnum;
import com.kingdee.eas.mobile.msg.ReceiveUserMsgInfo;
import com.kingdee.eas.mobile.msg.SendUserMsgInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class MsgConvert {
    private static final Logger logger = Logger.getLogger((String)MsgConvert.class.getName());
    public static final BOSObjectType SEND_MSG_TYPE = new SendUserMsgInfo().getBOSType();
    public static final BOSObjectType RECEIVE_MSG_TYPE = new ReceiveUserMsgInfo().getBOSType();

    public static SendUserMsgInfo convert(KDMessage msg, KDMessageAddress address, String userid) {
        SendUserMsgInfo sendMsg = new SendUserMsgInfo();
        sendMsg.setId(BOSUuid.create((BOSObjectType)SEND_MSG_TYPE));
        sendMsg.setUserid(userid);
        sendMsg.setMsgId(msg.getId());
        sendMsg.setPriority(msg.getPriority());
        sendMsg.setRevertible(msg.isRevertible());
        sendMsg.setTitle(msg.getTitle());
        sendMsg.setContent(msg.getContent());
        sendMsg.setAddress(address.getDetail());
        sendMsg.setMsgType(BOSMsgTypeEnum.getMsgType(address.getDeviceName()));
        sendMsg.setCreateTime(new Timestamp(new Date().getTime()));
        String relativeID = msg.getRelativeId();
        sendMsg.setSrcMsgId(relativeID);
        return sendMsg;
    }

    public static ReceiveUserMsgInfo convert(KDMessage msg, String userid) {
        ReceiveUserMsgInfo info = new ReceiveUserMsgInfo();
        info.setId(BOSUuid.create((BOSObjectType)RECEIVE_MSG_TYPE));
        info.setMsgId(msg.getId());
        info.setUserid(userid);
        info.setPriority(msg.getPriority());
        info.setTitle(msg.getTitle());
        info.setContent(msg.getContent());
        info.setRelativeId(msg.getRelativeId());
        KDMessageAddress address = msg.getSender();
        info.setSrcAddress(address.getDetail());
        info.setMsgType(BOSMsgTypeEnum.getMsgType(address.getDeviceName()));
        info.setReceiveTime(new Timestamp(new Date().getTime()));
        return info;
    }

    public static SendUserMsgInfo convert(KDMessage msg, KDMessageAddress address, String userid, Connection con) throws SQLException {
        SendUserMsgInfo sendMsg = new SendUserMsgInfo();
        sendMsg.setId(BOSUuid.create((BOSObjectType)SEND_MSG_TYPE));
        sendMsg.setUserid(userid);
        sendMsg.setMsgId(msg.getId());
        sendMsg.setPriority(msg.getPriority());
        sendMsg.setRevertible(msg.isRevertible());
        sendMsg.setTitle(msg.getTitle());
        sendMsg.setContent(msg.getContent());
        sendMsg.setAddress(address.getDetail());
        sendMsg.setMsgType(BOSMsgTypeEnum.getMsgType(address.getDeviceName()));
        sendMsg.setCreateTime(new Timestamp(new Date().getTime()));
        String relativeID = msg.getRelativeId();
        sendMsg.setSrcMsgId(relativeID);
        if (relativeID == null) {
            sendMsg.setRootMsgID(msg.getId());
        } else {
            String sql = "select FRootMsgID from T_Mobile_ReceiveMsg where fid = '" + relativeID + "'";
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            String rootMsgID = null;
            if (rs.next()) {
                rootMsgID = rs.getString("FRootMsgID");
            }
            sendMsg.setRootMsgID(rootMsgID);
        }
        return sendMsg;
    }
}

