/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.listener;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.eas.mobile.msg.IMobileAppMsgFacade;
import com.kingdee.eas.mobile.msg.MobileAppMsgFacadeFactory;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class MobileAppMsgListener
implements MessageListener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mobile.msg.listener.MobileAppMsgListener");
    private Map contexts = new Hashtable();
    private static IObjectPK loginUserPk = MobileAppMsgListener.getLoginUserID();
    private static Locale DEFAULT_LOCALE = new Locale("l2");

    public int onMessage(Message message) {
        try {
            logger.info((Object)"---mobile---MobileAppMsgListener--into onMessage...(\u5de5\u4f5c\u6d41|\u50ac\u529e\u8c03\u7528)");
            Context ctx = MobileAppMsgListener.getContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
            IMobileAppMsgFacade iMsg = MobileAppMsgFacadeFactory.getLocalInstance(ctx);
            iMsg.mobileAppListener(message);
            logger.info((Object)"---mobile---MobileAppMsgListener--mobileMsg process success!");
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)"msg process failed!", (Throwable)e);
            return 0;
        }
    }

    private static Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context(loginUserPk, currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }

    private static final IObjectPK getLoginUserID() {
        String RSC_PATH = "com.kingdee.eas.mobile.msg.LoginConstant";
        String USERID_KEY = "loginUserId";
        String DEFAULT_USER_PK = "00000000-0000-0000-0000-00000000000013B7DE7F";
        logger.debug((Object)"\u53d6\u5f97\u7528\u6237ID");
        String id = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("com.kingdee.eas.mobile.msg.LoginConstant", new Locale("l1"));
            id = bundle.getString("loginUserId");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (id == null) {
            logger.warn((Object)"Config File not set,a Login by default userid 00000000-0000-0000-0000-00000000000013B7DE7F");
            return new ObjectStringPK("00000000-0000-0000-0000-00000000000013B7DE7F");
        }
        return new ObjectStringPK(id);
    }
}

