/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.loader;

import com.kingdee.eas.mobile.msg.loader.BizLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

class BizLoaderFromClass
extends ClassLoader
implements FilenameFilter,
BizLoader {
    private static final String CLASS = ".class";
    private static final Logger logger = Logger.getLogger(BizLoaderFromClass.class);
    private String rootPath;

    BizLoaderFromClass() {
    }

    public ArrayList getClasses(File file, String rootPath) {
        this.rootPath = rootPath;
        ArrayList<Class> arr = new ArrayList<Class>();
        logger.debug((Object)("file:" + file.getName()));
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                arr.addAll(this.getClasses(files[i], rootPath));
            }
        } else if (file.getName().endsWith(CLASS)) {
            Class clazz = null;
            try {
                clazz = this.getClass(file, rootPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (arr != null) {
                arr.add(clazz);
            }
        }
        return arr;
    }

    @Override
    public Collection getBizClasses(String dirPath) {
        ArrayList arr = new ArrayList();
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            String rootPath = dir.getAbsolutePath();
            logger.debug((Object)("rootPath:" + rootPath));
            arr = this.getClasses(dir, rootPath);
        }
        return arr;
    }

    private Class getClass(File file, String rootPath) throws Exception {
        Class<?> clazz = null;
        String path = file.getAbsolutePath();
        logger.info((Object)("filePath:" + path));
        if (path.indexOf(rootPath) == -1) {
            throw new Exception("File Path error");
        }
        FileInputStream ins = new FileInputStream(file);
        byte[] bytes = new byte[((InputStream)ins).available()];
        ((InputStream)ins).read(bytes);
        ((InputStream)ins).close();
        if (bytes != null) {
            String name = path.substring(rootPath.length() + 1);
            name = name.replace(File.separatorChar, '.');
            name = name.substring(0, name.indexOf(CLASS));
            logger.info((Object)name);
            clazz = this.defineClass(name, bytes, 0, bytes.length);
        }
        return clazz;
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.endsWith(CLASS);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        FileInputStream ins = null;
        String separ = name.substring(name.lastIndexOf("."));
        String path = name.substring(0, name.lastIndexOf("."));
        path = this.rootPath + File.separator + path.replace('.', '/') + separ;
        File f = new File(path);
        logger.debug((Object)("path:" + path));
        URL url = super.findResource(name);
        try {
            ins = new FileInputStream(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ins;
    }
}

