/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.loader;

import com.kingdee.eas.mobile.msg.loader.BizLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class BizLoaderFromJar
extends URLClassLoader
implements FilenameFilter,
BizLoader {
    private static final String JAR = ".jar";
    private static final String ZIP = ".zip";
    private static final String CLASS = ".class";
    private static final Logger logger = Logger.getLogger(BizLoaderFromJar.class);
    private static BizLoader loader = new BizLoaderFromJar(new URL[0]);

    private BizLoaderFromJar(URL[] urls) {
        super(urls);
    }

    public BizLoaderFromJar() {
        super(new URL[0]);
    }

    @Override
    public Collection getBizClasses(String dirPath) {
        ArrayList arr = new ArrayList();
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(this);
            for (int i = 0; files != null && i < files.length; ++i) {
                File file = files[i];
                JarFile jFile = null;
                try {
                    jFile = new JarFile(file);
                }
                catch (IOException e) {
                    logger.error((Object)(e.getMessage() + file.getName()));
                    continue;
                }
                arr.addAll(this.getClasses(jFile, file));
            }
        }
        return arr;
    }

    public ArrayList getClasses(JarFile jFile, File file) {
        ArrayList arr = new ArrayList();
        Enumeration<JarEntry> en = jFile.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || !name.endsWith(CLASS)) continue;
            Class<?> clazz = null;
            name = name.replace('/', '.');
            name = name.substring(0, name.indexOf(CLASS));
            try {
                int n;
                InputStream ins = jFile.getInputStream(entry);
                URL codeBase = this.getURL(file);
                String jarFakeUrl = codeBase.toString();
                jarFakeUrl = "jar:" + jarFakeUrl + "!/" + entry.getName();
                logger.info((Object)("jarFakeUrl:" + jarFakeUrl));
                URL source = new URL(jarFakeUrl);
                CodeSource cs = new CodeSource(codeBase, entry.getCertificates());
                byte[] classBytes = new byte[(int)entry.getSize()];
                int pos = 0;
                while ((n = ins.read(classBytes, pos, classBytes.length - pos)) > 0) {
                    pos += n;
                }
                ins.close();
                if (classBytes == null) continue;
                try {
                    clazz = this.defineClass(name, classBytes, 0, classBytes.length, cs);
                }
                catch (Error ex) {
                    ex.printStackTrace();
                }
                if (clazz == null) continue;
                arr.add(clazz);
            }
            catch (Exception exception) {}
        }
        return arr;
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.endsWith(JAR) || name.endsWith(ZIP);
    }

    protected URL getURL(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return realFile.toURL();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream ins = null;
        return ins;
    }
}

