/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.AbstractEmailAddressInfo;
import com.kingdee.eas.mobile.AbstractMobileMessageAddressInfo;
import com.kingdee.eas.mobile.CellphoneNumberTypeEnum;
import com.kingdee.eas.mobile.CoreMessageAddressInfo;
import com.kingdee.eas.mobile.EmailAddressInfo;
import com.kingdee.eas.mobile.EmailSendMessageCollection;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.IMobileConfig;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.MobileConfigCollection;
import com.kingdee.eas.mobile.MobileConfigFactory;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.MobileMessageAddressInfo;
import com.kingdee.eas.mobile.PriorityEnum;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.SendMobileMessageCollection;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.UserMessageConfigInfo;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.dao.DefaultMsgDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.util.MessageConstant;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AppMsgUtil {
    private static final Logger logger = Logger.getLogger(AppMsgUtil.class);
    private static final String RESOURCE = "com.kingdee.eas.mobile.msg.ProcessQueryResource";

    private AppMsgUtil() {
    }

    public static String getUserIdByAddress(Context ctx, KDMessageAddress address) throws BOSException {
        if (address == null || StringUtils.isEmpty((String)address.getDetail())) {
            return null;
        }
        String userId = null;
        String deviceName = address.getDeviceName();
        String detail = address.getDetail();
        if ("mp:sms".equals(deviceName)) {
            userId = AppMsgUtil.getUserIdByMobileNumber(ctx, detail);
        } else if ("mp:mail".equals(deviceName)) {
            userId = AppMsgUtil.getUserIdByEmail(ctx, detail);
        } else if ("mp:im".equals(deviceName)) {
            // empty if block
        }
        return userId;
    }

    public static String getUserIdByEmail(Context ctx, String email) throws BOSException {
        if (StringUtils.isEmpty((String)email)) {
            return null;
        }
        String userId = null;
        String personSql = "SELECT FID FROM T_BD_Person WHERE LCASE(TRIM(FEMail)) = LCASE(TRIM('" + email + "'))";
        IRowSet personRows = DbUtil.executeQuery((Context)ctx, (String)personSql);
        try {
            if (personRows.next()) {
                String personId = personRows.getString(1);
                String receiveUserSql = "SELECT FUserID FROM T_MO_ReceiveUser WHERE FPersonID = '" + personId + "'";
                IRowSet receiveUserRows = DbUtil.executeQuery((Context)ctx, (String)receiveUserSql);
                if (receiveUserRows.next()) {
                    return receiveUserRows.getString(1);
                }
                String userSql = "SELECT FID FROM T_PM_User WHERE FPersonID = '" + personId + "' ORDER BY FCreateTime";
                IRowSet userRows = DbUtil.executeQuery((Context)ctx, (String)userSql);
                if (userRows.next()) {
                    return userRows.getString(1);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return userId;
    }

    public static String getUserIdByMobileNumber(Context ctx, String mobileNumber) throws BOSException {
        if (StringUtils.isEmpty((String)mobileNumber)) {
            return null;
        }
        String userId = null;
        String personSql = "SELECT FID FROM T_BD_Person WHERE FCell = '" + mobileNumber + "'";
        IRowSet personRows = DbUtil.executeQuery((Context)ctx, (String)personSql);
        try {
            if (personRows.next()) {
                String personId = personRows.getString(1);
                StringBuffer receiveUserSql = new StringBuffer();
                receiveUserSql.append("SELECT r.FUserID FROM T_MO_ReceiveUser r, t_pm_user u WHERE r.FPersonID = '");
                receiveUserSql.append(personId);
                receiveUserSql.append("' and r.fuserid = u.fid and u.fIsdelete = 0 and u.fIsLocked = 0 and u.fForbidden = 0");
                IRowSet receiveUserRows = DbUtil.executeQuery((Context)ctx, (String)receiveUserSql.toString());
                if (receiveUserRows.next()) {
                    return receiveUserRows.getString(1);
                }
                String userSql = "SELECT FID FROM T_PM_User WHERE FPersonID = '" + personId + "' and fIsdelete = 0 and fIsLocked = 0 and fForbidden = 0 ORDER BY FCreateTime";
                IRowSet userRows = DbUtil.executeQuery((Context)ctx, (String)userSql);
                if (userRows.next()) {
                    return userRows.getString(1);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return userId;
    }

    public static String getAssignID(ReceiveMobileMessageInfo receiveMsg) {
        String customStr = null;
        String assignID = null;
        if (receiveMsg != null && receiveMsg.getParentMsg() != null && !StringUtils.isEmpty((String)receiveMsg.getParentMsg().getCustomStr()) && (customStr = receiveMsg.getParentMsg().getCustomStr()).indexOf("for.process.") > -1 && !StringUtils.isEmpty((String)(customStr = customStr.replaceAll("for.process.", "")))) {
            assignID = customStr;
        }
        return assignID;
    }

    public static Locale getLocalByUserID(String userid, Context ctx) {
        if (userid == null || userid.trim().length() < 0) {
            logger.info((Object)"KDMessageAddress IS Null!");
            return new Locale("L2");
        }
        Locale local = new Locale("L2");
        try {
            if (ctx == null) {
                return new Locale("L2");
            }
            StringBuffer sql = new StringBuffer("select FLocale from T_Mobile_User");
            sql.append(" where FUserID  = '");
            sql.append(userid + "'");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int localInt = 0;
            if (!rows.next()) {
                logger.info((Object)"\u5f53\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u591a\u8bed\u8a00\u9ed8\u8ba4\u53d6\u7b80\u4f53\u4e2d\u6587");
                return new Locale("L2");
            }
            localInt = rows.getInt("FLocale");
            local = new Locale("L" + ++localInt);
            return local;
        }
        catch (Exception e) {
            logger.info((Object)("Exception:" + e.getMessage()));
            return new Locale("L2");
        }
    }

    public static Locale getLocalByAddress(KDMessageAddress kdAddress, Context ctx) {
        if (kdAddress == null) {
            logger.info((Object)"KDMessageAddress IS Null!");
            return new Locale("L2");
        }
        Locale local = new Locale("L2");
        String address = kdAddress.getDetail();
        if (kdAddress.getDeviceName().equals("mp:mail")) {
            local = AppMsgUtil.getLocalByEMail(address, ctx);
        } else if (kdAddress.getDeviceName().equals("mp:sms")) {
            local = AppMsgUtil.getLocalByMobile(address, ctx);
        } else {
            return new Locale("L2");
        }
        return local;
    }

    public static Locale getLocalByEMail(String email, Context ctx) {
        try {
            if (ctx == null) {
                return new Locale("L2");
            }
            StringBuffer sql = new StringBuffer("select FLocale from T_Mobile_User,T_PM_User,T_BD_Person");
            sql.append(" where T_BD_Person.FID = T_PM_User.FPersonId and");
            sql.append(" T_PM_User.FID = T_Mobile_User.FUserID and");
            sql.append(" T_BD_Person.FEmail = '").append(email).append("'");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int localInt = 0;
            if (!rows.next()) {
                logger.info((Object)"\u5f53\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u591a\u8bed\u8a00\u9ed8\u8ba4\u53d6\u7b80\u4f53\u4e2d\u6587");
                return new Locale("L2");
            }
            localInt = rows.getInt("FLocale");
            Locale local = new Locale("L" + ++localInt);
            return local;
        }
        catch (Exception e) {
            logger.info((Object)("Exception:" + e.getMessage()));
            return new Locale("L2");
        }
    }

    public static Locale getLocalByMobile(String mobile, Context ctx) {
        try {
            if (ctx == null) {
                return new Locale("L2");
            }
            StringBuffer sql = new StringBuffer("select FLocale from T_Mobile_User,T_PM_User,T_BD_Person");
            sql.append(" where T_BD_Person.FID = T_PM_User.FPersonId and");
            sql.append(" T_PM_User.FID = T_Mobile_User.FUserID and");
            sql.append(" T_BD_Person.FCell = '").append(mobile).append("'");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int localInt = 0;
            if (!rows.next()) {
                logger.info((Object)"\u5f53\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u591a\u8bed\u8a00\u9ed8\u8ba4\u53d6\u7b80\u4f53\u4e2d\u6587");
                return new Locale("L2");
            }
            localInt = rows.getInt("FLocale");
            Locale local = new Locale("L" + ++localInt);
            return local;
        }
        catch (Exception e) {
            logger.info((Object)("Exception:" + e.getMessage()));
            return new Locale("L2");
        }
    }

    public static Map getReceiverLocaleFromMobileMessage(KDMessage msg, Context ctx) {
        KDMessageAddress[] address = msg.getReceivers();
        ArrayList<Locale> addressL1List = new ArrayList<Locale>();
        ArrayList<Locale> addressL2List = new ArrayList<Locale>();
        ArrayList<Locale> addressL3List = new ArrayList<Locale>();
        for (int i = 0; i < address.length; ++i) {
            Locale l = AppMsgUtil.getLocalByAddress(address[i], ctx);
            if (l.toString().equalsIgnoreCase("L1")) {
                addressL1List.add(l);
                continue;
            }
            if (l.toString().equalsIgnoreCase("L2")) {
                addressL2List.add(l);
                continue;
            }
            if (!l.toString().equalsIgnoreCase("L3")) continue;
            addressL3List.add(l);
        }
        KDMessageAddress[] addressTemp = (KDMessageAddress[])addressL1List.toArray();
        HashMap<String, KDMessageAddress[]> map = new HashMap<String, KDMessageAddress[]>();
        map.put("L1", addressTemp);
        addressTemp = (KDMessageAddress[])addressL2List.toArray();
        map.put("L2", addressTemp);
        addressTemp = (KDMessageAddress[])addressL3List.toArray();
        map.put("L3", addressTemp);
        return map;
    }

    public static Locale getSenderLocaleFromMobileMessage(KDMessage msg, Context ctx) {
        KDMessageAddress address = msg.getSender();
        return AppMsgUtil.getLocalByAddress(address, ctx);
    }

    public static UserInfo getCurrentUserInfo(Context ctx) throws EASBizException, BOSException {
        UserInfo userInfo = null;
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userid));
        return userInfo;
    }

    public static PersonInfo getPersonByUser(Context ctx, UserInfo userInfo) throws EASBizException, BOSException {
        PersonInfo personInfo = null;
        if (userInfo != null && userInfo.getPerson() != null) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(userInfo.getPerson().getId().toString()));
        }
        return personInfo;
    }

    public static PersonInfo getPersonByUserId(Context ctx, String userId) throws BOSException {
        PersonInfo personInfo = null;
        logger.info((Object)("---mobile---AppMsgUtil--getPersonByUserId().userId= " + userId));
        if (!StringUtils.isEmpty((String)userId)) {
            try {
                IUser iUser = UserFactory.getLocalInstance((Context)ctx);
                UserInfo userInfo = iUser.getUserInfo("select id,cell,email, person.* where id = '" + userId + "'");
                logger.info((Object)("---mobile---AppMsgUtil--userInfo= " + userInfo));
                if (userInfo != null) {
                    if (userInfo.getPerson() != null) {
                        personInfo = userInfo.getPerson();
                        logger.info((Object)("---mobile---AppMsgUtil--personInfo.getCell= " + personInfo.getCell()));
                    } else {
                        personInfo = new PersonInfo();
                        personInfo.setCell(userInfo.getCell());
                        personInfo.setEmail(userInfo.getEmail());
                    }
                }
            }
            catch (EASBizException err) {
                throw new BOSException(err.getMessage());
            }
        }
        return personInfo;
    }

    public static int getPriority(PriorityEnum priority) {
        switch (priority.getValue()) {
            case 0: {
                return 0;
            }
            case 10: {
                return 10;
            }
            case 20: {
                return 20;
            }
        }
        return 10;
    }

    public static PriorityEnum getPriorityEnum(int priority) {
        switch (priority) {
            case 0: {
                return PriorityEnum.LOW;
            }
            case 10: {
                return PriorityEnum.COMMON;
            }
            case 20: {
                return PriorityEnum.HIGHT;
            }
        }
        return PriorityEnum.COMMON;
    }

    public static String[] getCommandParams(String content) {
        content = content.replaceAll("\u3000", " ");
        String[] contentStr = content.split(" ");
        ArrayList<String> contentsList = new ArrayList<String>(contentStr.length);
        for (int i = 0; i < contentStr.length; ++i) {
            if (StringUtils.isEmpty((String)contentStr[i])) continue;
            contentsList.add(contentStr[i]);
        }
        if (contentsList.size() < 1) {
            return null;
        }
        String[] contents = new String[contentsList.size()];
        for (int i = 0; i < contentsList.size(); ++i) {
            contents[i] = contentsList.get(i).toString();
        }
        return contents;
    }

    public static void sendBOSMessage(Context ctx, Message msg) {
        try {
            IMobileConfig iMobileConfig = MobileConfigFactory.getLocalInstance(ctx);
            MobileConfigCollection mobileConfigs = iMobileConfig.getMobileConfigCollection();
            MobileConfigInfo mobileConfigInfo = null;
            boolean isEmailEnable = false;
            boolean isRTXEnable = false;
            boolean isSMSEnable = false;
            logger.info((Object)("---mobile---AppMsgUtil--" + mobileConfigs.size()));
            if (mobileConfigs.size() > 0) {
                mobileConfigInfo = mobileConfigs.get(0);
                switch (mobileConfigInfo.getChannels()) {
                    case 1: {
                        isEmailEnable = true;
                        isRTXEnable = false;
                        isSMSEnable = false;
                        break;
                    }
                    case 2: {
                        isEmailEnable = false;
                        isRTXEnable = true;
                        isSMSEnable = false;
                        break;
                    }
                    case 3: {
                        isEmailEnable = true;
                        isRTXEnable = true;
                        isSMSEnable = false;
                        break;
                    }
                    case 4: {
                        isEmailEnable = false;
                        isRTXEnable = false;
                        isSMSEnable = true;
                        break;
                    }
                    case 5: {
                        isEmailEnable = true;
                        isRTXEnable = false;
                        isSMSEnable = true;
                        break;
                    }
                    case 6: {
                        isEmailEnable = false;
                        isRTXEnable = true;
                        isSMSEnable = true;
                        break;
                    }
                    case 7: {
                        isEmailEnable = true;
                        isRTXEnable = true;
                        isSMSEnable = true;
                        break;
                    }
                    default: {
                        isEmailEnable = false;
                        isRTXEnable = false;
                        isSMSEnable = false;
                    }
                }
                logger.info((Object)("---mobile---AppMsgUtil--Channels-" + mobileConfigInfo.getChannels()));
                String sendEmail = msg.getStringHeader("isSendEmail");
                String sendMobile = msg.getStringHeader("isSendMobile");
                boolean isSendEmailByWF = Boolean.valueOf(sendEmail);
                boolean isSendMobileByWF = Boolean.valueOf(sendMobile);
                isEmailEnable = isEmailEnable && isSendEmailByWF;
                isSMSEnable = isSMSEnable && isSendMobileByWF;
                logger.info((Object)("---mobile---AppMsgUtil--sendEmail=" + sendEmail + "\n"));
                logger.info((Object)("---mobile---AppMsgUtil--sendMobile=" + sendMobile + "\n"));
                logger.info((Object)("---mobile---AppMsgUtil--isSendEmailByWF=" + isSendEmailByWF + "\n"));
                logger.info((Object)("---mobile---AppMsgUtil--isSendMobileByWF=" + isSendMobileByWF + "\n"));
                String receiver = msg.getStringHeader("receiver");
                String[] receivers = StringUtil.split((String)receiver, (String)";");
                logger.info((Object)("---mobile---AppMsgUtil--receivers=" + receivers + " receivers.length=" + receivers.length));
                SendMobileMessageCollection sendMoMsgs = new SendMobileMessageCollection();
                EmailSendMessageCollection sendEmailMsgs = new EmailSendMessageCollection();
                PersonInfo personInfo = null;
                String userId = null;
                for (int i = 0; receivers != null && i < receivers.length; ++i) {
                    userId = receivers[i];
                    personInfo = AppMsgUtil.getPersonByUserId(ctx, userId);
                    logger.info((Object)("---mobile---AppMsgUtil--userId= " + userId + "personInfo=" + personInfo + " i=" + i));
                    if (personInfo == null) continue;
                    AppMsgUtil.generateSendUserMsgs(ctx, sendMoMsgs, sendEmailMsgs, msg, userId, personInfo, isEmailEnable, isRTXEnable, isSMSEnable);
                }
                logger.info((Object)("---mobile---AppMsgUtil--sendMoMsgsSize=" + sendMoMsgs.size()));
                if (isSendMobileByWF && sendMoMsgs.size() > 0) {
                    DefaultSendMoMsgDao.addNew(ctx, sendMoMsgs);
                }
                logger.info((Object)("---mobile---AppMsgUtil--sendEmailMsgsSize=" + sendEmailMsgs.size()));
                if (isSendEmailByWF && sendEmailMsgs.size() > 0) {
                    DefaultEmailMessageDAO.addNew(ctx, sendEmailMsgs);
                }
            }
        }
        catch (Exception err) {
            logger.info((Object)("\u4fdd\u5b58mobile\u6d88\u606f\u5217\u8868\u5f02\u5e38" + err.getMessage()));
            err.printStackTrace();
        }
    }

    private static void generateSendUserMsgs(Context ctx, SendMobileMessageCollection sendMoMsgs, EmailSendMessageCollection sendEmailMsgs, Message msg, String userId, PersonInfo personInfo, boolean isEmailEnable, boolean isRTXEnable, boolean isSMSEnable) throws BOSException, EASBizException {
        CoreMessageAddressInfo addressInfo;
        logger.info((Object)("---mobile---AppMsgUtil--psCell()=" + personInfo.getCell() + "\n"));
        logger.info((Object)("---mobile---AppMsgUtil--psEmail=" + personInfo.getEmail() + "\n"));
        logger.info((Object)("---mobile---AppMsgUtil--psRtx=" + personInfo.getRtx() + "\n"));
        if (StringUtils.isEmpty((String)personInfo.getCell()) && StringUtils.isEmpty((String)personInfo.getEmail()) && StringUtils.isEmpty((String)personInfo.getRtx())) {
            logger.info((Object)"---mobile---AppMsgUtil--the person's msgAdress is null!-return--- \n");
            return;
        }
        String title = msg.getLocaleStringHeader("title", ctx.getLocale());
        logger.info((Object)("---mobile---AppMsgUtil--title= " + title + "\n"));
        StringBuffer content = new StringBuffer(msg.getLocaleStringHeader("body", ctx.getLocale()));
        logger.info((Object)("---mobile---AppMsgUtil--content= " + content + "\n"));
        String assignmentId = MessageConstant.getAssignmentId(msg);
        logger.info((Object)("---mobile---AppMsgUtil--assignmentId= " + assignmentId + "\n"));
        if (StringUtils.isEmpty((String)title) && StringUtils.isEmpty((String)content.toString())) {
            return;
        }
        int msgType = msg.getIntHeader("type");
        boolean isRevertible = msgType == 10;
        int priority = msg.getIntHeader("priority");
        logger.info((Object)("---mobile---AppMsgUtil--msgType= " + msgType + " isRevertible=" + isRevertible + " priority" + priority + "\n"));
        UserMessageConfigInfo userMsgConfigInfo = DefaultMsgDAO.getUserMessageConfigInfoByUserId(ctx, userId);
        logger.info((Object)("---mobile---AppMsgUtil--userMsgConfigInfo= " + userMsgConfigInfo + "\n"));
        if (userMsgConfigInfo == null) {
            userMsgConfigInfo = new UserMessageConfigInfo();
            userMsgConfigInfo.setReceiveCommon(7);
            userMsgConfigInfo.setReceiveImportant(7);
        }
        boolean canUserReceiveEmailMsg = true;
        boolean canUserReceiveRTXMsg = true;
        boolean canUserReceiveMoMsg = true;
        if (priority >= 20) {
            logger.info((Object)("---mobile---AppMsgUtil--getReceiveImportant--" + userMsgConfigInfo.getReceiveImportant()));
            switch (userMsgConfigInfo.getReceiveImportant()) {
                case 1: {
                    canUserReceiveEmailMsg = true;
                    canUserReceiveRTXMsg = false;
                    canUserReceiveMoMsg = false;
                }
                case 2: {
                    canUserReceiveEmailMsg = false;
                    canUserReceiveRTXMsg = true;
                    canUserReceiveMoMsg = false;
                    break;
                }
                case 3: {
                    canUserReceiveEmailMsg = true;
                    canUserReceiveRTXMsg = true;
                    canUserReceiveMoMsg = false;
                    break;
                }
                case 4: {
                    canUserReceiveEmailMsg = false;
                    canUserReceiveRTXMsg = false;
                    canUserReceiveMoMsg = true;
                    break;
                }
                case 5: {
                    canUserReceiveEmailMsg = true;
                    canUserReceiveRTXMsg = false;
                    canUserReceiveMoMsg = true;
                    break;
                }
                case 6: {
                    canUserReceiveEmailMsg = false;
                    canUserReceiveRTXMsg = true;
                    canUserReceiveMoMsg = true;
                    break;
                }
                case 7: {
                    canUserReceiveEmailMsg = true;
                    canUserReceiveRTXMsg = true;
                    canUserReceiveMoMsg = true;
                    break;
                }
                default: {
                    canUserReceiveEmailMsg = false;
                    canUserReceiveRTXMsg = false;
                    canUserReceiveMoMsg = false;
                    break;
                }
            }
        } else {
            logger.info((Object)("---mobile---AppMsgUtil--getReceiveCommon--" + userMsgConfigInfo.getReceiveCommon()));
            switch (userMsgConfigInfo.getReceiveCommon()) {
                case 1: {
                    canUserReceiveEmailMsg = true;
                    canUserReceiveRTXMsg = false;
                    canUserReceiveMoMsg = false;
                    break;
                }
                case 2: {
                    canUserReceiveEmailMsg = false;
                    canUserReceiveRTXMsg = true;
                    canUserReceiveMoMsg = false;
                    break;
                }
                case 3: {
                    canUserReceiveEmailMsg = true;
                    canUserReceiveRTXMsg = true;
                    canUserReceiveMoMsg = false;
                    break;
                }
                case 4: {
                    canUserReceiveEmailMsg = false;
                    canUserReceiveRTXMsg = false;
                    canUserReceiveMoMsg = true;
                    break;
                }
                case 5: {
                    canUserReceiveEmailMsg = true;
                    canUserReceiveRTXMsg = false;
                    canUserReceiveMoMsg = true;
                    break;
                }
                case 6: {
                    canUserReceiveEmailMsg = false;
                    canUserReceiveRTXMsg = true;
                    canUserReceiveMoMsg = true;
                    break;
                }
                case 7: {
                    canUserReceiveEmailMsg = true;
                    canUserReceiveRTXMsg = true;
                    canUserReceiveMoMsg = true;
                    break;
                }
                default: {
                    canUserReceiveEmailMsg = false;
                    canUserReceiveRTXMsg = false;
                    canUserReceiveMoMsg = false;
                }
            }
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        String orgId = msg.getStringHeader("orgId") != null ? msg.getStringHeader("orgId") : "";
        logger.info((Object)("---mobile---AppMsgUtil--orgId= " + orgId + "\n"));
        FullOrgUnitInfo fullOrgUnitInfo = null;
        CtrlUnitInfo ctrlUnitInfo = null;
        if (!StringUtils.isEmpty((String)orgId)) {
            fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)));
            logger.info((Object)("---mobile---AppMsgUtil--fullOrgUnitInfo= " + fullOrgUnitInfo + "\n"));
            if (fullOrgUnitInfo != null) {
                ctrlUnitInfo = fullOrgUnitInfo.getCU();
                logger.info((Object)("---mobile---AppMsgUtil--ctrlUnitInfo= " + ctrlUnitInfo + "\n"));
            }
        }
        logger.info((Object)("---mobile---AppMsgUtil--isSMSEnable= " + isSMSEnable + " canUserReceiveMoMsg= " + canUserReceiveMoMsg + " Cell= " + personInfo.getCell() + " title= " + title + "\n"));
        if (isSMSEnable && canUserReceiveMoMsg && (!StringUtils.isEmpty((String)personInfo.getCell()) || !StringUtils.isEmpty((String)title))) {
            SendMobileMessageInfo sendMoMsgInfo = new SendMobileMessageInfo();
            addressInfo = new MobileMessageAddressInfo();
            addressInfo.setReceiveBizUser(userInfo);
            String cellNumber = personInfo.getCell();
            ((AbstractMobileMessageAddressInfo)addressInfo).setReceiveMobileNumber(cellNumber);
            ((AbstractMobileMessageAddressInfo)addressInfo).setReceiveCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(cellNumber)));
            if (!StringUtils.isEmpty((String)orgId)) {
                addressInfo.setSendOrgId(orgId);
                if (ctrlUnitInfo != null) {
                    addressInfo.setCU(ctrlUnitInfo);
                    sendMoMsgInfo.setCU(ctrlUnitInfo);
                }
            }
            sendMoMsgInfo.setAddress((MobileMessageAddressInfo)addressInfo);
            if (priority >= 20) {
                sendMoMsgInfo.setPriority(PriorityEnum.HIGHT);
            } else {
                sendMoMsgInfo.setPriority(PriorityEnum.COMMON);
            }
            logger.info((Object)("---mobile---AppMsgUtil--type= " + msg.getIntHeader("type") + "\n"));
            if (msg.getIntHeader("type") == 10 && !AppMsgUtil.disableSMSApprove(ctx)) {
                logger.info((Object)"---mobile---AppMsgUtil--.....");
                String decision = null;
                if (!StringUtils.isEmpty((String)assignmentId)) {
                    try {
                        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
                        decision = service.getMultiApproveDecision(assignmentId);
                        logger.info((Object)("---mobile---decision--" + decision));
                    }
                    catch (WfException e) {
                        logger.error((Object)"getMultiApproveDecision throws WfException!", (Throwable)e);
                    }
                }
                if (!StringUtils.isEmpty(decision)) {
                    String tips = AppMsgUtil.constructMessage(decision);
                    title = title + "\uff0c\u76f4\u63a5\u56de\u590d\u6570\u5b57\uff1a" + tips;
                    content.append("\uff0c\u76f4\u63a5\u56de\u590d\u6570\u5b57\uff1a").append(tips);
                } else {
                    String tip = "\uff0c\u76f4\u63a5\u56de\u590d\u6570\u5b57\uff1a1:\u540c\u610f;2:\u4e0d\u540c\u610f";
                    title = title + tip;
                    content.append(tip);
                }
            }
            sendMoMsgInfo.setContent(content.toString());
            sendMoMsgInfo.setTitle(title);
            sendMoMsgInfo.setAssignID(assignmentId);
            sendMoMsgInfo.setRevertible(isRevertible);
            sendMoMsgs.add(sendMoMsgInfo);
        }
        if (!(!isEmailEnable || !canUserReceiveEmailMsg || StringUtils.isEmpty((String)personInfo.getEmail()) || StringUtils.isEmpty((String)title) && StringUtils.isEmpty((String)content.toString()))) {
            Configuration bosConfig;
            ConfigurationItem sln;
            EmailSendMessageInfo emailSendMsgInfo = new EmailSendMessageInfo();
            addressInfo = new EmailAddressInfo();
            addressInfo.setReceiveBizUser(userInfo);
            ((AbstractEmailAddressInfo)addressInfo).setTo(personInfo.getEmail());
            if (!StringUtils.isEmpty((String)orgId)) {
                addressInfo.setSendOrgId(orgId);
                if (ctrlUnitInfo != null) {
                    addressInfo.setCU(ctrlUnitInfo);
                    emailSendMsgInfo.setCU(ctrlUnitInfo);
                }
            }
            emailSendMsgInfo.setAddress((EmailAddressInfo)addressInfo);
            if (priority >= 20) {
                emailSendMsgInfo.setPriority(PriorityEnum.HIGHT);
            } else {
                emailSendMsgInfo.setPriority(PriorityEnum.COMMON);
            }
            boolean isRevertibleEmail = isRevertible;
            if (msg.getIntHeader("type") == 10 && (sln = (bosConfig = Configuration.getInstance()).getConfigItem("PortalInfo")) != null) {
                String isAllowEMailAudit = sln.getProperty("isAllowEMailAudit");
                if (isAllowEMailAudit == null || !isAllowEMailAudit.trim().equalsIgnoreCase("true")) {
                    isRevertibleEmail = false;
                }
                AppMsgUtil.appendOtherNotice(ctx.getLocale(), content, sln);
            }
            if (content.length() <= 2000) {
                emailSendMsgInfo.setContent(content.toString());
            } else {
                emailSendMsgInfo.setLongContent(content.toString());
            }
            emailSendMsgInfo.setTitle(title);
            emailSendMsgInfo.setRevertible(isRevertibleEmail);
            emailSendMsgInfo.setAssignID(assignmentId);
            emailSendMsgInfo.setMimeType(MimeTypeEnum.HTML);
            sendEmailMsgs.add(emailSendMsgInfo);
        }
    }

    public static boolean disableSMSApprove(Context ctx) throws BOSException {
        return AppMsgUtil.paramValueIsTrue("DisableSMSApprove", ctx);
    }

    public static boolean paramValueIsTrue(String param, Context ctx) throws BOSException {
        if (StringUtils.isEmpty((String)param)) {
            return false;
        }
        String result = null;
        try {
            result = ParamManager.getParamValue((Context)ctx, null, (String)param);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result != null && result.equalsIgnoreCase("true");
    }

    public static String constructMessage(String decisions) {
        String[] items = StringUtils.split((String)decisions, (String)":");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            String[] item = StringUtils.split((String)items[i], (String)";");
            if (item.length < 3) continue;
            if ("\u540c\u610f".equals(item[2]) || "\u5168\u90e8".equals(item[2])) {
                if (sb.length() > 0) {
                    sb.append("\uff1b");
                }
                sb.append("1");
                sb.append(item[0]).append("\uff1a\u540c\u610f\uff0c").append(item[1]);
            }
            if (!"\u4e0d\u540c\u610f".equals(item[2]) && !"\u5168\u90e8".equals(item[2])) continue;
            if (sb.length() > 0) {
                sb.append("\uff1b");
            }
            sb.append("2");
            sb.append(item[0]).append("\uff1a\u4e0d\u540c\u610f\uff0c").append(item[1]);
        }
        return sb.toString();
    }

    public static void appendOtherNotice(Locale locale, StringBuffer content, ConfigurationItem sln) {
        String isAppend = sln.getProperty("isAppendOtherNotice");
        logger.info((Object)"-----AppMsgUtil----");
        if (isAppend != null && isAppend.trim().equalsIgnoreCase("false")) {
            logger.info((Object)"----return----");
            return;
        }
        logger.info((Object)("-----isAppendOtherNotice=" + isAppend + "-----"));
        String url = sln.getProperty("host");
        String port = sln.getProperty("port");
        String context = sln.getProperty("contextroot");
        String isAllowEMailAudit = sln.getProperty("isAllowEMailAudit");
        String rederectTo = sln.getProperty("rederectTo");
        if (isAllowEMailAudit != null && isAllowEMailAudit.trim().equalsIgnoreCase("true")) {
            content.append(ResourceBase.getString((String)RESOURCE, (String)"HIT_TO_EMAIL_AUDIT", (Locale)locale));
            if (url != null && port != null && url.trim().length() > 0 && port.trim().length() > 0 && context != null && rederectTo != null && rederectTo.length() > 0) {
                String contentURI = "http://" + url + ":" + port + context + rederectTo;
                content.append(contentURI).append("'>").append(contentURI).append("</a>");
                content.append(ResourceBase.getString((String)RESOURCE, (String)"TO_EAS_AUDIT", (Locale)locale));
            }
        }
    }

    public static int countSplitNumber(String content) {
        int defaultSplitNumber = 1;
        if (StringUtils.isEmpty((String)content)) {
            return defaultSplitNumber;
        }
        int length = content.length();
        if (length <= 70) {
            return defaultSplitNumber;
        }
        int splitNumber = length / 70;
        if (length % 70 > 0) {
            ++splitNumber;
        }
        return splitNumber;
    }

    public static String getMaxMsgIdInGateway(Context ctx) throws BOSException {
        String sendIndexSql = "SELECT TOP 1 FMsgIdInGateway FROM T_MO_SendMoMsg WHERE FRevertible=1 AND FSent=1 ORDER BY FCreateTime DESC";
        IRowSet sendIndexRows = DbUtil.executeQuery((Context)ctx, (String)sendIndexSql);
        try {
            if (sendIndexRows.next()) {
                String sendIndex = sendIndexRows.getString(1);
                logger.info((Object)("AppMsgUtil-getMaxMsgIdInGateway return:" + sendIndex));
                return sendIndex;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("AppMsgUtil-getMaxMsgIdInGateway error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)"AppMsgUtil-getMaxMsgIdInGateway return null");
        return null;
    }

    public static String getMsgId4ReceiveMsg(Context ctx, String msgIdInGateway) throws BOSException {
        String msgIdSql = "SELECT TOP 1 FMsgID FROM T_MO_SendMoMsg WHERE FMsgIdInGateway=? AND FSent=1 ORDER BY FCreateTime DESC";
        IRowSet msgIdSqlRows = DbUtil.executeQuery((Context)ctx, (String)msgIdSql, (Object[])new Object[]{msgIdInGateway});
        try {
            if (msgIdSqlRows.next()) {
                String msgId = msgIdSqlRows.getString(1);
                logger.info((Object)("AppMsgUtil-getMsgId4ReceiveMsg return:" + msgId));
                return msgId;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("getMsgId4ReceiveMsg error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)"AppMsgUtil-getMsgId4ReceiveMsg return null");
        return null;
    }

    public static void main(String[] args) {
        String decision = "";
        String msg = AppMsgUtil.constructMessage(decision);
        System.out.println(msg);
        decision = "0;\u65e0;\u5168\u90e8;:1;\u6253\u56de\u4fee\u6539;\u4e0d\u540c\u610f;:2;\u4e2d\u6b62\u7533\u8bf7;\u4e0d\u540c\u610f;:3;\u7533\u8bf7\u8005\u51b3\u5b9a;\u4e0d\u540c\u610f;";
        msg = AppMsgUtil.constructMessage(decision);
        System.out.println(msg);
    }
}

