/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.framework.AbastractMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.ByteArrayDataSource;
import com.kingdee.eas.mobile.util.MailServerConfigPropUtil;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Logger;

public class MailUtil {
    private static final Logger logger = Logger.getLogger(AbastractMobileGatewayProvider.class);

    public static boolean sendMail(Context ctx, String title, String content, MimeTypeEnum contentMimeType, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", MailServerConfigPropUtil.getSmtpHost());
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.port", MailServerConfigPropUtil.getSmtpPort());
        props.setProperty("mail.smtp.socketFactory.port", MailServerConfigPropUtil.getSmtpPort());
        String smtpAuthEnable = MailServerConfigPropUtil.getSmtpAuthEnable();
        if ("true".equals(smtpAuthEnable)) {
            props.put("mail.smtp.auth", "true");
        } else {
            props.put("mail.smtp.auth", "false");
        }
        String sslEnable = MailServerConfigPropUtil.getSslEnable();
        String tlsEnable = MailServerConfigPropUtil.getTlsEnable();
        String tls2Enable = MailServerConfigPropUtil.getTls2Enable();
        if ("true".equals(sslEnable)) {
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        if ("true".equals(tlsEnable)) {
            props.put("mail.smtp.starttls.enable", "true");
            logger.error((Object)"tlsEnable open");
            if ("true".equals(tls2Enable)) {
                logger.error((Object)"TLSv1.2 open");
                props.put("mail.smtp.ssl.protocols", "TLSv1.2");
            }
        }
        props.put("mail.smtp.connectiontimeout", "15000");
        props.put("mail.smtp.timeout", "15000");
        props.put("mail.smtp.writetimeout", "15000");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailServerConfigPropUtil.getUsername(), MailServerConfigPropUtil.getPassword());
            }
        });
        session.setDebug(false);
        MimeMessage msg = null;
        try {
            int i;
            msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(MailServerConfigPropUtil.getMailFromAccount(), MailServerConfigPropUtil.getMailFromUsername()));
            String[] toMailArray = receiver.split(";");
            InternetAddress[] tos = new InternetAddress[toMailArray.length];
            for (int i2 = 0; i2 < toMailArray.length; ++i2) {
                String to = toMailArray[i2];
                tos[i2] = new InternetAddress(to);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])tos);
            if (copyReceiver != null && !"".equals(copyReceiver)) {
                String[] ccMailArray = copyReceiver.split(";");
                InternetAddress[] ccs = new InternetAddress[ccMailArray.length];
                for (i = 0; i < ccMailArray.length; ++i) {
                    String cc = ccMailArray[i];
                    ccs[i] = new InternetAddress(cc);
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccs);
            }
            if (secretReceiver != null && !"".equals(secretReceiver)) {
                String[] bccMailArray = secretReceiver.split(";");
                InternetAddress[] bccs = new InternetAddress[bccMailArray.length];
                for (i = 0; i < bccMailArray.length; ++i) {
                    String bcc = bccMailArray[i];
                    bccs[i] = new InternetAddress(bcc);
                }
                msg.setRecipients(Message.RecipientType.BCC, (Address[])bccs);
            }
            String stitle = "No Title.";
            if (title == null || title.equals("")) {
                logger.info((Object)"MailUtil-mail title is null");
            } else {
                stitle = title;
            }
            msg.setSubject(stitle);
            MimeBodyPart mbp1 = new MimeBodyPart();
            String contentType = null;
            contentType = MimeTypeEnum.HTML.equals((Object)contentMimeType) ? "text/html;charset=UTF-8" : "text/plain;charset=UTF-8";
            String scontent = "No Content.";
            if (content == null || content.equals("")) {
                if (!stitle.equals("No Title.")) {
                    scontent = stitle;
                }
                logger.info((Object)"MailUtil-mail content is null");
            } else {
                scontent = content;
            }
            mbp1.setContent((Object)scontent, contentType);
            MimeMultipart mp = new MimeMultipart();
            if (attachment != null && attachment.length > 0) {
                for (int i3 = 0; i3 < attachment.length; ++i3) {
                    KDMessageAttachment attachmentItem = attachment[i3];
                    if (attachmentItem.getData() != null) {
                        String fileName = attachmentItem.getName();
                        if (fileName == null || "".equals(fileName.trim())) {
                            fileName = "noname";
                            logger.info((Object)"MailUtil-attachment: attachment name is null");
                        }
                        fileName = MimeUtility.encodeText((String)fileName);
                        MimeBodyPart mbp2 = new MimeBodyPart();
                        DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(attachmentItem.getData(), "application/octet-stream", fileName));
                        mbp2.setDataHandler(dh);
                        mbp2.setFileName(fileName);
                        mbp2.setHeader("Content-ID", fileName);
                        mp.addBodyPart((BodyPart)mbp2);
                        continue;
                    }
                    logger.info((Object)"MailUtil-attachment warning: attachment data is null");
                }
            }
            mp.addBodyPart((BodyPart)mbp1);
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            Exception nextException = mex.getNextException();
            if (nextException instanceof SendFailedException) {
                SendFailedException sendFail = (SendFailedException)nextException;
                Address[] validSentAddresses = sendFail.getValidSentAddresses();
                try {
                    msg.setRecipients(Message.RecipientType.CC, new Address[0]);
                    msg.setRecipients(Message.RecipientType.BCC, validSentAddresses);
                    Transport.send((Message)msg);
                }
                catch (MessagingException e) {
                    logger.error((Object)("MailUtil-sendMail error:" + e.getMessage()));
                    throw new BOSException((Throwable)e);
                }
            }
            logger.error((Object)("MailUtil-sendMail error:" + mex.getMessage()));
            throw new BOSException((Throwable)mex);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("MailUtil-sendMail error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static void main(String[] args) throws EASBizException, BOSException {
        System.setProperty("EAS_HOME", "D:/pt/701/eas/Server");
        MailUtil.sendMail(null, "mail title\u6807\u9898", "content\u5185\u5bb9", MimeTypeEnum.HTML, "royce_peng@kdsv.kingdee.com", null, null, null);
        MailUtil.sendMail(null, "mail title plain text\u6807\u9898", "content\u5185\u5bb9", MimeTypeEnum.TEXT, "royce_peng@kdsv.kingdee.com", null, null, null);
    }
}

