/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.data;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Def;
import com.kingdee.bos.ctrl.data.modal.io.XmlTool;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class OutputXmlTool {
    public static final Logger log = LogUtil.getPackageLogger(OutputXmlTool.class);
    public static final String A_NAME = "name";
    public static final String A_ORDER_PRI = "order";
    public static final String A_ORDER_ASC = "asc";
    public static final String T_COLUMN = "Column";
    public static final String T_COLUMNS = "Columns";
    public static final String T_OUTPUTS = "Outputs";

    public static final Element toXml(Outputs outputs) {
        Element e = new Element(T_OUTPUTS);
        for (Object obj : outputs) {
            Element eChild = OutputXmlTool.toXml(obj);
            if (eChild == null) continue;
            e.addContent(eChild);
        }
        return e;
    }

    public static final Element toXml(Object obj) {
        OutputColumns fields = (OutputColumns)obj;
        Element e = new Element(T_COLUMNS);
        if (fields != null) {
            try {
                return XmlTool.list2Xml((String)T_COLUMNS, (List)fields, OutputColumn2Xml.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return e;
    }

    public static final OutputColumns toObject(Element e) {
        OutputColumns fields = new OutputColumns();
        try {
            fields.addAll((Collection)XmlTool.xml2List((Element)e, (String)T_COLUMN, Xml2OutputColumn.class));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return fields;
    }

    public static Element makeColumn(Column col) {
        Element xmlCol = new Element(T_COLUMN);
        if (col != null) {
            String s;
            OutputXmlTool.makeDefObj((IDefObj)col, xmlCol);
            if (col.getDataType() != null) {
                xmlCol.setAttribute("dataType", col.getDataType().getName());
            }
            if (!StringUtil.isEmptyString((String)(s = col.getExpr()))) {
                xmlCol.setAttribute("expr", s);
            }
        }
        return xmlCol;
    }

    public static void makeDefObj(IDefObj obj, Element xmlObj) {
        String s = obj.getName();
        assert (s != null);
        if (s != null) {
            xmlObj.setAttribute(A_NAME, s);
        }
        Map ps = obj.getProperties();
        OutputXmlTool.makeProperties(new String[]{"align", "decimalPlace"}, ps, xmlObj);
        LangUtil.saveProperty((String)"alias", (Map)ps, (Element)xmlObj);
        LangUtil.saveProperty((String)"desc", (Map)ps, (Element)xmlObj);
    }

    public static void makeProperties(String[] names, Map ps, Element xml) {
        for (int i = 0; i < names.length; ++i) {
            if (!ps.containsKey(names[i])) continue;
            xml.setAttribute(names[i], ps.get(names[i]).toString());
        }
    }

    public static Column parseColumn(Element xmlCol) {
        Column col = new Column();
        OutputXmlTool.parseDefObj((IDefObj)col, xmlCol);
        col.setDataType(DataType.fromName((String)xmlCol.getAttributeValue("dataType")));
        col.setExpr(xmlCol.getAttributeValue("expr"));
        return col;
    }

    public static void parseDefObj(IDefObj obj, Element xmlObj) {
        obj.setName(xmlObj.getAttributeValue(A_NAME));
        Map ps = obj.getProperties();
        Xml2Def.parseProperties((String[])new String[]{"align", "decimalPlace"}, (Map)ps, (Element)xmlObj);
        LangUtil.loadProperty((String)"alias", (Map)ps, (Element)xmlObj);
        LangUtil.loadProperty((String)"desc", (Map)ps, (Element)xmlObj);
    }

    public static final class Xml2OutputColumn {
        public static final OutputColumn toObject(Element e) {
            String orderPri;
            Column col = OutputXmlTool.parseColumn(e);
            OutputColumn oc = new OutputColumn(col);
            String orderAsc = e.getAttributeValue(OutputXmlTool.A_ORDER_ASC);
            if (orderAsc != null) {
                oc.setOrderAsc(Integer.parseInt(orderAsc));
            }
            if ((orderPri = e.getAttributeValue(OutputXmlTool.A_ORDER_PRI)) != null) {
                oc.setOrderPri(Integer.parseInt(orderPri));
            }
            return oc;
        }
    }

    public static final class OutputColumn2Xml {
        public static final Element toXml(Object obj) {
            Element e = OutputXmlTool.makeColumn((Column)obj);
            if (OutputColumn.class.isInstance(obj)) {
                int order_asc;
                OutputColumn oc = (OutputColumn)obj;
                int order_pri = oc.getOrderPri();
                if (order_pri != -1) {
                    e.setAttribute(OutputXmlTool.A_ORDER_PRI, "" + order_pri);
                }
                if ((order_asc = oc.getOrderAsc()) != -1) {
                    e.setAttribute(OutputXmlTool.A_ORDER_ASC, "" + order_asc);
                }
            }
            return e;
        }
    }
}

