/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.exception.CycleException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class SqlDSModelDrill {
    private static final String META_SPLIT = "#@META_SPLIT@#";
    private static final String KEY_VALUE_SPLIT = "#@#@#";
    private static final String ID_NAME_SPLIT = "#";
    private static final String SQL_DS_PATTERN;
    private static final String SQL_DS_ID_PATTERN;
    private String _orgID;
    private String _systemID;
    private String _name;

    private SqlDSModelDrill(String orgID, String systemID, String name) {
        this._orgID = orgID;
        this._systemID = systemID;
        this._name = name;
    }

    public static SqlDSModelDrill getInst(String orgID, String systemID, String name) {
        return new SqlDSModelDrill(orgID, systemID, name);
    }

    public String drill(String xmlMeta) throws CycleException {
        return SqlDSModelDrill.drillOnly(xmlMeta, this._orgID);
    }

    public static String drillOnly(String xmlMeta, String OrgId) throws CycleException {
        if (StringUtil.isEmptyString((String)xmlMeta)) {
            return xmlMeta;
        }
        StringBuffer metaBuf = new StringBuffer(xmlMeta.length() * 2);
        metaBuf.append(xmlMeta);
        StringBuffer out = new StringBuffer(100);
        SqlDSModelDrill.analysis(xmlMeta, out, OrgId);
        if (!StringUtil.isEmptyString((String)out.toString())) {
            metaBuf.append(META_SPLIT);
            metaBuf.append(out.toString());
        }
        return metaBuf.toString();
    }

    public static Object[] split(String xmlMeta) {
        String[] metas = xmlMeta.split(META_SPLIT);
        HashMap<String, String> map = null;
        if (metas.length == 2) {
            String[] metaKVs = metas[1].split(KEY_VALUE_SPLIT);
            int len = metaKVs.length / 2 * 2;
            map = new HashMap<String, String>(len / 2);
            for (int i = 0; i < len; i += 2) {
                map.put(metaKVs[i], metaKVs[i + 1]);
            }
        }
        return new Object[]{metas[0], map};
    }

    public static String split2(String xmlMeta) {
        String[] metas = xmlMeta.split(META_SPLIT);
        return metas[0];
    }

    public static String replaceMainMeta(String xmlMeta, String mainMeta) {
        String[] metas = xmlMeta.split(META_SPLIT);
        if (metas.length == 1) {
            return mainMeta;
        }
        return mainMeta + META_SPLIT + metas[1];
    }

    public static String getName(String idMName) {
        return idMName.split(ID_NAME_SPLIT)[0];
    }

    public static String getID(String idMName) {
        return idMName.split(ID_NAME_SPLIT)[1];
    }

    public static String getKey(String name, String systemID) {
        return name + ID_NAME_SPLIT + systemID;
    }

    private static void analysis(String xmlMeta, StringBuffer out, String orgId) throws CycleException {
        int size;
        ArrayList list = new ArrayList(10);
        int lastIndex = SqlDSModelDrill.miningKeys(xmlMeta, list);
        for (int times = 0; times < 10 && (size = list.size()) > lastIndex; ++times) {
            for (int i = lastIndex; i < size; ++i) {
                String key = (String)list.get(i);
                String meta = SqlDSModelDrill.retrieve(key.split(ID_NAME_SPLIT), orgId);
                if (StringUtil.isEmptyString((String)meta)) continue;
                out.append(key);
                out.append(KEY_VALUE_SPLIT);
                out.append(meta);
                out.append(KEY_VALUE_SPLIT);
                lastIndex = SqlDSModelDrill.miningKeys(meta, list);
            }
        }
    }

    private void cycleCheck(ObjectStack os, String elem) throws CycleException {
        int size = os.size();
        for (int i = 0; i < size; ++i) {
            if (!elem.equals(os.getAt(i))) continue;
            os.push((Object)elem);
            ArrayList<String> objs = new ArrayList<String>(os.size());
            int jsize = os.size();
            for (int j = 0; j < jsize; ++j) {
                objs.add("\u6570\u636e\u96c6" + SqlDSModelDrill.getName((String)os.getAt(j)));
            }
            throw new CycleException(objs.toArray());
        }
    }

    private static String retrieve(String[] keys, String orgId) {
        CtrlDesignInputStream in = new CtrlDesignInputStream(null, keys[1], keys[0], orgId, orgId, true);
        if (in.isFound()) {
            return in.getXmlString();
        }
        return null;
    }

    private static int miningKeys(String xmlMeta, List keys) {
        int lastIndex = keys.size();
        SAXBuilder builder = new SAXBuilder(false);
        StringReader read = new StringReader(xmlMeta);
        Document doc = null;
        List metas = null;
        try {
            doc = builder.build((Reader)read);
            Element root = doc.getRootElement();
            metas = XPath.selectNodes((Object)root, (String)"/CommonQuery/Parameters/Parameter/InputCtrl");
            read.close();
            read = null;
            doc = null;
            builder = null;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (null != metas && !metas.isEmpty()) {
            for (Element node : metas) {
                String key;
                String dsName = node.getAttributeValue("defDbsourceName");
                if (null == dsName || !dsName.matches("[0-9A-Za-z+/=]{24,28}") || keys.contains(key = node.getAttributeValue("defDbsourceAlias") + ID_NAME_SPLIT + node.getAttributeValue("defDbsourceSystemID"))) continue;
                keys.add(key);
            }
        }
        return lastIndex;
    }

    static {
        StringBuffer pBuf = new StringBuffer(50);
        pBuf.append('<').append("InputCtrl").append("([^>]*?)");
        pBuf.append("dataBind").append("=\"4\"([^>]*?)((>.*?</");
        pBuf.append("InputCtrl").append(">)|(/>))");
        SQL_DS_PATTERN = pBuf.toString();
        pBuf = new StringBuffer(30);
        pBuf.append('(');
        pBuf.append("defDbsourceAlias").append("=\"([^> ]+)\"([^>]+)");
        pBuf.append("defDbsourceSystemID").append("=\"([^> ]+)\"");
        pBuf.append(')');
        SQL_DS_ID_PATTERN = pBuf.toString();
    }
}

