/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class SqlParamParser {
    private static final Logger logger = Logger.getLogger(SqlParamParser.class);
    public static final String reg_paramname_end = "[,|%|\\(|\\)|\\s|'|\"|@]";
    private static final String addEndString = " and 1=1";
    public static final String reg_paramname = "([A-Z|a-z|0-9|_])";

    public static final boolean isErrorParamName(String source) {
        boolean flag = false;
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            Pattern pattern = compiler.compile(reg_paramname, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            for (int i = 0; i < source.length(); ++i) {
                String str = source.substring(i, i + 1);
                PatternMatcherInput input = new PatternMatcherInput(str);
                if (matcher.contains(input, pattern)) continue;
                flag = true;
                break;
            }
        }
        catch (MalformedPatternException e) {
            flag = true;
            logger.error((Object)"SqlParamParser.isOKParamName", (Throwable)e);
        }
        return flag;
    }

    public static final String getValueByReg(String source, String strRegex) {
        String strRet = "";
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            Pattern pattern = compiler.compile(strRegex, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            PatternMatcherInput input = new PatternMatcherInput(source);
            MatchResult result = null;
            if (matcher.contains(input, pattern)) {
                result = matcher.getMatch();
                strRet = result.group(1);
                input.setCurrentOffset(strRet.length());
            }
        }
        catch (MalformedPatternException e) {
            logger.debug((Object)"SqlParamParser.getValueByReg", (Throwable)e);
        }
        return strRet;
    }

    public static final String replaceRNT2Empty(String source) {
        return source.replaceAll("\\r|\\n|\\t", " ");
    }

    public static final String customSQLReg(String source, HashMap mapParam, HashMap paramTypeMap, String paramName, Object[] paramValues) {
        Pattern pattern;
        source = SqlParamParser.replaceRNT2Empty(source);
        source = source.trim();
        StringBuffer sbSQL = new StringBuffer();
        StringBuffer newWhere = new StringBuffer();
        String reg = null;
        reg = source.endsWith("@" + paramName) ? "@(" + paramName + ")" : "@(" + paramName + ")" + reg_paramname_end;
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            pattern = compiler.compile(reg, 1);
        }
        catch (MalformedPatternException e) {
            logger.debug((Object)"SqlParamParser.customSQLReg", (Throwable)e);
            return source;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        PatternMatcherInput input = new PatternMatcherInput(source);
        MatchResult result = null;
        if (matcher.contains(input, pattern)) {
            result = matcher.getMatch();
            String curentName = result.group(1);
            input.setBeginOffset(result.length());
            if (paramName.equalsIgnoreCase(curentName)) {
                Pattern pattern3;
                String newParamName = paramName + String.valueOf(CtrlReportUtil.getSystemTime());
                Perl5Compiler compiler2 = null;
                Pattern pattern2 = null;
                Perl5Matcher matcher2 = null;
                PatternMatcherInput input2 = null;
                MatchResult result2 = null;
                boolean isAddEndFlag = false;
                while (true) {
                    String tmp = "@" + paramName + reg_paramname_end;
                    String reg2 = "(.+)\\s(where|or|and)(.+)(" + tmp + ")(.*)(or|and)\\s(.+)";
                    compiler2 = new Perl5Compiler();
                    try {
                        pattern2 = compiler2.compile(reg2, 1);
                    }
                    catch (MalformedPatternException e) {
                        logger.debug((Object)"SqlParamParser.customSQLReg", (Throwable)e);
                        return null;
                    }
                    matcher2 = new Perl5Matcher();
                    input2 = new PatternMatcherInput(source);
                    result2 = null;
                    if (matcher2.contains(input2, pattern2)) break;
                    if (isAddEndFlag) {
                        return source;
                    }
                    source = source + addEndString;
                    isAddEndFlag = true;
                }
                result2 = matcher2.getMatch();
                String sqlStart = result2.group(1);
                String whereOrAnd = result2.group(2);
                String expOperator = result2.group(3);
                String param = result2.group(4);
                String exp = result2.group(5);
                String whereOrAnd2 = result2.group(6);
                String sqlEnd = result2.group(7);
                String reg3 = "(.+)\\s+(=|>|<|>=|<=|in|like)\\s+(.*)";
                Perl5Compiler compiler3 = new Perl5Compiler();
                try {
                    pattern3 = compiler3.compile(reg3, 1);
                }
                catch (MalformedPatternException e) {
                    logger.debug((Object)"SqlParamParser.customSQLReg", (Throwable)e);
                    return null;
                }
                Perl5Matcher matcher3 = new Perl5Matcher();
                PatternMatcherInput input3 = new PatternMatcherInput(expOperator);
                MatchResult result3 = null;
                if (matcher3.contains(input3, pattern3)) {
                    result3 = matcher3.getMatch();
                    String expStart = result3.group(1);
                    String operator = result3.group(2);
                    String expEnd = result3.group(3);
                    StringBuffer newValue = new StringBuffer();
                    newValue.append(expEnd).append(param).append(exp);
                    if (operator.equalsIgnoreCase("IN")) {
                        newWhere.append(expStart).append(" ").append(operator).append(" (");
                        int length = paramValues.length;
                        for (int n = 0; n < length; ++n) {
                            String currentNewParamName = newParamName + "_" + n;
                            String newParamNameTemp = ExtStringUtil.replace(newValue.toString(), "@" + paramName, "@" + currentNewParamName);
                            newWhere.append(newParamNameTemp);
                            if (n < length - 1) {
                                newWhere.append(", ");
                            }
                            String paramValue = CtrlReportUtil.getObjectString(paramValues[n]);
                            mapParam.put(currentNewParamName, paramValue);
                            paramTypeMap.put(currentNewParamName, paramTypeMap.get(paramName));
                        }
                        newWhere.append(")");
                    } else {
                        newWhere.append("(");
                        int length = paramValues.length;
                        for (int n = 0; n < length; ++n) {
                            String currentNewParamName = newParamName + "_" + n;
                            String newParamNameTemp = ExtStringUtil.replace(newValue.toString(), "@" + paramName, "@" + currentNewParamName);
                            newWhere.append(expStart).append(" ").append(operator).append(" ").append(newParamNameTemp);
                            if (n < length - 1) {
                                newWhere.append(" OR ");
                            }
                            String paramValue = CtrlReportUtil.getObjectString(paramValues[n]);
                            mapParam.put(currentNewParamName, paramValue);
                            paramTypeMap.put(currentNewParamName, paramTypeMap.get(paramName));
                        }
                        newWhere.append(")");
                    }
                    if (isAddEndFlag) {
                        whereOrAnd2 = "";
                        sqlEnd = "";
                    }
                    sbSQL.append(sqlStart).append(" ").append(whereOrAnd).append(" ").append(newWhere).append(" ").append(whereOrAnd2).append(" ").append(sqlEnd);
                } else {
                    return null;
                }
            }
        }
        return CtrlReportUtil.trimStr(sbSQL.toString());
    }

    public static void main(String[] str) {
        String paraname = "name";
        String source = "() table where name = @name";
        Object[] obj = new String[]{"11", "22", "33"};
        String sql = SqlParamParser.customSQLReg(source, new HashMap(), new HashMap(), paraname, obj);
        System.out.println(sql);
        if (!source.endsWith("@" + paraname)) {
            try {
                String reg = "@" + paraname + "[,|\\(|\\)|\\s|'|\"]";
                String strRet = null;
                Perl5Compiler compiler = new Perl5Compiler();
                Pattern pattern = compiler.compile(reg);
                Perl5Matcher matcher = new Perl5Matcher();
                PatternMatcherInput input = new PatternMatcherInput(source);
                MatchResult result = null;
                Object strNum = null;
                if (matcher.contains(input, pattern)) {
                    result = matcher.getMatch();
                    strRet = result.group(0);
                    reg = "(.+)\\s(where|or|and)(.+)(" + reg + ")(.*)(or|and)\\s(.+)";
                    Perl5Compiler compiler2 = new Perl5Compiler();
                    Pattern pattern2 = compiler2.compile(reg);
                    Perl5Matcher matcher2 = new Perl5Matcher();
                    PatternMatcherInput input2 = new PatternMatcherInput(source);
                    MatchResult result2 = null;
                    Object strNum2 = null;
                    if (matcher2.contains(input2, pattern2)) {
                        result2 = matcher2.getMatch();
                        strRet = result2.group(3);
                        System.out.println(result2.groups());
                        String sqlStart = result2.group(1);
                        String whereOrAnd = result2.group(2);
                        String expOperator = result2.group(3);
                        String param = result2.group(4);
                        String exp = result2.group(5);
                        String whereOrAnd2 = result2.group(6);
                        String sqlEnd = result2.group(7);
                        for (int i = 0; i < result2.groups(); ++i) {
                            System.out.println(result2.group(i));
                        }
                        reg = "(.+)\\s+(=|>|<|>=|<=|in|like)\\s+(.*)";
                        Perl5Compiler compiler3 = new Perl5Compiler();
                        Pattern pattern3 = compiler3.compile(reg);
                        Perl5Matcher matcher3 = new Perl5Matcher();
                        PatternMatcherInput input3 = new PatternMatcherInput(strRet);
                        MatchResult result3 = null;
                        if (matcher3.contains(input3, pattern3)) {
                            result3 = matcher3.getMatch();
                            System.out.println("*************");
                            for (int i = 0; i < result3.groups(); ++i) {
                                System.out.println(result3.group(i));
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

