/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.openapi.OpenApiInfo;
import com.kingdee.bos.openapi.OpenApiLogFactory;
import com.kingdee.bos.openapi.OpenApiLogInfo;
import com.kingdee.bos.openapi.OpenApiTreeInfo;
import com.kingdee.bos.openapi.app.core.IOpenAPIMonitor;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import java.util.Date;
import org.apache.log4j.Logger;

public class OpenApiMonitor
implements IOpenAPIMonitor {
    private static final Logger logger = Logger.getLogger(OpenApiMonitor.class);

    @Override
    public void handle(Context ctx, OpenApiLogInfo logInfo) throws Exception {
        OpenApiInfo apiInfo = logInfo.getApiId();
        if (apiInfo == null) {
            return;
        }
        OpenApiTreeInfo treeInfo = apiInfo.getTreeid();
        if (treeInfo == null || !treeInfo.isLog()) {
            return;
        }
        OpenApiMonitorJobHandler handler = new OpenApiMonitorJobHandler(logInfo);
        Job job = new Job(ctx, (IJobHandler)handler, null, false);
        job.setScheduledTime(new Date(System.currentTimeMillis()));
        JobManager.instance().add(job);
    }

    private static class OpenApiMonitorJobHandler
    implements IJobHandler {
        private final OpenApiLogInfo logInfo;
        private static final long serialVersionUID = 1L;

        public OpenApiMonitorJobHandler(OpenApiLogInfo logInfo) {
            this.logInfo = logInfo;
        }

        public Object execute(Job job) throws Exception {
            try {
                OpenApiLogFactory.getLocalInstance(job.getContext()).save(this.logInfo);
            }
            catch (Exception ex) {
                logger.error((Object)"OpenApiMonitorJobHandler Error", (Throwable)ex);
            }
            return null;
        }
    }
}

