/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.mq.comsumer;

import com.kingdee.bos.Context;
import com.kingdee.bos.openapi.app.core.cache.SessionUtil;
import com.kingdee.bos.openapi.app.core.processor.OpenApiProcessor;
import com.kingdee.bos.openapi.common.IDataHandler;
import com.kingdee.bos.openapi.common.bo.InvocationMessage;
import com.kingdee.bos.openapi.common.bo.LoginType;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MessageConsumer {
    private static Logger logger = Logger.getLogger(MessageConsumer.class);
    protected Context ctx;
    protected IDataHandler dataHandler;
    protected InvocationMessage invocationMsg;
    protected String clientIp;
    protected OpenApiProcessor openapiProcessor = new OpenApiProcessor();

    public void init(byte[] reqBody) throws Exception {
        this.invocationMsg = this.dataHandler.toInvocationMessage(reqBody);
        Map<String, String> map = this.invocationMsg.getExtend();
        String loginType = map.get("loginType");
        String token = null;
        if (String.valueOf(LoginType.LTPA.getValue()).equals(loginType)) {
            String appid = map.get("appid");
            String dcName = map.get("dcName");
            String timestamp = map.get("timestamp");
            String signiture = map.get("signiture");
            String username = map.get("username");
            String language = map.get("language");
            String solution = map.get("solution");
            String isolation = map.get("isolation");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("%s,%s,%s,%s,%s,%s", appid, dcName, timestamp, signiture, username, language, solution, isolation, this.clientIp));
            }
            if (StringUtils.isEmpty((String)appid) || StringUtils.isEmpty((String)dcName) || StringUtils.isEmpty((String)timestamp) || StringUtils.isEmpty((String)signiture) || StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)language)) {
                throw new Exception("openapi error.fail to loginInvalid parameters");
            }
            long now = System.currentTimeMillis();
            long ts = Long.parseLong(timestamp);
            if (Math.abs(ts - now) > 3600000L) {
                throw new Exception("openapi error.fail to loginInvalid parameters");
            }
            token = SessionUtil.getTokenByLtpa(appid, dcName, signiture, username, language, solution, ts, this.clientIp, isolation);
        } else {
            String userName = map.get("user");
            String password = map.get("password");
            String dcName = map.get("dcName");
            String language = map.get("language");
            String slnName = map.get("slnName");
            String authPattern = map.get("authPattern");
            String appid = map.get("appid");
            String isolation = map.get("isolation");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("%s,%s,%s,%s", userName, dcName, language, this.clientIp, appid));
            }
            if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)dcName) || StringUtils.isEmpty((String)language)) {
                throw new Exception("openapi error.fail to loginInvalid parameters");
            }
            token = SessionUtil.getTokenId(userName, password, dcName, language, slnName, authPattern, this.clientIp, appid, isolation);
        }
        if (StringUtils.isEmpty((String)token)) {
            throw new Exception("openapi error.fail to login");
        }
        this.ctx = SessionUtil.getContextByToken(token);
        this.openapiProcessor.setCtx(this.ctx);
        this.openapiProcessor.setCharset("utf-8");
    }

    public void registerDataHandler(IDataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public abstract byte[] process() throws Exception;
}

