/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util.json.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.openapi.third.utils.Base64;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class ByteArrayTypeAdapter
implements JsonDeserializer<byte[]>,
JsonSerializer<byte[]> {
    public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
        String base64 = Base64.encodeBytes(src, false);
        try {
            return new JsonPrimitive(URLEncoder.encode(base64, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        try {
            byte[] base64 = Base64.decode(URLDecoder.decode(json.getAsString(), "utf-8"));
            return base64;
        }
        catch (Exception ex) {
            throw new JsonParseException((Throwable)ex);
        }
    }
}

