/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.f.advanced;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.f.advanced.MsgSender;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.var.SignalWhenDataChanged;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.model.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MsgReceiver
extends Feature {
    public static final String NAME = "message-receiver";
    private Map<VariableImpl<?>, VariableImpl<?>[]> receivers;
    private Map<String, String[]> def = new HashMap<String, String[]>();
    private boolean isSync;
    private Node.Stage stage;

    public MsgReceiver(Map<String, String[]> def, boolean isSync, Node.Stage stage) {
        this.def = def;
        this.isSync = isSync;
        this.stage = stage;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public Map<VariableImpl<?>, VariableImpl<?>[]> getReceivers() {
        return this.receivers;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getCategories() {
        return new String[]{"receiver"};
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public void preHandle(NodeImpl node) {
    }

    @Override
    public void postHandle(NodeImpl node) {
        this.receivers = Collections.unmodifiableMap(MsgSender.check(node, this.def));
        if (this.isSync) {
            for (VariableImpl<?> msg : this.receivers.keySet()) {
                SignalWhenDataChanged.insert(msg, node);
            }
        }
        switch (this.stage) {
            case BEFORE_READY: {
                node.insert(NIS.RECEIVE_MSG_BEFORE_READY);
                break;
            }
            case BEFORE_CHILDREN_STARTED: {
                node.insert(NIS.RECEIVE_MSG_BEFORE_CHILDREN_STARTED);
                break;
            }
            case BEFORE_CLOSED: {
                node.insert(NIS.RECEIVE_MSG_BEFORE_COMPLETED);
                break;
            }
            case BEFORE_TRANSFERRING: {
                node.insert(NIS.RECEIVE_MSG_BEFORE_TRANSFERRING);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

