/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.f.advanced;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.f.advanced.SetAsCallee;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.Output;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;

public class SetAsCaller
extends Feature {
    public static final String NAME = "set-as-caller";
    private String[] paramVarNames;
    private String[] returnVarNames;
    private VariableImpl<?>[] paramVars;
    private VariableImpl<?>[] returnVars;
    private NodeImpl target;
    private String targetId;

    public SetAsCaller(String targetId, String[] paramVarNames, String[] returnVarNames) {
        if (targetId == null || paramVarNames == null || returnVarNames == null) {
            throw new NullPointerException();
        }
        this.paramVarNames = paramVarNames;
        this.returnVarNames = returnVarNames;
        this.targetId = targetId;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getCategories() {
        return new String[]{"data-area-creation", "children-start", "biz", "c-x"};
    }

    @Override
    public int getIndex() {
        return 0;
    }

    public VariableImpl<?>[] getParamVars() {
        return (VariableImpl[])this.paramVars.clone();
    }

    public VariableImpl<?>[] getReturnVars() {
        return (VariableImpl[])this.returnVars.clone();
    }

    public NodeImpl getTarget() {
        return this.target;
    }

    @Override
    public void preHandle(NodeImpl node) {
        node.setComposite();
    }

    private void checkTarget(NodeImpl node) {
        if (this.target != null) {
            return;
        }
        this.target = node.getFlow().getNode(this.targetId);
        if (!this.target.isComposite()) {
            throw new RuntimeException("\u8282\u70b9(" + this.target + ")\u4e0d\u662f\u590d\u5408\u8282\u70b9\uff0c\u4e0d\u80fd\u88ab\u8c03\u7528\uff0e");
        }
        Feature f = this.target.getFeature("biz");
        if (!(f instanceof SetAsCallee)) {
            throw new RuntimeException("\u8282\u70b9(" + this.target + ")\u6ca1\u6709\u8bbe\u7f6e\u4e3a\u88ab\u8c03\u7528\u8005\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u8c03\u7528\u76ee\u6807\uff0e");
        }
        SetAsCallee callee = (SetAsCallee)f;
        if (callee.getParamsCount() != this.paramVarNames.length) {
            throw new RuntimeException("\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d\uff01");
        }
        if (callee.getReturnsCount() != this.returnVarNames.length) {
            throw new RuntimeException("\u8fd4\u56de\u503c\u4e2a\u6570\u4e0d\u5339\u914d\uff01");
        }
    }

    @Override
    public void postHandle(NodeImpl node) {
        if (this.returnVars != null) {
            return;
        }
        this.checkTarget(node);
        if (!this.target.variablesWereSolidified()) {
            node.getFlow().addLazyFeature(this, node);
            return;
        }
        SetAsCallee callee = (SetAsCallee)this.target.getFeature("biz");
        this.paramVars = new VariableImpl[this.paramVarNames.length];
        for (int i = 0; i < this.paramVarNames.length; ++i) {
            this.paramVars[i] = node.retrieveVariable(this.paramVarNames[i]);
        }
        VariableImpl<?>[] formalReturns = callee.getReturnVars();
        this.returnVars = new VariableImpl[this.returnVarNames.length];
        for (int i = 0; i < this.returnVarNames.length; ++i) {
            this.returnVars[i] = node.retrieveVariable(this.returnVarNames[i]);
            if (!this.returnVars[i].isSingleton()) continue;
            throw new RuntimeException(this.returnVars[i] + "\u662f\u5355\u4f8b\u53d8\u91cf\uff0c\u4e0d\u80fd\u4f5c\u4e3a(" + node + ")\u8fd4\u56de\u503c\u3002");
        }
        Output output = new Output(formalReturns, this.returnVars);
        node.setOutput(output);
        node.insert(NIS.START_TARGET_SUB_NODES);
        if (this.target.contains(NIS.START_UP_COMPENSATION_ON_DELIVERED)) {
            node.insert(NIS.START_UP_COMPENSATION_ON_DELIVERED);
            node.insert(NIS.START_UP_COMPENSATION_ON_TERMINATED);
        }
    }
}

