/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.r.DataAreaImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import java.util.Collection;
import java.util.HashSet;

public final class DeferredDispatch
extends AbstractInstruction {
    private static String TARGETS = "DD_TARGET";

    public DeferredDispatch(int index) {
        super(index);
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) {
        Collection targets = (Collection)e.getProperty(TARGETS);
        if (targets == null) {
            return 1;
        }
        FlowImpl flow = ((NodeImpl)e.getDefine()).getFlow();
        DataAreaImpl dataArea = e.getDataArea();
        FlowContextImpl ctx = e.getContext();
        for (String id : targets) {
            ExecutionImpl<NodeImpl> next = new ExecutionImpl<NodeImpl>(e, flow.getNode(id), dataArea, null, null);
            ctx.push(next);
        }
        return this.getLabel() + 2;
    }

    public String toString() {
        return "deferred-dispatch";
    }

    public static void setDeferredChoice(ExecutionImpl<NodeImpl> e, NodeImpl ... children) {
        NodeImpl p = (NodeImpl)e.getDefine();
        HashSet<String> targets = new HashSet<String>(children.length << 1);
        for (NodeImpl s : children) {
            if (s.getParent() != p) {
                throw new RuntimeException("(" + s + ")\u4e0d\u5c5e\u4e8e(" + p + ")\u7684\u5b50\u8282\u70b9\uff01");
            }
            targets.add(s.getId());
        }
        e.setProperty(TARGETS, targets);
    }
}

