/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.var;

import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.VIS;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.r.DataAreaImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.plugin.Condition;
import java.util.ArrayList;

public class NotWaitForChildrenlWhenSatisfied
implements Instruction<VariableImpl<?>> {
    private int index;
    private ArrayList<String> nodeIds = new ArrayList(1);
    private ArrayList<Condition> conditions = new ArrayList(1);

    public NotWaitForChildrenlWhenSatisfied(Condition condition, String nodeId, int index) {
        this.index = index;
        this.nodeIds.add(nodeId);
        this.conditions.add(condition);
    }

    @Override
    public int invoke(ExecutionImpl<VariableImpl<?>> e) throws Exception {
        FlowContextImpl ctx = e.getContext();
        DataAreaImpl da = e.getDataArea();
        for (int i = 0; i < this.nodeIds.size(); ++i) {
            String nodeId = this.nodeIds.get(i);
            Condition condition = this.conditions.get(i);
            for (ExecutionImpl<?> ex : ctx.getExecutions(nodeId)) {
                if (ex.getDataArea() != da || !condition.test(ex)) continue;
                ex.seek(501000000);
                ctx.push(ex);
            }
        }
        return 1;
    }

    @Override
    public int getLabel() {
        return this.index;
    }

    public String toString() {
        return "not-wait-for-childen-when-true" + this.nodeIds;
    }

    public static void insert(VariableImpl<?> v, NodeImpl node, Condition condition) {
        int label = VIS.NOT_WAIT4CHILDREN_WHEN_SATISFIED.getLabel();
        int addr = v.seekInstruction(label);
        if (addr == -1) {
            v.insert(new NotWaitForChildrenlWhenSatisfied(condition, node.getId(), label));
            return;
        }
        Instruction original = v.getInstruction(addr);
        if (original.getLabel() == label) {
            NotWaitForChildrenlWhenSatisfied c = (NotWaitForChildrenlWhenSatisfied)original;
            c.nodeIds.add(node.getId());
            c.conditions.add(condition);
        } else {
            v.insert(new NotWaitForChildrenlWhenSatisfied(condition, node.getId(), label));
        }
    }
}

