/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.r;

import com.kingdee.cbos.process.vm.internal.Consts;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.internal.r.PropertyContainerImpl;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.runtime.DataArea;
import com.kingdee.cbos.process.vm.utils.XmlUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DataAreaImpl
extends PropertyContainerImpl
implements DataArea {
    private String id;
    private DataAreaImpl parent;
    private FlowImpl flow;
    private FlowContextImpl ctx;
    private ExecutionImpl<NodeImpl> host;
    private Object[] values;
    private LinkedList<ExecutionImpl<?>> executions = new LinkedList();
    private ArrayList<DataAreaImpl> children;

    private DataAreaImpl() {
    }

    static DataAreaImpl fromXml(HashMap<String, FlowImpl> flows, FlowContextImpl ctx, Element e, DataAreaImpl parent) {
        FlowImpl flow = flows.get(e.getAttribute("flow"));
        if (flow == null) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728\uff01");
        }
        DataAreaImpl da = new DataAreaImpl();
        da.id = e.getAttribute("id");
        da.parent = parent;
        da.flow = flow;
        da.ctx = ctx;
        DataAreaImpl.restoreHost(ctx, e, da);
        DataAreaImpl.restoreExecutions(flows, ctx, e, da);
        DataAreaImpl.restoreValues(ctx, e, flow, da);
        DataAreaImpl.restoreChildren(flows, ctx, e, da);
        da.restoreProperties(e);
        return da;
    }

    private static void restoreChildren(HashMap<String, FlowImpl> flows, FlowContextImpl ctx, Element e, DataAreaImpl da) {
        Element container = XmlUtil.getChild(e, "children");
        if (container == null) {
            return;
        }
        Collection<Element> children = XmlUtil.getChildren(container, "data-area");
        if (children.size() == 0) {
            return;
        }
        da.children = new ArrayList();
        for (Element child : children) {
            DataAreaImpl c = DataAreaImpl.fromXml(flows, ctx, child, da);
            da.children.add(c);
        }
    }

    private static void restoreValues(FlowContextImpl ctx, Element e, FlowImpl flow, DataAreaImpl da) {
        int count = flow.variableCount();
        da.values = new Object[count];
        Element container = XmlUtil.getChild(e, "values");
        Collection<Element> values = XmlUtil.getChildren(container, "value");
        if (da.values.length != values.size()) {
            throw new RuntimeException("\u6d41\u7a0b\u53d8\u91cf\u503c\u4e2a\u6570\u4e0d\u5339\u914d\uff01");
        }
        int i = 0;
        for (Element v : values) {
            DataType type = flow.getVariable(i).getType();
            if (!type.isTransient()) {
                da.values[i] = type.fromXml(v, ctx);
            }
            ++i;
        }
    }

    private static void restoreExecutions(HashMap<String, FlowImpl> flows, FlowContextImpl ctx, Element e, DataAreaImpl da) {
        Element container = XmlUtil.getChild(e, "executions");
        if (container != null) {
            Collection<Element> executions = XmlUtil.getChildren(container, "execution");
            for (Element execution : executions) {
                ExecutionImpl<?> tmp = ExecutionImpl.fromXml(flows, execution, ctx, da);
                da.executions.add(tmp);
            }
        }
    }

    private static void restoreHost(FlowContextImpl ctx, Element e, DataAreaImpl da) {
        String host = e.getAttribute("host");
        if (host.length() != 0) {
            da.host = ctx.getExecution(host);
            if (da.host == null) {
                throw new RuntimeException("\u6267\u884c\u5bf9\u8c61(" + host + ")\u4e0d\u5b58\u5728\uff01");
            }
        }
    }

    void toXml(Element e) {
        e.setAttribute("id", this.id);
        e.setAttribute("host", this.host == null ? "" : this.host.getId());
        e.setAttribute("flow", this.flow.getId());
        e.setAttribute("crc", this.flow.getCrc());
        this.saveValues(e);
        this.saveExecutions(e);
        this.saveChildren(e);
        this.saveProperties(e);
    }

    private void saveExecutions(Element e) {
        if (this.executions.size() == 0) {
            return;
        }
        Document doc = e.getOwnerDocument();
        Element executions = doc.createElement("executions");
        e.appendChild(executions);
        for (ExecutionImpl executionImpl : this.executions) {
            Element execution = doc.createElement("execution");
            executions.appendChild(execution);
            executionImpl.toXml(execution);
        }
    }

    private void saveChildren(Element e) {
        if (this.children != null) {
            Document doc = e.getOwnerDocument();
            Element children = doc.createElement("children");
            e.appendChild(children);
            for (DataAreaImpl d : this.children) {
                Element dataArea = doc.createElement("data-area");
                children.appendChild(dataArea);
                d.toXml(dataArea);
            }
        }
    }

    private void saveValues(Element e) {
        Document doc = e.getOwnerDocument();
        Element values = doc.createElement("values");
        e.appendChild(values);
        for (int i = 0; i < this.values.length; ++i) {
            Element value = doc.createElement("value");
            values.appendChild(value);
            DataType type = this.flow.getVariable(i).getType();
            if (type.isTransient()) continue;
            type.toXml(value, this.values[i]);
        }
    }

    public DataAreaImpl(FlowContextImpl ctx) {
        this(ctx, ctx.getFlow(), null);
    }

    void add(ExecutionImpl<?> e) {
        this.executions.add(e);
    }

    public DataAreaImpl(ExecutionImpl<NodeImpl> host, FlowImpl flow, int[] input_a, Object[] input_v) {
        this(host.getContext(), flow, host);
        for (int i = 0; i < input_a.length; ++i) {
            int v = input_a[i];
            this.values[v] = input_v[i];
        }
        this.parent = host.getDataArea();
        if (this.parent.children == null) {
            this.parent.children = new ArrayList();
        }
        this.parent.children.add(this);
    }

    void remove(ExecutionImpl<?> e) {
        this.executions.remove(e);
        if (this.executions.size() == 0) {
            ((NodeImpl)this.getHost().getDefine()).getOutput().output(this);
            this.parent.children.remove(this);
            this.host = null;
        }
    }

    public int getExecutionCount() {
        return this.executions.size();
    }

    public boolean isNull(VariableImpl<?> v) {
        Object o = this.getDataArea(v).values[v.getAddress()];
        return v.getType().isNull(o);
    }

    @Override
    public FlowContextImpl getContext() {
        return this.ctx;
    }

    public FlowImpl getFlow() {
        return this.flow;
    }

    private DataAreaImpl(FlowContextImpl ctx, FlowImpl flow, ExecutionImpl<NodeImpl> host) {
        this.host = host;
        this.flow = flow;
        this.ctx = ctx;
        this.id = String.valueOf(ctx.nextId());
        int count = flow.variableCount();
        this.values = new Object[count];
        for (int i = 0; i < count; ++i) {
            VariableImpl<?> v = flow.getVariable(i);
            if (v.isSingleton() && host != null && !((NodeImpl)host.getDefine()).isSubflow()) continue;
            this.reset(v);
        }
    }

    public String getId() {
        return this.id;
    }

    public ExecutionImpl<NodeImpl> getHost() {
        if (this.host == null) {
            this.host = this.ctx.getRootExecution();
        }
        return this.host;
    }

    public Object getAt(VariableImpl<?> v) {
        Object value = this.innerGet(v);
        return v.getType().wrap(value);
    }

    @Override
    public Collection<?> getCollection(String var) {
        Variable v = ((NodeImpl)this.getHost().getDefine()).retrieveVariable(var);
        return this.getCollection(v);
    }

    @Override
    public Collection<?> getCollection(Variable<?> address) {
        VariableImpl v = (VariableImpl)address;
        DataType type = v.getType();
        if (!type.acceptMultiValue()) {
            throw new RuntimeException("\u6d41\u7a0b\u53d8\u91cf(" + v + ")\u662f\u539f\u5b50\u7c7b\u578b\u3002");
        }
        Object value = this.innerGet(v);
        return type.toCollection(value);
    }

    private Object innerGet(VariableImpl<?> v) {
        return this.getDataArea(v).values[v.getAddress()];
    }

    private DataAreaImpl getDataArea(VariableImpl<?> v) {
        if (!v.isSingleton()) {
            return this;
        }
        if (this.host == null) {
            return this;
        }
        DataAreaImpl root = this.getRoot();
        if (this.flow == root.flow) {
            return root;
        }
        DataAreaImpl x = this;
        while (!((NodeImpl)x.host.getDefine()).isSubflow()) {
            x = x.parent;
        }
        return x;
    }

    void innerSetAt(VariableImpl<?> v, Object value) {
        DataAreaImpl da = this.getDataArea(v);
        int address = v.getAddress();
        Object original = da.values[address];
        da.values[address] = v.getType().narrow(original, value);
    }

    public void clear(VariableImpl<?> v) {
        this.getDataArea(v).values[v.getAddress()] = null;
    }

    public void reset(VariableImpl<?> v) {
        this.clear(v);
        Object init = v.getInitValue();
        if (init != null) {
            if (!init.getClass().isArray()) {
                this.innerSetAt(v, init);
            } else {
                int len = Array.getLength(init);
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(init, i);
                    this.innerSetAt(v, o);
                }
            }
        }
    }

    private void fireEvent(VariableImpl<?> v) {
        if (v.getInstructionCount() > 0) {
            ExecutionImpl e = new ExecutionImpl(this.getHost(), v, this, null, null);
            this.ctx.push(e);
        }
    }

    public void setAt(VariableImpl<?> v, Object value) {
        this.innerSetAt(v, value);
        this.fireEvent(v);
    }

    @Override
    public DataAreaImpl getParent() {
        return this.parent;
    }

    public List<DataAreaImpl> getChildren() {
        if (this.children != null) {
            return Collections.unmodifiableList(this.children);
        }
        return Consts.EMPTY_LIST;
    }

    public boolean hasSubDataAreas() {
        return this.children == null ? false : this.children.size() > 0;
    }

    private DataAreaImpl getRoot() {
        return this.parent == null ? this : this.ctx.getRootDataArea();
    }
}

