/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.r.profie;

import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.internal.r.profie.ProfileImpl;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.ProfileLogger;

public class Performance
extends ProfileImpl {
    private Instruction<?> current;
    private long startTime;
    private long beginTime;
    private FlowContextImpl ctx;

    Performance(FlowContextImpl ctx) {
        this.ctx = ctx;
        this.beginTime = System.nanoTime();
        ProfileLogger.Ref.get().logBegin(ctx);
    }

    @Override
    public void begin(ExecutionImpl<?> e) {
        this.current = e.current();
        this.startTime = System.nanoTime();
    }

    @Override
    public boolean end(ExecutionImpl<?> e, boolean success) {
        long endTime = System.nanoTime();
        StringBuilder message = new StringBuilder();
        for (Execution<?> p = e.getParent(); p != null; p = p.getParent()) {
            message.append("    ");
        }
        message.append(e + ": \t" + this.current + ", \telpased time: \t" + (endTime - this.startTime) / 1000L + "\tus.");
        ProfileLogger.Ref.get().logExecute(e, message.toString(), success);
        return false;
    }

    @Override
    public void end() {
        long now = System.nanoTime();
        String message = "total: " + (now - this.beginTime) / 1000L + " us.";
        ProfileLogger.Ref.get().logEnd(this.ctx, message);
    }
}

