/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.r.util;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.f.basic.AdHoc;
import com.kingdee.cbos.process.vm.internal.i.node.CheckErrorDeliver;
import com.kingdee.cbos.process.vm.internal.i.node.DeferredChoice;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.runtime.Execution;

public class Append {
    private FlowContextImpl ctx;

    public Append(FlowContextImpl ctx) {
        this.ctx = ctx;
    }

    public Execution<? extends Node>[] append(String executionId, boolean isSequence, boolean isPriorAppend, Node ... nodes) {
        ExecutionImpl<NodeImpl> parent = this.check4append(executionId, nodes);
        int count = isPriorAppend ? nodes.length + 1 : nodes.length;
        ExecutionImpl<NodeImpl>[] appended = this.createdAppendedExecutions(parent, count, nodes);
        if (isPriorAppend) {
            appended[count - 1] = this.createdAppendedExecution(parent, (NodeImpl)parent.getDefine());
        }
        this.setTransitions(isSequence, isPriorAppend, count, parent, appended);
        for (ExecutionImpl<NodeImpl> e : appended) {
            this.ctx.enqueue(e);
        }
        return appended;
    }

    private void setTransitions(boolean isSequence, boolean isAssistant, int count, ExecutionImpl<NodeImpl> parent, ExecutionImpl<NodeImpl>[] appended) {
        if (isSequence) {
            for (int i = 0; i < count - 1; ++i) {
                DeferredChoice.setDeferredChoice(appended[i], appended[i + 1]);
            }
            if (!isAssistant) {
                appended[0].setProperty("$waitingId", parent.getId());
            }
        } else if (isAssistant) {
            for (int i = 0; i < count - 1; ++i) {
                DeferredChoice.setDeferredChoice(appended[i], appended[count - 1]);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                appended[i].setProperty("$waitingId", parent.getId());
            }
        }
        if (isAssistant || isSequence) {
            // empty if block
        }
    }

    private ExecutionImpl<NodeImpl>[] createdAppendedExecutions(ExecutionImpl<NodeImpl> parent, int count, Node ... nodes) {
        ExecutionImpl[] appended = new ExecutionImpl[count];
        for (int i = 0; i < nodes.length; ++i) {
            NodeImpl node = (NodeImpl)nodes[i];
            appended[i] = this.createdAppendedExecution(parent, node);
        }
        return appended;
    }

    private ExecutionImpl<NodeImpl> createdAppendedExecution(ExecutionImpl<NodeImpl> parent, NodeImpl node) {
        ExecutionImpl<NodeImpl> e = new ExecutionImpl<NodeImpl>(parent, node, parent.getDataArea(), null, null);
        e.setProperty("$append$", "true");
        e.setProperty("$appendpreActinId$", parent.getId());
        DeferredChoice.setDeferredChoice(e, new NodeImpl[0]);
        CheckErrorDeliver.disable(e);
        return e;
    }

    private ExecutionImpl<NodeImpl> check4append(String executionId, Node ... nodes) {
        if (nodes.length == 0) {
            throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u52a0\u7b7e\u6a21\u677f\u8282\u70b9.");
        }
        for (Node n : nodes) {
            if (((NodeImpl)n).getFeature("ad-hoc") instanceof AdHoc) continue;
            throw new RuntimeException("\u8282\u70b9(" + n + ")\u4e0d\u652f\u6301AdHoc\u7279\u6027\uff0c\u4e0d\u80fd\u7528\u4e8e\u52a0\u7b7e\u3002");
        }
        ExecutionImpl<NodeImpl> e = this.ctx.getNodeExecution(executionId);
        Feature f = ((NodeImpl)e.getDefine()).getFeature("ad-hoc");
        if (!(f instanceof AdHoc)) {
            throw new RuntimeException("(" + e + ")\u4e0d\u652f\u6301AdHoc\u7279\u6027\uff0c\u4e0d\u80fd\u52a0\u7b7e\u3002");
        }
        return e;
    }

    public Execution<?>[] append(String parentId, String ... nodeIds) {
        if (nodeIds.length == 0) {
            return null;
        }
        ExecutionImpl<?> parent = this.getParent(parentId);
        NodeImpl[] nodes = this.getNodes(nodeIds);
        ExecutionImpl<?>[] executions = this.createExecutions(parent, nodes);
        return executions;
    }

    private ExecutionImpl<?>[] createExecutions(ExecutionImpl<?> parent, NodeImpl[] nodes) {
        ExecutionImpl[] executions = new ExecutionImpl[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            executions[i] = new ExecutionImpl<NodeImpl>(parent, nodes[i], parent.getDataArea(), null, null);
            this.ctx.push(executions[i]);
        }
        return executions;
    }

    private NodeImpl[] getNodes(String ... nodeIds) {
        NodeImpl[] nodes = new NodeImpl[nodeIds.length];
        for (int i = 0; i < nodeIds.length; ++i) {
            NodeImpl node = this.ctx.getFlow().getNode(nodeIds[i]);
            if (node == null) {
                throw new RuntimeException("\u8282\u70b9(" + nodeIds[i] + ")\u4e0d\u5b58\u5728\uff01");
            }
            nodes[i] = node;
        }
        return nodes;
    }

    private ExecutionImpl<?> getParent(String parentId) {
        Execution parent = this.ctx.getExecution(parentId);
        if (parent == null) {
            throw new NullPointerException("\u6267\u884c\u5bf9\u8c61{" + parentId + "}\u4e0d\u5b58\u5728\uff01");
        }
        VariableScope o = ((ExecutionImpl)parent).getDefine();
        if (!(o instanceof NodeImpl)) {
            throw new RuntimeException("{" + parent + "}\u4e0d\u662f\u8282\u70b9\u6267\u884c\u5bf9\u8c61\uff01");
        }
        if (!((NodeImpl)o).isComposite()) {
            throw new RuntimeException("{" + parent + "}\u7684\u8282\u70b9\u4e0d\u662f\u590d\u5408\u8282\u70b9\uff01");
        }
        return parent;
    }
}

