/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonUtil {
    public static final int MAX_LEVEL = 16;

    public static String escape(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        int j = s.length();
        block8: for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String toString(Object o) {
        StringBuffer sb = new StringBuffer();
        JsonUtil.toString(o, sb, 0);
        return sb.toString();
    }

    public static StringBuffer toString(Object o, StringBuffer buffer, int level) {
        if (level >= 16) {
            throw new RuntimeException("Collection or Map nested level is too deep, and there may be exist a recursive reference.");
        }
        if (o == null) {
            return buffer.append("null");
        }
        if (o instanceof Object[]) {
            return JsonUtil.toString((Object[])o, buffer, level + 1);
        }
        if (o instanceof Collection) {
            return JsonUtil.toString((Collection)o, buffer, level + 1);
        }
        if (o instanceof Map) {
            return JsonUtil.toString((Map)o, buffer, level + 1);
        }
        if (o instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)o);
            return buffer.append("new Date(").append(c.get(1)).append(",").append(c.get(2)).append(",").append(c.get(5)).append(",").append(c.get(10)).append(",").append(c.get(12)).append(",").append(c.get(13)).append(")");
        }
        if (o instanceof Integer) {
            return buffer.append(o);
        }
        if (o instanceof Number) {
            return buffer.append(o.toString());
        }
        if (o instanceof Boolean) {
            return buffer.append(o.toString());
        }
        return buffer.append(JsonUtil.escape(o.toString()));
    }

    public static StringBuffer toString(Collection<?> l, StringBuffer buffer, int level) {
        buffer.append("([");
        Iterator<?> it = l.iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            JsonUtil.toString(it.next(), buffer, level + 1);
        }
        buffer.append("])");
        return buffer;
    }

    public static StringBuffer toString(Object[] a, StringBuffer buffer, int level) {
        buffer.append("([");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            JsonUtil.toString(a[i], buffer, level + 1);
        }
        buffer.append("])");
        return buffer;
    }

    public static StringBuffer toString(Map<?, ?> m, StringBuffer buffer, int level) {
        buffer.append("({");
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            Object key = entry.getKey();
            JsonUtil.toString(key, buffer, level + 1);
            buffer.append(":");
            Object value = entry.getValue();
            JsonUtil.toString(value, buffer, level + 1);
        }
        buffer.append("})");
        return buffer;
    }

    public static Object toObject(String json) {
        StringReader sr = new StringReader(json);
        try {
            return JsonUtil.asObject(sr);
        }
        catch (IOException e) {
            throw new RuntimeException("\u4ece\u5b57\u7b26\u4e32\u8bfb\u53d6\u5b57\u7b26\u5931\u8d25\uff01", e);
        }
    }

    public static Object asObject(Reader sr) throws IOException {
        int i = sr.read();
        if (i == 40) {
            i = sr.read();
        }
        switch (i) {
            case 34: 
            case 42: 
            case 91: 
            case 123: {
                return JsonUtil.asObject(sr, i);
            }
        }
        throw new RuntimeException("invalid json format");
    }

    private static Object asObject(Reader sr, int priorChar) throws IOException {
        switch (priorChar) {
            case 34: {
                return JsonUtil.asString(sr);
            }
            case 91: {
                return JsonUtil.asList(sr);
            }
            case 123: {
                return JsonUtil.asMap(sr);
            }
            case 42: {
                return null;
            }
        }
        throw new RuntimeException("invalid json format");
    }

    private static Object asString(Reader s) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c = s.read();
        while (c >= 0) {
            block0 : switch (c) {
                case 34: {
                    return sb.toString();
                }
                case 92: {
                    c = s.read();
                    switch (c) {
                        case 114: {
                            sb.append("\r");
                            break block0;
                        }
                        case 110: {
                            sb.append("\n");
                            break block0;
                        }
                        case 39: {
                            sb.append("'");
                            break block0;
                        }
                        case 34: {
                            sb.append("\"");
                            break block0;
                        }
                        case 116: {
                            sb.append("\t");
                            break block0;
                        }
                        case 92: {
                            sb.append("\\");
                            break block0;
                        }
                    }
                    throw new RuntimeException("\\" + (char)c + " is not valid char.");
                }
                default: {
                    sb.append((char)c);
                }
            }
            c = s.read();
        }
        return sb.length() != 0 ? sb.toString() : null;
    }

    private static ArrayList<Object> asList(Reader s) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int c = s.read();
        block5: while (c >= 0) {
            switch (c) {
                case 93: {
                    return list;
                }
                case 34: 
                case 42: 
                case 91: 
                case 123: {
                    list.add(JsonUtil.asObject(s, c));
                    c = s.read();
                    continue block5;
                }
                case 40: 
                case 41: 
                case 44: {
                    c = s.read();
                    continue block5;
                }
            }
            throw new RuntimeException("char {" + (char)c + "} is an invalid char.");
        }
        return list;
    }

    private static LinkedHashMap<Object, Object> asMap(Reader s) throws IOException {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int c = s.read();
        block5: while (c >= 0) {
            switch (c) {
                case 125: {
                    return map;
                }
                default: {
                    throw new RuntimeException("char {" + (char)c + "} is an invalid char.");
                }
                case 34: 
                case 42: 
                case 91: 
                case 123: {
                    Object key = JsonUtil.asObject(s, c);
                    s.read();
                    Object value = JsonUtil.asObject(s);
                    map.put(key, value);
                    c = s.read();
                    continue block5;
                }
                case 40: 
                case 41: 
                case 44: 
            }
            c = s.read();
        }
        return map;
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", "value1");
        map.put("key2", "value2");
        map.put("key3", "value3");
    }
}

