/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.ref;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSwitchPathAndIdHandler
implements ISwitchPathAndIdHandler {
    private static List<Constructor<? extends IUpdateRefPathAndIdHandler>> UPDATECLASSES = new ArrayList<Constructor<? extends IUpdateRefPathAndIdHandler>>();
    protected QingContext context;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    private String groupHasDeleted;
    private String publishHasDeleted;

    public static void registUpdateRefPathAndIdHandler(Class<? extends IUpdateRefPathAndIdHandler> clazz) {
        try {
            Constructor<? extends IUpdateRefPathAndIdHandler> constructor = clazz.getConstructor(QingContext.class, ITransactionManagement.class, IDBExcuter.class);
            UPDATECLASSES.add(constructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public AbstractSwitchPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.context = context;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    public String getGroupHasDeleted() {
        if (this.groupHasDeleted == null) {
            this.groupHasDeleted = Messages.getMLS((QingContext)this.context, (String)"groupHasDeleted", (String)"\u5206\u7c7b\u88ab\u5220\u9664", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
        }
        return this.groupHasDeleted;
    }

    public String getPublishHasDeleted() {
        if (this.publishHasDeleted == null) {
            this.publishHasDeleted = Messages.getMLS((QingContext)this.context, (String)"publishHasDeleted", (String)"\u53d1\u5e03\u88ab\u5220\u9664", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
        }
        return this.publishHasDeleted;
    }

    protected void updateRefIdToPath(RefTypeEnum refType, String refPath, String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        for (Constructor<? extends IUpdateRefPathAndIdHandler> updateClass : UPDATECLASSES) {
            IUpdateRefPathAndIdHandler updateRefPathAndIdHandler = null;
            try {
                updateRefPathAndIdHandler = updateClass.newInstance(this.context, this.tx, this.dbExcuter);
            }
            catch (Exception e) {
                throw new IntegratedRuntimeException((Throwable)e);
            }
            updateRefPathAndIdHandler.updateRefIdToPath(refType, refPath, refToId, userId);
        }
    }

    protected void updateRefPathToId(RefTypeEnum refType, String refPath, String refId, String userId) throws AbstractQingIntegratedException, SQLException {
        for (Constructor<? extends IUpdateRefPathAndIdHandler> updateClass : UPDATECLASSES) {
            IUpdateRefPathAndIdHandler updateRefPathAndIdHandler = null;
            try {
                updateRefPathAndIdHandler = updateClass.newInstance(this.context, this.tx, this.dbExcuter);
            }
            catch (Exception e) {
                throw new IntegratedRuntimeException((Throwable)e);
            }
            updateRefPathAndIdHandler.updateRefPathToId(refType, refPath, refId, userId);
        }
    }

    public static interface IUpdateRefPathAndIdHandler {
        public void updateRefIdToPath(RefTypeEnum var1, String var2, String var3, String var4) throws AbstractQingIntegratedException, SQLException;

        public void updateRefPathToId(RefTypeEnum var1, String var2, String var3, String var4) throws AbstractQingIntegratedException, SQLException;
    }
}

