/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.handler;

import com.kingdee.bos.qing.data.domain.macro.sql.handler.AbstractMacroSQLSegmentHandler;
import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.AbstractConditionSegment;
import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.BinaryConditionSegment;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import java.util.List;
import java.util.Set;

public class BinaryConditionSegmentHander
extends AbstractMacroSQLSegmentHandler {
    @Override
    public void handle(List<Object> sqlParams, AbstractConditionSegment conditionSegment, List<AbstractConditionSegment> segmentsToRemove, List<AbstractConditionSegment> segmentsToAdd) throws AbstractMacroException {
        if (conditionSegment instanceof BinaryConditionSegment) {
            BinaryConditionSegment binConditionSegment = (BinaryConditionSegment)conditionSegment;
            String left = binConditionSegment.getLeft();
            String right = binConditionSegment.getRight();
            if (this.macroExecutor.containsMacro(left) && this.macroExecutor.containsMacro(right)) {
                this.handleBothSideMacro(left, right, binConditionSegment, sqlParams, segmentsToRemove, segmentsToAdd);
            } else if (this.macroExecutor.containsMacro(left)) {
                this.handleLeftSideMacro(left, binConditionSegment, sqlParams, segmentsToRemove, segmentsToAdd);
            } else if (this.macroExecutor.containsMacro(right)) {
                this.handleRightSideMacro(right, binConditionSegment, sqlParams, segmentsToRemove, segmentsToAdd);
            }
        }
    }

    private void handleBothSideMacro(String left, String right, BinaryConditionSegment binConditionSegment, List<Object> sqlParams, List<AbstractConditionSegment> segmentsToRemove, List<AbstractConditionSegment> segmentsToAdd) throws AbstractMacroException {
        Set<String> leftMacroKeys = this.macroExecutor.getMacroKeys(left);
        Set<String> rightMacroKeys = this.macroExecutor.getMacroKeys(right);
        Set<Object> leftMacroValues = this.macroExecutor.getMacroValues(left, this.qingContext);
        Set<Object> rightMacroValues = this.macroExecutor.getMacroValues(right, this.qingContext);
        String newLeft = null;
        String newRight = null;
        String leftReplaceText = leftMacroValues.size() > 0 ? "?" : "NULL";
        for (String string : leftMacroKeys) {
            if (!left.contains(string)) continue;
            newLeft = left.replace(string, leftReplaceText);
            break;
        }
        String rightReplaceText = rightMacroValues.size() > 0 ? "?" : "NULL";
        for (String rightMacroKey : rightMacroKeys) {
            if (!right.contains(rightMacroKey)) continue;
            newRight = right.replace(rightMacroKey, rightReplaceText);
            break;
        }
        if (leftMacroValues.size() > 0 && rightMacroValues.size() > 0) {
            for (Object leftMacroValue : leftMacroValues) {
                for (Object rightMacroValue : rightMacroValues) {
                    BinaryConditionSegment newBinConditionSegment = binConditionSegment.copy();
                    newBinConditionSegment.setLeft(newLeft);
                    newBinConditionSegment.setRight(newRight);
                    sqlParams.add(leftMacroValue);
                    sqlParams.add(rightMacroValue);
                    segmentsToAdd.add(newBinConditionSegment);
                }
            }
        } else if (leftMacroValues.size() > 0) {
            for (Object leftMacroValue : leftMacroValues) {
                BinaryConditionSegment newBinConditionSegment = binConditionSegment.copy();
                newBinConditionSegment.setLeft(newLeft);
                newBinConditionSegment.setRight(newRight);
                sqlParams.add(leftMacroValue);
                segmentsToAdd.add(newBinConditionSegment);
            }
        } else if (rightMacroValues.size() > 0) {
            for (Object rightMacroValue : rightMacroValues) {
                BinaryConditionSegment newBinConditionSegment = binConditionSegment.copy();
                newBinConditionSegment.setLeft(newLeft);
                newBinConditionSegment.setRight(newRight);
                sqlParams.add(rightMacroValue);
                segmentsToAdd.add(newBinConditionSegment);
            }
        } else {
            BinaryConditionSegment binaryConditionSegment = binConditionSegment.copy();
            binaryConditionSegment.setLeft(newLeft);
            binaryConditionSegment.setRight(newRight);
            segmentsToAdd.add(binaryConditionSegment);
        }
        segmentsToRemove.add(binConditionSegment);
    }

    private void handleLeftSideMacro(String left, BinaryConditionSegment binConditionSegment, List<Object> sqlParams, List<AbstractConditionSegment> segmentsToRemove, List<AbstractConditionSegment> segmentsToAdd) throws AbstractMacroException {
        String newLeft = null;
        Set<String> leftMacroKeys = this.macroExecutor.getMacroKeys(left);
        Set<Object> macroValues = this.macroExecutor.getMacroValues(left, this.qingContext);
        String leftReplaceText = macroValues.size() > 0 ? "?" : "NULL";
        for (String leftMacroKey : leftMacroKeys) {
            if (!left.contains(leftMacroKey)) continue;
            newLeft = left.replace(leftMacroKey, leftReplaceText);
            break;
        }
        if (macroValues.size() == 0) {
            BinaryConditionSegment newBinConditionSegment = binConditionSegment.copy();
            newBinConditionSegment.setLeft(newLeft);
            segmentsToAdd.add(newBinConditionSegment);
        } else {
            for (Object macroValue : macroValues) {
                BinaryConditionSegment newBinConditionSegment = binConditionSegment.copy();
                newBinConditionSegment.setLeft(newLeft);
                sqlParams.add(macroValue);
                segmentsToAdd.add(newBinConditionSegment);
            }
        }
        segmentsToRemove.add(binConditionSegment);
    }

    private void handleRightSideMacro(String right, BinaryConditionSegment binConditionSegment, List<Object> sqlParams, List<AbstractConditionSegment> segmentsToRemove, List<AbstractConditionSegment> segmentsToAdd) throws AbstractMacroException {
        String newRight = null;
        Set<String> rightMacroKeys = this.macroExecutor.getMacroKeys(right);
        Set<Object> macroValues = this.macroExecutor.getMacroValues(right, this.qingContext);
        String rightReplaceText = macroValues.isEmpty() ? "NULL" : "?";
        for (String rightMacroKey : rightMacroKeys) {
            if (!right.contains(rightMacroKey)) continue;
            newRight = right.replace(rightMacroKey, rightReplaceText);
            break;
        }
        if (macroValues.isEmpty()) {
            BinaryConditionSegment newBinConditionSegment = binConditionSegment.copy();
            newBinConditionSegment.setRight(newRight);
            segmentsToAdd.add(newBinConditionSegment);
        } else {
            for (Object macroValue : macroValues) {
                BinaryConditionSegment newBinConditionSegment = binConditionSegment.copy();
                newBinConditionSegment.setRight(newRight);
                sqlParams.add(macroValue);
                segmentsToAdd.add(newBinConditionSegment);
            }
        }
        segmentsToRemove.add(binConditionSegment);
    }
}

