/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.parser;

import com.kingdee.bos.qing.data.domain.macro.sql.model.SelectSegment;
import com.kingdee.bos.qing.data.domain.macro.sql.parser.SelectSegmentParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubSelectParser {
    private static final String regex = "(\\()(\\s*(?i)select)(.+?)( (?i)from | \\*\\s*(?i)from )(.+?)(\\))";
    private static Pattern pattern = Pattern.compile("(\\()(\\s*(?i)select)(.+?)( (?i)from | \\*\\s*(?i)from )(.+?)(\\))");
    private static final String SUB_QUERY_PLACEHOLDER = " #PLACEHOLDER#";

    public static String parse(String sql, SelectSegment selectSegment) {
        Matcher matcher = pattern.matcher(sql);
        int idx = 0;
        while (matcher.find()) {
            String matched = matcher.group(0);
            int startIdx = sql.indexOf(matched);
            int endIdx = SubSelectParser.findValidRightBracket(sql, startIdx);
            if (endIdx <= 0 || endIdx <= startIdx) continue;
            matched = sql.substring(startIdx + 1, endIdx);
            String mark = SUB_QUERY_PLACEHOLDER + ++idx + " ";
            sql = sql.replace(matched, mark);
            SelectSegment subSelectSegment = SelectSegmentParser.parse(matched);
            selectSegment.putMarkAndSubSelect(mark, subSelectSegment);
        }
        return sql;
    }

    private static int findValidRightBracket(String str, int startIdx) {
        str = str.substring(startIdx);
        char[] chars = str.toCharArray();
        int count = 0;
        boolean findLeftBracket = false;
        int c = chars.length;
        for (int i = 0; i < c; ++i) {
            if (chars[i] == '(') {
                findLeftBracket = true;
                ++count;
            }
            if (chars[i] == ')') {
                --count;
            }
            if (count != 0 || !findLeftBracket) continue;
            return i + startIdx;
        }
        return -1;
    }
}

