/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.util.DataTypeUtil;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.Field;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public abstract class AbstractDBTableCreator {
    protected DBSource dbSource;
    protected String associateName;

    public static int convertToStr4SpecialType(int type, String className) {
        if ("java.util.UUID".equals(className)) {
            return -9;
        }
        if (1111 == type) {
            if ("java.lang.String".equals(className)) {
                return -9;
            }
            String supportCiText = System.getProperty("qing.pg.citext.support");
            if ("true".equals(supportCiText) && "org.postgresql.util.PGobject".equals(className)) {
                return -9;
            }
        }
        return type;
    }

    public static void addTablePeerFields(Table table, ResultSetMetaData resultSetMetaData) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            Field field = new Field();
            String columnAssociateName = resultSetMetaData.getColumnLabel(columnIndex);
            field.setName(columnAssociateName);
            int type = resultSetMetaData.getColumnType(columnIndex);
            String className = resultSetMetaData.getColumnClassName(columnIndex);
            field.setClassName(className);
            type = AbstractDBTableCreator.convertToStr4SpecialType(type, className);
            DataType dataType = null;
            dataType = DataTypeUtil.checkSqlTypes(type) ? DataTypeUtil.parseDataType(type) : DataTypeUtil.parseDataType(className);
            if (dataType == null) continue;
            field.setDataType(dataType);
            table.addField(field);
        }
    }

    public static void addTablePeerFields(Table table, ResultSetMetaData metaData, DBSource.DBType dbType) throws SQLException {
        int columnCount = metaData.getColumnCount();
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            Field field = new Field();
            String columnAssociateName = metaData.getColumnLabel(columnIndex);
            if (dbType == DBSource.DBType.HIVE) {
                columnAssociateName = columnAssociateName.substring(2);
            }
            field.setName(columnAssociateName);
            int type = metaData.getColumnType(columnIndex);
            String className = metaData.getColumnClassName(columnIndex);
            field.setClassName(className);
            type = AbstractDBTableCreator.convertToStr4SpecialType(type, className);
            DataType dataType = null;
            dataType = DataTypeUtil.checkSqlTypes(type) ? DataTypeUtil.parseDataType(type) : (DataTypeUtil.checkClassNameTypes(className) ? DataTypeUtil.parseDataType(className) : DataTypeUtil.parseHiveDataType(className));
            if (dataType == null) continue;
            field.setDataType(dataType);
            table.addField(field);
        }
    }

    public abstract Table getTablePeer(QingContext var1) throws AbstractDBSourceException, AbstractMacroException;
}

