/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.util;

import com.kingdee.bos.qing.datasource.meta.DataType;
import java.util.HashMap;
import java.util.Map;

public class DataTypeUtil {
    private static Map<String, DataType> JAVA_DATA_TYPE_MAP = new HashMap<String, DataType>();
    private static Map<Integer, DataType> SQL_TYPES_MAP = new HashMap<Integer, DataType>();
    private static Map<String, DataType> HIVE_TYPES_MAP = new HashMap<String, DataType>();

    public static DataType parseDataType(String columnClassName) {
        return JAVA_DATA_TYPE_MAP.get(columnClassName);
    }

    public static DataType parseDataType(int sqlTypes) {
        return SQL_TYPES_MAP.get(sqlTypes);
    }

    public static DataType parseHiveDataType(String dataTypeName) {
        if (dataTypeName.indexOf(40) > 0) {
            dataTypeName = dataTypeName.substring(0, dataTypeName.indexOf(40));
        }
        return HIVE_TYPES_MAP.get(dataTypeName);
    }

    public static boolean checkSqlTypes(int sqlTypes) {
        return SQL_TYPES_MAP.containsKey(sqlTypes);
    }

    public static boolean checkClassNameTypes(String classNameTypes) {
        return JAVA_DATA_TYPE_MAP.containsKey(classNameTypes);
    }

    static {
        JAVA_DATA_TYPE_MAP.put("java.lang.Boolean", DataType.BOOLEAN);
        JAVA_DATA_TYPE_MAP.put("java.lang.Byte", DataType.INT);
        JAVA_DATA_TYPE_MAP.put("java.lang.Short", DataType.INT);
        JAVA_DATA_TYPE_MAP.put("java.lang.Integer", DataType.INT);
        JAVA_DATA_TYPE_MAP.put("java.lang.Long", DataType.INT);
        JAVA_DATA_TYPE_MAP.put("java.lang.Double", DataType.NUMBER);
        JAVA_DATA_TYPE_MAP.put("java.lang.Float", DataType.NUMBER);
        JAVA_DATA_TYPE_MAP.put("java.math.BigDecimal", DataType.NUMBER);
        JAVA_DATA_TYPE_MAP.put("java.sql.Time", DataType.DATETIME);
        JAVA_DATA_TYPE_MAP.put("java.sql.Timestamp", DataType.DATETIME);
        JAVA_DATA_TYPE_MAP.put("oracle.sql.TIMESTAMP", DataType.DATETIME);
        JAVA_DATA_TYPE_MAP.put("java.util.Date", DataType.DATE);
        JAVA_DATA_TYPE_MAP.put("java.sql.Date", DataType.DATE);
        JAVA_DATA_TYPE_MAP.put("java.lang.String", DataType.STRING);
        JAVA_DATA_TYPE_MAP.put("java.util.UUID", DataType.STRING);
        SQL_TYPES_MAP.put(2003, null);
        SQL_TYPES_MAP.put(-5, DataType.INT);
        SQL_TYPES_MAP.put(-2, null);
        SQL_TYPES_MAP.put(-7, DataType.BOOLEAN);
        SQL_TYPES_MAP.put(2004, null);
        SQL_TYPES_MAP.put(16, DataType.BOOLEAN);
        SQL_TYPES_MAP.put(1, DataType.STRING);
        SQL_TYPES_MAP.put(2005, null);
        SQL_TYPES_MAP.put(70, null);
        SQL_TYPES_MAP.put(91, DataType.DATE);
        SQL_TYPES_MAP.put(3, DataType.NUMBER);
        SQL_TYPES_MAP.put(2001, null);
        SQL_TYPES_MAP.put(8, DataType.NUMBER);
        SQL_TYPES_MAP.put(6, DataType.NUMBER);
        SQL_TYPES_MAP.put(4, DataType.INT);
        SQL_TYPES_MAP.put(2000, null);
        SQL_TYPES_MAP.put(-16, null);
        SQL_TYPES_MAP.put(-4, null);
        SQL_TYPES_MAP.put(-1, DataType.STRING);
        SQL_TYPES_MAP.put(-15, DataType.STRING);
        SQL_TYPES_MAP.put(2011, null);
        SQL_TYPES_MAP.put(0, null);
        SQL_TYPES_MAP.put(2, DataType.NUMBER);
        SQL_TYPES_MAP.put(-9, DataType.STRING);
        SQL_TYPES_MAP.put(1111, null);
        SQL_TYPES_MAP.put(7, DataType.NUMBER);
        SQL_TYPES_MAP.put(2006, null);
        SQL_TYPES_MAP.put(2012, null);
        SQL_TYPES_MAP.put(-8, null);
        SQL_TYPES_MAP.put(5, DataType.INT);
        SQL_TYPES_MAP.put(2009, null);
        SQL_TYPES_MAP.put(2002, null);
        SQL_TYPES_MAP.put(92, DataType.DATETIME);
        SQL_TYPES_MAP.put(2013, DataType.STRING);
        SQL_TYPES_MAP.put(93, DataType.DATETIME);
        SQL_TYPES_MAP.put(2014, DataType.DATETIME);
        SQL_TYPES_MAP.put(-6, DataType.INT);
        SQL_TYPES_MAP.put(-3, null);
        SQL_TYPES_MAP.put(12, DataType.STRING);
        HIVE_TYPES_MAP.put("tinyint", DataType.INT);
        HIVE_TYPES_MAP.put("smallint", DataType.INT);
        HIVE_TYPES_MAP.put("int", DataType.INT);
        HIVE_TYPES_MAP.put("bigint", DataType.INT);
        HIVE_TYPES_MAP.put("float", DataType.NUMBER);
        HIVE_TYPES_MAP.put("double", DataType.NUMBER);
        HIVE_TYPES_MAP.put("decimal", DataType.NUMBER);
        HIVE_TYPES_MAP.put("boolean", DataType.BOOLEAN);
        HIVE_TYPES_MAP.put("string", DataType.STRING);
        HIVE_TYPES_MAP.put("timestamp", DataType.DATETIME);
        HIVE_TYPES_MAP.put("binary", DataType.STRING);
    }
}

