/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.util;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.data.domain.macro.IMacroExecutor;
import com.kingdee.bos.qing.data.domain.macro.RuntimeMacroRegister;
import com.kingdee.bos.qing.data.domain.macro.sql.handler.AbstractMacroSQLSegmentHandler;
import com.kingdee.bos.qing.data.domain.macro.sql.handler.ConditionSegmentHandlerFactory;
import com.kingdee.bos.qing.data.domain.macro.sql.handler.UnhandledMacroHandler;
import com.kingdee.bos.qing.data.domain.macro.sql.model.SelectSegment;
import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.AbstractConditionSegment;
import com.kingdee.bos.qing.data.domain.macro.sql.parser.SelectSegmentParser;
import com.kingdee.bos.qing.data.domain.source.db.util.ParameterDataTypeUtil;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLTranslateException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotFoundResultSetException;
import com.kingdee.bos.qing.data.exception.macro.MacroExecuteException;
import com.kingdee.bos.qing.data.model.designtime.ParameterDataType;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedure;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameterIoType;
import com.kingdee.bos.qing.data.model.designtime.ValueMode;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.util.valueconvert.StroreProcedureValueHandler;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.sql.TransUtil;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;

public class SQLHelper {
    private static final int DEFAULT_MAX_PARAM_SIZE = 1000;
    private static final String MAX_PARAM_SIZE_KEY = "qing.sql.max.param.size";
    private static final String USERSQL_SYSTEMVAR_FORMAT = "@%s";

    public static int getMaxParamSize() {
        return SystemPropertyUtil.getInt((String)MAX_PARAM_SIZE_KEY, (int)1000);
    }

    public static RuntimeUserSQL processUserSQL(DBSource.UserSQL userSQL, DBSource.DBType dbType, QingContext qingContext) throws DBKSQLTranslateException, AbstractMacroException, DBKSQLNotSupportException {
        RuntimeUserSQL runtimeUserSQL = new RuntimeUserSQL();
        String sql = userSQL.getContent();
        sql = SQLHelper.systemVarUserSqlTransformToSql(qingContext, sql);
        DBSource.UserSQL.SQLType sqlType = DBSource.UserSQL.SQLType.valueOf(userSQL.getSqlType());
        sql = SQLHelper.ksqlToDialect(dbType, sqlType, sql);
        try {
            IMacroExecutor macroExecutor = RuntimeMacroRegister.getMacroExecutor();
            if (macroExecutor != null && macroExecutor.containsMacro(sql)) {
                sql = SQLHelper.handleMacroAndCollectParams(sql, qingContext, runtimeUserSQL);
            }
            runtimeUserSQL.setSQL(sql);
        }
        catch (AbstractMacroException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MacroExecuteException(e);
        }
        return runtimeUserSQL;
    }

    public static String previewUserSQL(String sql, QingContext qingContext) throws AbstractMacroException {
        RuntimeUserSQL runtimeUserSQL = new RuntimeUserSQL();
        sql = SQLHelper.systemVarUserSqlTransformToSql(qingContext, sql);
        try {
            IMacroExecutor macroExecutor = RuntimeMacroRegister.getMacroExecutor();
            if (macroExecutor != null && macroExecutor.containsMacro(sql)) {
                sql = SQLHelper.handleMacroAndCollectParams(sql, qingContext, runtimeUserSQL);
            }
            List<Object> params = runtimeUserSQL.getParam();
            for (Object param : params) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement("'" + param.toString() + "'"));
            }
        }
        catch (AbstractMacroException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MacroExecuteException(e);
        }
        return sql;
    }

    public static String ksqlToDialect(DBSource.DBType dbType, DBSource.UserSQL.SQLType sqlType, String sql) throws DBKSQLTranslateException, DBKSQLNotSupportException {
        if (DBSource.UserSQL.SQLType.KSQL == sqlType) {
            try {
                int kTargetDbType = DBSource.UserSQL.getKTargetDbType(dbType);
                if (kTargetDbType == 0) {
                    throw new DBKSQLNotSupportException();
                }
                sql = TransUtil.Translate((String)sql, (int)kTargetDbType);
            }
            catch (DBKSQLNotSupportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DBKSQLTranslateException(e);
            }
        }
        return sql;
    }

    public static String systemVarUserSqlTransformToSql(QingContext qingContext, String content) {
        for (SystemVarType systemVarType : SystemVarType.values()) {
            String replaceValue = String.format(USERSQL_SYSTEMVAR_FORMAT, systemVarType.name());
            if (!content.contains(replaceValue)) continue;
            String value = qingContext.getSystemVarStringValue(systemVarType);
            content = value != null ? content.replace(replaceValue, value) : content.replace(replaceValue, "NULL");
        }
        return content;
    }

    public static String openAPISystemVarTransformToSql(QingContext qingContext, String content) {
        for (SystemVarType systemVarType : SystemVarType.values()) {
            String replaceValue = String.format(USERSQL_SYSTEMVAR_FORMAT, systemVarType.name());
            replaceValue = "'" + replaceValue + "'";
            if (!content.contains(replaceValue)) continue;
            String value = qingContext.getSystemVarStringValue(systemVarType);
            content = value != null ? content.replace(replaceValue, value) : content.replace(replaceValue, "NULL");
        }
        return content;
    }

    private static String handleMacroAndCollectParams(String sql, QingContext qingContext, RuntimeUserSQL runtimeUserSQL) throws AbstractMacroException {
        SelectSegment selectSegment = SelectSegmentParser.parse(sql);
        ArrayList<Object> runtimeParams = new ArrayList<Object>();
        SQLHelper.handleWhereCondition(selectSegment, runtimeParams, qingContext);
        for (Object e : runtimeParams) {
            runtimeUserSQL.addParam(e);
        }
        sql = selectSegment.toSQL();
        UnhandledMacroHandler finalHandler = new UnhandledMacroHandler();
        sql = finalHandler.handleSQL(sql, qingContext);
        return sql;
    }

    private static void handleWhereCondition(SelectSegment selectSegment, List<Object> paramsToCollect, QingContext qingContext) throws AbstractMacroException {
        if (selectSegment.hasSubSelect()) {
            List<SelectSegment> subSelects = selectSegment.getSubSelect();
            for (SelectSegment subSelect : subSelects) {
                SQLHelper.handleWhereCondition(subSelect, paramsToCollect, qingContext);
            }
        }
        List<AbstractConditionSegment> whereConditionSegments = selectSegment.getConditionSegments();
        ArrayList<AbstractConditionSegment> conditionSegmentToRemove = new ArrayList<AbstractConditionSegment>();
        ArrayList<AbstractConditionSegment> conditionSegmentToAdd = new ArrayList<AbstractConditionSegment>();
        for (AbstractConditionSegment whereConditionSegment : whereConditionSegments) {
            AbstractMacroSQLSegmentHandler conditionHandler = ConditionSegmentHandlerFactory.createHandler(whereConditionSegment, qingContext);
            conditionHandler.handle(paramsToCollect, whereConditionSegment, conditionSegmentToRemove, conditionSegmentToAdd);
        }
        for (AbstractConditionSegment conditionSegment : conditionSegmentToRemove) {
            selectSegment.removeConditionSegment(conditionSegment);
        }
        for (AbstractConditionSegment conditionSegment : conditionSegmentToAdd) {
            selectSegment.addConditionSegment(conditionSegment);
        }
    }

    public static void setParams(PreparedStatement ps, int index, Object param) throws SQLException {
        if (param != null) {
            if (param instanceof Calendar) {
                Calendar calendar = (Calendar)param;
                Timestamp date = new Timestamp(calendar.getTimeInMillis());
                ps.setTimestamp(index, date);
            } else if (param instanceof Date) {
                Timestamp date = new Timestamp(((Date)param).getTime());
                ps.setTimestamp(index, date);
            } else if (param instanceof Boolean) {
                ps.setBoolean(index, (Boolean)param);
            } else if (param instanceof Long) {
                ps.setLong(index, (Long)param);
            } else if (param instanceof BigDecimal) {
                ps.setBigDecimal(index, (BigDecimal)param);
            } else {
                ps.setString(index, param.toString());
            }
        } else {
            ps.setNull(index, 0);
        }
    }

    public static String sqlReplaceParams(String sql, Object[] params) {
        if (null != params && params.length > 0) {
            int len = params.length;
            for (int i = 0; i < len; ++i) {
                Object value;
                if (params[i] instanceof Calendar) {
                    Calendar calendar = (Calendar)params[i];
                    Timestamp dateValue = new Timestamp(calendar.getTimeInMillis());
                    value = dateValue;
                } else if (params[i] instanceof Date) {
                    Timestamp dateValue = new Timestamp(((Date)params[i]).getTime());
                    value = dateValue;
                } else {
                    value = params[i];
                }
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement("'" + value + "'"));
            }
        }
        return sql;
    }

    public static CallableStatement prepareCall(Connection conn, String callSql) throws SQLException {
        try {
            return conn.prepareCall(callSql);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public static ResultSet getExecResultSet(QingContext qingContext, Connection conn, DBSource dbSource, CallableStatement ps, StoredProcedure storedProce) throws SQLException, AbstractDBSourceException {
        Object objValue;
        int outResultIdx = storedProce.getOutResultIdx() != null ? storedProce.getOutResultIdx() : -1;
        ArrayList<Integer> outParameterIdxList = new ArrayList<Integer>();
        List<StoredProcedureParameter> params = storedProce.getParameters();
        if (params != null && params.size() > 0) {
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                StoredProcedureParameter param = params.get(i);
                if (param.getIoType() == StoredProcedureParameterIoType.IN || param.getIoType() == StoredProcedureParameterIoType.INOUT) {
                    Object originalValue = SQLHelper.getParameterOriginalValue(param, qingContext);
                    SQLHelper.setStoredProceInParameter(ps, i + 1, originalValue, param.getDataType());
                    if (!param.getName().equals(storedProce.getCursorFieldName())) continue;
                    outResultIdx = i + 1;
                    outParameterIdxList.add(i + 1);
                    continue;
                }
                if (param.getIoType() != StoredProcedureParameterIoType.OUT && param.getIoType() != StoredProcedureParameterIoType.INOUT) continue;
                Integer dbDataType = ParameterDataTypeUtil.getOutputDBDataType(dbSource.getDbType(), param.getDataType());
                ps.registerOutParameter(i + 1, (int)dbDataType);
                if (param.getName().equals(storedProce.getCursorFieldName())) {
                    outResultIdx = i + 1;
                }
                outParameterIdxList.add(i + 1);
            }
        }
        if (outResultIdx == -1) {
            throw new DBSPNotFoundResultSetException("" + outResultIdx);
        }
        ResultSet rs = null;
        boolean isOver = false;
        int updateCount = -1;
        boolean flag = ps.execute();
        int point = 1;
        do {
            if (flag) {
                ResultSet resultSet = ps.getResultSet();
                if (resultSet != null && point == outResultIdx) {
                    rs = resultSet;
                    isOver = true;
                }
                if (isOver) continue;
                ++point;
                flag = ps.getMoreResults();
                continue;
            }
            updateCount = ps.getUpdateCount();
            if (updateCount != -1) {
                flag = ps.getMoreResults();
                continue;
            }
            isOver = true;
        } while (!isOver);
        if (rs == null && outParameterIdxList != null && outParameterIdxList.contains(outResultIdx) && (objValue = ps.getObject(outResultIdx)) instanceof ResultSet) {
            rs = (ResultSet)objValue;
        }
        if (rs == null) {
            String storedProceName = StringUtils.isNotBlank((CharSequence)storedProce.getCursorFieldName()) ? storedProce.getCursorFieldName() : "" + outResultIdx;
            throw new DBSPNotFoundResultSetException(storedProceName);
        }
        return rs;
    }

    private static void setStoredProceInParameter(PreparedStatement ps, int index, Object param, ParameterDataType dataType) throws SQLException {
        if (param instanceof String) {
            ps.setString(index, (String)param);
        } else if (param instanceof Calendar) {
            Calendar calendar = (Calendar)param;
            Timestamp date = new Timestamp(calendar.getTimeInMillis());
            ps.setTimestamp(index, date);
        } else if (param instanceof Date) {
            Timestamp date = new Timestamp(((Date)param).getTime());
            ps.setTimestamp(index, date);
        } else if (param instanceof Boolean) {
            ps.setBoolean(index, (Boolean)param);
        } else if (param instanceof Integer) {
            ps.setInt(index, (Integer)param);
        } else if (param instanceof Long) {
            ps.setLong(index, (Long)param);
        } else if (param instanceof BigDecimal) {
            ps.setBigDecimal(index, (BigDecimal)param);
        } else if (param == null) {
            ps.setNull(index, ParameterDataTypeUtil.getInputDBDataType(dataType));
        } else {
            ps.setObject(index, param);
        }
    }

    private static Object getParameterOriginalValue(StoredProcedureParameter parameter, QingContext qingContext) {
        ParameterDataType dataType = parameter.getDataType();
        StroreProcedureValueHandler primaryDataValueHandlerDelegate = new StroreProcedureValueHandler(dataType);
        Object originalValue = null;
        if (parameter.getValue() != null && !"".equals(parameter.getValue()) && parameter.getValueMode() == ValueMode.Const) {
            try {
                String convertedValue = parameter.getValue();
                convertedValue = SQLHelper.systemVarUserSqlTransformToSql(qingContext, convertedValue);
                if (convertedValue.charAt(0) == '\'' && convertedValue.charAt(convertedValue.length() - 1) == '\'') {
                    convertedValue = convertedValue.substring(1, convertedValue.length() - 1);
                }
                Object runtimeValue = primaryDataValueHandlerDelegate.toRuntimeValue(convertedValue);
                originalValue = primaryDataValueHandlerDelegate.toDbFilterValue(runtimeValue);
            }
            catch (IllegalArgumentException e) {
                originalValue = parameter.getValue();
            }
        }
        return originalValue;
    }

    public static class RuntimeUserSQL {
        private String sql;
        private List<Object> params = new ArrayList<Object>();

        public void setSQL(String sql) {
            this.sql = sql;
        }

        public String getSQL() {
            return this.sql;
        }

        public void addParam(Object param) {
            this.params.add(param);
        }

        public void addParams(Collection<Object> params) {
            this.params.addAll(params);
        }

        public List<Object> getParam() {
            return this.params;
        }
    }
}

