/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.source.AbstractBizMetaSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class DmoSource
extends AbstractBizMetaSource {
    public static final String BIZ_DMO_SOURCE_TYPE = "ERPCloudDmo";
    public static final List<String> DB_NEED_SCHEMA_ARR = new ArrayList<String>();
    private Long projectId;
    private String storageId;
    private String storageTypeName;
    private String tableModelType;
    private String schema;
    private List<DBSource.UserSQL> userSqls;

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getTableModelType() {
        return this.tableModelType;
    }

    public void setTableModelType(String tableModelType) {
        this.tableModelType = tableModelType;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getStorageTypeName() {
        return this.storageTypeName;
    }

    public void setStorageTypeName(String storageTypeName) {
        this.storageTypeName = storageTypeName;
    }

    public List<DBSource.UserSQL> getUserSqls() {
        if (null != this.userSqls) {
            ArrayList<DBSource.UserSQL> copys = new ArrayList<DBSource.UserSQL>();
            copys.addAll(this.userSqls);
            return copys;
        }
        return null;
    }

    public DBSource.UserSQL getUserSql(String name) {
        if (this.userSqls != null) {
            for (DBSource.UserSQL userSQL : this.userSqls) {
                if (!userSQL.getName().equals(name)) continue;
                return userSQL;
            }
        }
        return null;
    }

    @Override
    protected void detailToXml(Element node) {
        if (this.projectId != null) {
            node.setAttribute("projectId", this.projectId + "");
        }
        if (this.storageId != null) {
            node.setAttribute("storageId", this.storageId);
        }
        if (this.tableModelType != null) {
            node.setAttribute("entityType", this.tableModelType);
        }
        if (this.storageTypeName != null) {
            node.setAttribute("storageTypeName", this.storageTypeName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.schema)) {
            node.setAttribute("schema", this.schema);
        }
        Element nodeUserSqls = new Element("UserSQLs");
        if (this.userSqls != null && !this.userSqls.isEmpty()) {
            for (DBSource.UserSQL userSql : this.userSqls) {
                Element nodeSql = userSql.toXml();
                nodeUserSqls.addContent((Content)nodeSql);
            }
            node.addContent((Content)nodeUserSqls);
        }
    }

    @Override
    protected void detailFromXml(Element node) throws ModelParseException {
        if (node.getAttributeValue("projectId") != null) {
            this.projectId = Long.parseLong(node.getAttributeValue("projectId"));
        }
        this.storageId = node.getAttributeValue("storageId");
        this.tableModelType = node.getAttributeValue("entityType");
        this.storageTypeName = node.getAttributeValue("storageTypeName");
        this.schema = null != node.getAttributeValue("schema") ? node.getAttributeValue("schema") : "";
        Element nodeUserSqls = node.getChild("UserSQLs");
        if (nodeUserSqls != null) {
            this.userSqls = new ArrayList<DBSource.UserSQL>(nodeUserSqls.getChildren().size());
            for (Element nodeUserSql : nodeUserSqls.getChildren()) {
                DBSource.UserSQL userSql = new DBSource.UserSQL();
                userSql.fromXml(nodeUserSql);
                this.userSqls.add(userSql);
            }
        }
    }

    static {
        DB_NEED_SCHEMA_ARR.add("POSTGRESQL");
        DB_NEED_SCHEMA_ARR.add("ORACLE");
    }
}

