/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.util.LogUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom2.Element;

public class MDDSource
extends AbstractSource {
    private String name;
    private String server;
    private String userName;
    private String password;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServer() {
        return this.server;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public SourceType getType() {
        return SourceType.MDD;
    }

    @Override
    protected Element innerToXml() {
        Element node = new Element("FileSource");
        node.setAttribute("name", this.name);
        node.setAttribute("server", this.server);
        node.setAttribute("userName", this.userName);
        node.setAttribute("password", this.password);
        return node;
    }

    @Override
    public void fromXml(Element node) throws ModelParseException {
        this.name = node.getAttributeValue("name");
        this.server = node.getAttributeValue("server");
        this.userName = node.getAttributeValue("userName");
        this.password = node.getAttributeValue("password");
    }

    @Override
    public String getSourceHashCode() {
        StringBuilder key = new StringBuilder();
        key.append(this.getServer()).append(this.getUserName());
        return DigestUtils.md5Hex((String)key.toString());
    }

    @Override
    public AbstractSource cloneUserRecentUsedSource() {
        MDDSource dbSource = null;
        try {
            dbSource = (MDDSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LogUtil.error((String)"MDDSource cloneUserRecentUsedSource error", (Throwable)e);
        }
        return dbSource;
    }
}

