/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.AbstractAuthModel;
import com.kingdee.bos.qing.util.LogUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class OpenAPISource
extends AbstractSource {
    private String name;
    private String url;
    private OpenAPIType openAPIType;
    private AbstractAuthModel authModel;

    @Override
    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OpenAPIType getOpenAPIType() {
        return this.openAPIType;
    }

    public void setOpenAPIType(OpenAPIType openAPIType) {
        this.openAPIType = openAPIType;
    }

    public AbstractAuthModel getAuthModel() {
        return this.authModel;
    }

    public void setAuthModel(AbstractAuthModel authModel) {
        this.authModel = authModel;
    }

    @Override
    public SourceType getType() {
        return SourceType.OPENAPI;
    }

    @Override
    protected Element innerToXml() {
        Element node = new Element("OpenAPISource");
        node.setAttribute("name", this.name);
        node.setAttribute("url", this.url);
        node.setAttribute("openAPIType", this.openAPIType.toPersistance());
        if (this.authModel != null) {
            node.addContent((Content)this.authModel.toXml());
        }
        return node;
    }

    @Override
    public void fromXml(Element node) throws ModelParseException {
        Element authInfoElement;
        this.name = node.getAttributeValue("name");
        this.url = node.getAttributeValue("url");
        this.openAPIType = OpenAPIType.fromPersistance(node.getAttributeValue("openAPIType"));
        if (this.openAPIType == OpenAPIType.RESTFUL_DATA_SET && (authInfoElement = node.getChild("AuthModel")) != null) {
            this.authModel = AbstractAuthModel.instanceFromXml(authInfoElement);
            if (this.authModel != null) {
                this.authModel.fromXml(authInfoElement);
            }
        }
    }

    @Override
    public String getSourceHashCode() {
        if (this.getAuthModel() == null || this.getAuthModel().getAuthModelHashCode() == null) {
            return DigestUtils.md5Hex((String)this.getUrl());
        }
        return DigestUtils.md5Hex((String)(this.getUrl() + this.getAuthModel().getAuthModelHashCode()));
    }

    @Override
    public AbstractSource cloneUserRecentUsedSource() {
        OpenAPISource openAPISource = null;
        try {
            openAPISource = (OpenAPISource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LogUtil.error((String)"openAPISource cloneUserRecentUsedSource error", (Throwable)e);
        }
        return openAPISource;
    }

    public static enum OpenAPIType {
        RESTFUL_DATA_SET,
        PROGRAM_DATA_SET;


        public String toPersistance() {
            return this.name();
        }

        public static OpenAPIType fromPersistance(String name) throws ModelParseException {
            try {
                return OpenAPIType.valueOf(name);
            }
            catch (Exception ex) {
                throw new ModelParseException("Unknown openAPIType: " + name);
            }
        }
    }
}

