/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.kingdee.bos.qing.common.Messages;
import com.kingdee.bos.qing.data.exception.api.OpenAPIAuthException;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class DigestUtil {
    private static final String nc = "00000001";

    public static String getRequestHeads(String userName, String password, String url) throws OpenAPIAuthException, NoSuchAlgorithmException {
        String wwwAuth = DigestUtil.getChallengeHeads(url);
        String authorization = DigestUtil.getAuthorization(wwwAuth, url.split(".QData")[1], userName, password, "POST");
        return authorization;
    }

    private static String getChallengeHeads(String url) {
        HttpResponse httpResponse = HttpUtil.restfulForEntity((String)url, null, null);
        Header header = httpResponse.getHeaders("WWW-Authenticate")[0];
        return header.getValue();
    }

    private static String getAuthorization(String wwwAuth, String uri, String username, String password, String method) throws OpenAPIAuthException, NoSuchAlgorithmException {
        if (wwwAuth == null || wwwAuth.length() <= 7) {
            return null;
        }
        if (wwwAuth.toLowerCase().indexOf("digest") >= 0) {
            wwwAuth = wwwAuth.substring(6);
        }
        String realm = null;
        String nonce = null;
        String qop = null;
        String algorithm = null;
        try {
            wwwAuth = wwwAuth.replaceAll("\"", "");
            for (String auth : wwwAuth.split(",")) {
                String key = auth.substring(0, auth.indexOf("=")).trim();
                String value = auth.substring(auth.indexOf("=") + 1).trim();
                if ("realm".equals(key)) {
                    realm = value;
                    continue;
                }
                if ("qop".equals(key)) {
                    qop = value;
                    continue;
                }
                if ("nonce".equals(key)) {
                    nonce = value;
                    continue;
                }
                if (!"algorithm".equals(key)) continue;
                algorithm = value;
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"\u6458\u8981\u8ba4\u8bc1\u670d\u52a1\u5668\u8d28\u8be2\u5934\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new OpenAPIAuthException(2061303, e.getMessage());
        }
        if (realm == null || nonce == null || algorithm == null) {
            throw new OpenAPIAuthException(2061303, Messages.getMLS("theDigestAuthHeadParamMissing", "\u6458\u8981\u8ba4\u8bc1\u8d28\u8be2\u5934\u53c2\u6570\u7f3a\u5931"));
        }
        String cnonce = DigestUtil.generateSalt(8);
        String response = DigestUtil.createDigestResponse(username, realm, password, nonce, nc, cnonce, qop, method, uri, algorithm);
        StringBuilder authorization = new StringBuilder();
        authorization.append("Digest ").append("realm=\"").append(realm).append("\",").append("nonce=\"").append(nonce).append("\",").append("algorithm=\"").append(algorithm).append("\",").append("username=\"").append(username).append("\",").append("nc=\"").append(nc).append("\",").append("cnonce=\"").append(cnonce).append("\",").append("uri=\"").append(uri).append("\",").append("method=\"").append(method).append("\",").append("response=\"").append(response).append("\"");
        if (qop != null) {
            authorization.append(",qop=\"").append(qop).append("\"");
        }
        return authorization.toString();
    }

    public static String generateSalt(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                sb.append((char)(random.nextInt(26) + temp));
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            sb.append(random.nextInt(10));
        }
        String val = sb.toString();
        return val.toLowerCase();
    }

    public static String createDigestResponse(String username, String realm, String password, String nonce, String nc, String cnonce, String qop, String method, String uri, String algorithm) {
        String ha1 = "MD5".equals(algorithm) ? DigestUtil.createHa1(username, realm, password) : DigestUtil.createHa1WithSess(username, realm, password, nonce, cnonce);
        byte[] md5Byte = DigestUtil.md5(ha1.getBytes());
        ha1 = new String(Hex.encodeHex((byte[])md5Byte));
        md5Byte = DigestUtil.md5(DigestUtil.createHa2(method, uri).getBytes());
        String ha2 = new String(Hex.encodeHex((byte[])md5Byte));
        String response = qop == null ? ha1 + ":" + nonce + ":" + ha2 : ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2;
        md5Byte = DigestUtil.md5(response.getBytes());
        return new String(Hex.encodeHex((byte[])md5Byte));
    }

    private static String createHa1(String username, String realm, String password) {
        return username + ":" + realm + ":" + password;
    }

    private static String createHa1WithSess(String username, String realm, String password, String nonce, String cnonce) {
        String s = DigestUtil.createHa1(username, realm, password);
        byte[] md5Byte = DigestUtil.md5(s.getBytes());
        String smd5 = new String(Hex.encodeHex((byte[])md5Byte));
        return smd5 + ":" + nonce + ":" + cnonce;
    }

    private static String createHa2(String method, String uri) {
        return method + ":" + uri;
    }

    public static byte[] md5(byte[] input) {
        return DigestUtil.digest(input, "MD5", null, 1);
    }

    private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                messageDigest.update(salt);
            }
            byte[] result = messageDigest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                messageDigest.reset();
                result = messageDigest.digest(result);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            LogUtil.error((String)"\u751f\u6210\u6458\u8981\u7b97\u6cd5\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }
}

