/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.base;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.base.IDataSet;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataSet
implements IDataSet {
    private final List<IDataSet.DataSetCloseListener> closeListeners = new LinkedList<IDataSet.DataSetCloseListener>();
    private final AbstractDataSetModel dataSetModel;
    private boolean isInited = false;
    private boolean hasNextRow;
    private Map<String, Object> currentRow;
    private Object[] currentArrayDatas;
    private boolean visitPrimitiveData;
    private MetaInfo metaInfo;

    protected AbstractDataSet(AbstractDataSetModel dataSetModel) {
        this.dataSetModel = dataSetModel;
        this.metaInfo = dataSetModel.getMetaInfo();
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public AbstractDataSetModel getDataSetModel() {
        return this.dataSetModel;
    }

    @Override
    public void init() throws InterruptedException, AbstractDataSourceException {
        if (this.isInited) {
            return;
        }
        this.isInited = true;
        this.firstRow();
    }

    @Override
    public final void firstRow() throws InterruptedException, AbstractDataSourceException {
        this.beforeFirst();
        this.nextRow();
    }

    protected abstract void beforeFirst() throws InterruptedException, AbstractDataSourceException;

    @Override
    public final boolean hasNextRow() {
        return this.hasNextRow;
    }

    @Override
    public final Map<String, Object> getCurrentRow() {
        return this.currentRow;
    }

    public final Object[] getCurrentArrayDatas() {
        return this.currentArrayDatas;
    }

    protected final void setCurrentRow(Map<String, Object> currentRow) {
        this.currentRow = currentRow;
        this.currentArrayDatas = currentRow != null ? JoinUtil.mapToObject(this.metaInfo, currentRow) : null;
        this.hasNextRow = currentRow != null;
    }

    protected final void setCurrentArrayDatas(Object[] rowDatas) {
        this.currentArrayDatas = rowDatas;
        this.hasNextRow = rowDatas != null;
    }

    @Override
    public final void addCloseListener(IDataSet.DataSetCloseListener closeListener) {
        if (closeListener != null) {
            this.closeListeners.add(closeListener);
        }
    }

    @Override
    public void close() {
        this.currentRow = null;
        this.hasNextRow = false;
        this.isInited = false;
        if (this.closeListeners != null) {
            for (IDataSet.DataSetCloseListener closeListener : this.closeListeners) {
                closeListener.onClose();
            }
            this.closeListeners.clear();
        }
    }

    public void setVisitPrimitiveData(boolean visitPrimitiveData) {
        this.visitPrimitiveData = visitPrimitiveData;
    }

    boolean isVisitPrimitiveData() {
        return this.visitPrimitiveData;
    }

    public final boolean isSortedBy(DSFieldKey field) {
        return this.dataSetModel.isSortedBy(field);
    }
}

