/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.base;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.model.DataSetModel;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceCountable;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QsDataSourceVisitorWrapper;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PersistentDataSet
extends AbstractAtomicDataSet {
    private static final String DATAITERATOR_KEY = ".DATAITERATOR_KEY.";
    private List<Map<String, Object>> innerRows;
    private long rowCount;

    public PersistentDataSet(DataSetModel dataSetModel) {
        super(dataSetModel);
        List<IDataSourceVisitor> dataSourceVisitors = dataSetModel.getDataSourceVisitors();
        this.rowCount = 0L;
        for (IDataSourceVisitor dataSourceVisitor : dataSourceVisitors) {
            if (dataSourceVisitor instanceof IDataSourceCountable) {
                IDataSourceCountable dataSourceCountable = (IDataSourceCountable)dataSourceVisitor;
                this.rowCount += dataSourceCountable.getRowCount();
                continue;
            }
            this.rowCount = -1L;
            break;
        }
    }

    public PersistentDataSet(DataSetModel dataSetModel, boolean visitPrimitiveData) {
        this(dataSetModel);
        this.setVisitPrimitiveData(visitPrimitiveData);
    }

    @Override
    public DataSetModel getDataSetModel() {
        return (DataSetModel)super.getDataSetModel();
    }

    @Override
    public long getAdvisesRowCount() {
        return this.rowCount;
    }

    @Override
    public boolean nextRow() throws InterruptedException, AbstractDataSourceException {
        if (this.innerRows != null) {
            if (this.innerRows.size() >= 1) {
                Map<String, Object> currentRow = this.innerRows.remove(0);
                IDataIterator dataIterator = (IDataIterator)currentRow.remove(DATAITERATOR_KEY);
                this.setCurrentRow(currentRow);
                this.insertNextValueToInnerRow(dataIterator);
            } else {
                this.setCurrentRow(null);
            }
        } else {
            this.setCurrentRow(null);
        }
        return true;
    }

    @Override
    protected void beforeFirst() throws InterruptedException, AbstractDataSourceException {
        if (this.getAdvisesRowCount() == 0L) {
            this.innerRows = null;
        } else {
            if (this.innerRows != null) {
                for (Map<String, Object> oneRow : this.innerRows) {
                    IDataIterator dataIterator = (IDataIterator)oneRow.get(DATAITERATOR_KEY);
                    dataIterator.close();
                }
                this.innerRows.clear();
            } else {
                this.innerRows = new LinkedList<Map<String, Object>>();
            }
            List<IDataIterator> dataIterators = this.initFileDataIerator();
            this.initInnerRows(dataIterators);
        }
    }

    private void insertInnerRow(IDataIterator dataIterator, Map<String, Object> oneRow) {
        if (oneRow != null) {
            oneRow.put(DATAITERATOR_KEY, dataIterator);
            if (this.innerRows.isEmpty()) {
                this.innerRows.add(oneRow);
            } else if (this.getDataSetModel().getRowValueComparator() != null) {
                int insertIndex = Collections.binarySearch(this.innerRows, oneRow, this.getDataSetModel().getRowValueComparator());
                if ((insertIndex = Math.abs(insertIndex + 1)) > this.innerRows.size()) {
                    insertIndex = this.innerRows.size();
                }
                this.innerRows.add(insertIndex, oneRow);
            } else {
                this.innerRows.add(oneRow);
            }
        } else {
            dataIterator.close();
        }
    }

    private void initInnerRows(List<IDataIterator> dataIterators) throws InterruptedException, AbstractDataSourceException {
        try {
            for (IDataIterator dataIterator : dataIterators) {
                Map oneRow = null;
                while (oneRow == null && dataIterator.hasNextRow()) {
                    oneRow = dataIterator.nextRow();
                }
                this.insertInnerRow(dataIterator, oneRow);
            }
        }
        catch (AbstractDataSourceException e) {
            CloseUtil.close(dataIterators);
            dataIterators.clear();
            this.innerRows.clear();
            throw e;
        }
        catch (InterruptedException e) {
            CloseUtil.close(dataIterators);
            dataIterators.clear();
            this.innerRows.clear();
            throw e;
        }
    }

    private void insertNextValueToInnerRow(IDataIterator dataIterator) throws InterruptedException, AbstractDataSourceException {
        Map oneRow = null;
        try {
            while (oneRow == null && dataIterator.hasNextRow()) {
                oneRow = dataIterator.nextRow();
            }
        }
        catch (AbstractDataSourceException e) {
            dataIterator.close();
            throw e;
        }
        catch (InterruptedException e) {
            dataIterator.close();
            throw e;
        }
        this.insertInnerRow(dataIterator, oneRow);
    }

    private IDataSourceVisitor wrapVisistor(IDataSourceVisitor dataSourceVisitor) {
        if (this.isVisitPrimitiveData() && dataSourceVisitor instanceof QSDataSourceVisitor) {
            return new QsDataSourceVisitorWrapper((QSDataSourceVisitor)dataSourceVisitor, true);
        }
        return dataSourceVisitor;
    }

    private List<IDataIterator> initFileDataIerator() throws InterruptedException, AbstractDataSourceException {
        ArrayList<IDataIterator> smallSortedFileDataIerators = new ArrayList<IDataIterator>();
        try {
            List<IDataSourceVisitor> dataSourceVisitors = this.getDataSetModel().getDataSourceVisitors();
            Set<DSFieldKey> selectedFields = this.getDataSetModel().getSelectedFields();
            for (int fileIndex = 0; fileIndex < dataSourceVisitors.size(); ++fileIndex) {
                IDataSourceVisitor dataSourceVisitor = this.wrapVisistor(dataSourceVisitors.get(fileIndex));
                IDataIterator dataIterator = dataSourceVisitor.iterator();
                dataIterator.init(selectedFields, this.getDataSetModel().getFilters(), null);
                smallSortedFileDataIerators.add(dataIterator);
            }
        }
        catch (AbstractDataSourceException e) {
            CloseUtil.close(smallSortedFileDataIerators);
            throw e;
        }
        catch (InterruptedException e) {
            CloseUtil.close(smallSortedFileDataIerators);
            throw e;
        }
        return smallSortedFileDataIerators;
    }

    private void clearInnerRow() {
        if (this.innerRows != null) {
            for (Map<String, Object> oneRow : this.innerRows) {
                IDataIterator dataIterator = (IDataIterator)oneRow.get(DATAITERATOR_KEY);
                CloseUtil.close((Closeable[])new Closeable[]{dataIterator});
            }
            this.innerRows.clear();
            this.innerRows = null;
        }
    }

    @Override
    public void close() {
        this.clearInnerRow();
        super.close();
    }
}

