/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.bnl;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.base.AbstractDataSet;
import com.kingdee.bos.qing.datasource.join.base.AbstractJoinDataSet;
import com.kingdee.bos.qing.datasource.join.base.JoinBuffer;
import com.kingdee.bos.qing.datasource.memorymanage.DataRowSize;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.datasource.util.ConvertUtil;
import java.util.Map;

public abstract class AbstractBlockNestedLoopJoinDataSet
extends AbstractJoinDataSet {
    protected JoinBuffer leftJoinBuffer;
    protected Map<String, Object> rightCompareRowValue;

    public AbstractBlockNestedLoopJoinDataSet(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption) {
        super(leftDataSet, rightDataSet, joinDataSetModel, joinOption);
    }

    @Override
    protected final void initTwoSizeCompareValue() throws AbstractDataSourceException, InterruptedException {
        this.rightCompareRowValue = this.getRightDataSet().getCurrentRow();
        if (this.leftJoinBuffer == null) {
            this.leftJoinBuffer = this.getOnePageRowValuesToMemory(this.getLeftDataSet(), this.getLeftField(), this.isChangeLeftToString(), this.joinOption);
        }
    }

    private JoinBuffer getOnePageRowValuesToMemory(AbstractDataSet dataSet, DSFieldKey fieldKey, boolean changeToString, JoinOption joinOption) throws AbstractDataSourceException, InterruptedException {
        MetaInfo metaInfo = dataSet.getDataSetModel().getMetaInfo();
        DataRowSize rowSize = new DataRowSize(metaInfo);
        JoinBuffer joinBuffer = new JoinBuffer();
        int count = 0;
        int estimateSize = 0;
        while (dataSet.hasNextRow() && estimateSize < 0x3200000) {
            Map<String, Object> leftRowValues = dataSet.getCurrentRow();
            Object leftCompareValue = leftRowValues.get(fieldKey.toFullName());
            if (changeToString) {
                leftCompareValue = ConvertUtil.convertToString((Object)leftCompareValue);
            }
            joinBuffer.addValues(leftCompareValue, leftRowValues);
            dataSet.nextRow();
            estimateSize = (int)((long)estimateSize + rowSize.sizeOf(leftRowValues));
            ++count;
        }
        joinOption.setCachePageSize(count);
        return joinBuffer;
    }

    @Override
    protected final void beforeFirst() throws AbstractDataSourceException, InterruptedException {
        this.leftJoinBuffer = null;
        this.rightCompareRowValue = null;
        this.getLeftDataSet().firstRow();
        this.getRightDataSet().firstRow();
    }

    @Override
    public final void close() {
        this.leftJoinBuffer = null;
        this.rightCompareRowValue = null;
        super.close();
    }
}

