/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.base.JoinFactory;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskTemplate;
import com.kingdee.bos.qing.datasource.join.task.JoinTracer;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskCancelType;
import com.kingdee.bos.qing.datasource.memorymanage.DataRowSize;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;

public class DataSetJoinTask
extends JoinTaskTemplate<Object> {
    private static final long serialVersionUID = 7055074060264986256L;
    private AbstractAtomicDataSet leftDataSet = null;
    private AbstractAtomicDataSet rightDataSet = null;
    private JoinDataSetModel joinDataSetModel;
    private MultiDataSourceWrap multiDataSourceWrap;
    private JoinOption joinOption;
    private QSDataSourceWriter joinDataWriter;
    private JoinTracer joinTracer;

    public DataSetJoinTask(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption, JoinTaskRuntime runtime) {
        super(runtime, false);
        this.joinDataSetModel = joinDataSetModel;
        this.leftDataSet = leftDataSet;
        this.rightDataSet = rightDataSet;
        this.joinOption = joinOption;
    }

    public DataSetJoinTask(MultiDataSourceWrap multiDataSourceWrap, AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption, JoinTaskRuntime runtime) {
        super(runtime, false);
        this.multiDataSourceWrap = multiDataSourceWrap;
        this.joinDataSetModel = joinDataSetModel;
        this.leftDataSet = leftDataSet;
        this.rightDataSet = rightDataSet;
        this.joinOption = joinOption;
    }

    public void setJoinDataWriter(QSDataSourceWriter joinDataWriter) {
        this.joinDataWriter = joinDataWriter;
    }

    private void initDataSet(AbstractAtomicDataSet dataSet) throws AbstractDataSourceException, InterruptedException {
        try {
            dataSet.init();
        }
        catch (AbstractDataSourceException e) {
            dataSet.close();
            throw e;
        }
        catch (InterruptedException e) {
            dataSet.close();
            throw e;
        }
    }

    private void createJoinTracerBeforeJoin() {
        this.joinTracer = this.getTaskRuntime().newJoinTracer(this.leftDataSet.getDataSetModel().getEntityNames(), this.rightDataSet.getDataSetModel().getEntityNames());
        this.joinTracer.setJoinType(this.joinDataSetModel.getJoinType());
        this.joinTracer.setLeftRowCount(this.leftDataSet.getAdvisesRowCount());
        this.joinTracer.setRightRowCount(this.rightDataSet.getAdvisesRowCount());
        this.joinTracer.setBeginTime(System.currentTimeMillis());
    }

    @Override
    protected Object doCompute() {
        this.createJoinTracerBeforeJoin();
        TraceSpan traceSpan = null;
        try {
            traceSpan = TraceSpan.createEmpty((String)"\u5b50JOIN\u4efb\u52a1");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".doCompute");
            traceSpan.addAttribute("\u5de6\u8868\u540d", this.leftDataSet.getDataSetModel().getEntityNames().toString());
            traceSpan.addAttribute("\u53f3\u8868\u540d", this.rightDataSet.getDataSetModel().getEntityNames().toString());
            traceSpan.addAttribute("JOIN\u7c7b\u578b", this.joinDataSetModel.getJoinType().name());
            traceSpan.addAttribute("\u7ed3\u679c\u8868\u540d", this.joinDataSetModel.getEntityNames().toString());
            try {
                this.initDataSet(this.leftDataSet);
            }
            catch (DataSourceNoDataException e) {
                this.leftDataSet = null;
            }
            try {
                this.initDataSet(this.rightDataSet);
            }
            catch (DataSourceNoDataException e) {
                this.rightDataSet = null;
            }
            if (this.joinDataSetModel.getJoinType() != null) {
                switch (this.joinDataSetModel.getJoinType()) {
                    case LeftJoin: {
                        this.doLeftJoin(this.leftDataSet, this.rightDataSet, this.joinDataSetModel);
                        break;
                    }
                    case InnerJoin: {
                        this.doInnerJoin(this.leftDataSet, this.rightDataSet, this.joinDataSetModel);
                        break;
                    }
                    case FullJoin: {
                        this.doFullJoin(this.leftDataSet, this.rightDataSet, this.joinDataSetModel);
                        break;
                    }
                }
            } else {
                this.doFullJoin(this.leftDataSet, this.rightDataSet, this.joinDataSetModel);
            }
        }
        catch (Exception e) {
            CloseUtil.close((Closeable[])new Closeable[]{this.leftDataSet, this.rightDataSet});
            this.joinTracer.setStatus(-1);
            this.completeExceptionally(e);
        }
        finally {
            this.finishOpTraceSpan(traceSpan);
            this.finishJoinTracer();
        }
        return null;
    }

    private void finishJoinTracer() {
        this.joinTracer.setJoinCost(System.currentTimeMillis() - this.joinTracer.getBeginTime());
        if (this.joinTracer.getStatus() == 0) {
            this.joinTracer.setStatus(1);
        }
    }

    private void finishOpTraceSpan(TraceSpan traceSpan) {
        if (traceSpan != null) {
            traceSpan.addAttribute("\u91cd\u8bd5\u6b21\u6570", String.valueOf(this.taskRuntime.getRetryTimes()));
            TaskCancelType taskCancelType = this.taskRuntime.getCancelSync().get();
            if (taskCancelType != null) {
                traceSpan.addAttribute("\u72b6\u6001", "\u5931\u8d25");
                traceSpan.addAttribute("\u53d6\u6d88\u539f\u56e0", taskCancelType.getCancelDesc());
            } else {
                traceSpan.addAttribute("\u72b6\u6001", "\u6210\u529f");
            }
            traceSpan.close();
            this.taskRuntime.appendToParentTraceSpan(traceSpan);
        }
    }

    private void doLeftJoin(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel) throws AbstractDataSourceException, InterruptedException {
        if (leftDataSet == null) {
            return;
        }
        JoinFactory.JoinStrategy joinStrategy = this.joinOption.getAssignmentJoinStrategy();
        if (rightDataSet != null && joinStrategy == null && rightDataSet.getAdvisesRowCount() >= 0L && leftDataSet.getAdvisesRowCount() >= 0L) {
            long rightDataSize = this.estimateSize(rightDataSet);
            long leftDataSize = this.estimateSize(leftDataSet);
            if (rightDataSize <= 0x3200000L || leftDataSize <= 0x3200000L) {
                joinStrategy = JoinFactory.JoinStrategy.BNLJOIN;
            }
        }
        if (joinStrategy == null) {
            joinStrategy = !this.joinOption.isPartitionIfNeed() ? JoinFactory.JoinStrategy.BNLJOIN : JoinFactory.JoinStrategy.SHJOIN;
        }
        this.joinTracer.setJoinStrategy(joinStrategy);
        JoinFactory joinFactory = JoinFactory.getJoinFactory(joinStrategy);
        if (rightDataSet != null) {
            joinFactory.leftJoin(this.joinOption.isCacheJoinDataSet() ? this.multiDataSourceWrap : null, leftDataSet, rightDataSet, joinDataSetModel, this.joinOption, this.joinDataWriter, this.getTaskRuntime());
        } else {
            joinFactory.writeOneDataSetResult(this.joinDataWriter, joinDataSetModel.getMetaInfo(), leftDataSet, this.getTaskRuntime());
        }
    }

    private long estimateSize(AbstractAtomicDataSet dataSet) {
        MetaInfo metaInfo = dataSet.getDataSetModel().getMetaInfo();
        DataRowSize rowSize = new DataRowSize(metaInfo);
        return rowSize.getMinRetainSize() * dataSet.getAdvisesRowCount();
    }

    private void doInnerJoin(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel) throws AbstractDataSourceException, InterruptedException {
        if (leftDataSet == null || rightDataSet == null) {
            return;
        }
        JoinFactory.JoinStrategy joinStrategy = this.joinOption.getAssignmentJoinStrategy();
        if (joinStrategy == null && rightDataSet.getAdvisesRowCount() >= 0L && leftDataSet.getAdvisesRowCount() >= 0L) {
            long rightSize = this.estimateSize(rightDataSet);
            long leftSize = this.estimateSize(leftDataSet);
            if (rightSize <= 0x3200000L || leftSize <= 0x3200000L) {
                joinStrategy = JoinFactory.JoinStrategy.BNLJOIN;
                if (rightSize < leftSize) {
                    AbstractAtomicDataSet tempDataSet = rightDataSet;
                    rightDataSet = leftDataSet;
                    leftDataSet = tempDataSet;
                    joinDataSetModel = JoinDataSetModel.createJoinDataSetModelExchangeBothSide(joinDataSetModel);
                }
            }
        }
        if (joinStrategy == null) {
            joinStrategy = !this.joinOption.isPartitionIfNeed() ? JoinFactory.JoinStrategy.BNLJOIN : JoinFactory.JoinStrategy.SHJOIN;
        }
        this.joinTracer.setJoinStrategy(joinStrategy);
        JoinFactory joinFactory = JoinFactory.getJoinFactory(joinStrategy);
        joinFactory.innerJoin(this.joinOption.isCacheJoinDataSet() ? this.multiDataSourceWrap : null, leftDataSet, rightDataSet, joinDataSetModel, this.joinOption, this.joinDataWriter, this.getTaskRuntime());
    }

    private void doFullJoin(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel) throws AbstractDataSourceException, InterruptedException {
        if (leftDataSet == null && rightDataSet == null) {
            return;
        }
        JoinFactory.JoinStrategy joinStrategy = this.joinOption.getAssignmentJoinStrategy();
        if (rightDataSet != null && leftDataSet != null && joinStrategy == null && rightDataSet.getAdvisesRowCount() >= 0L && leftDataSet.getAdvisesRowCount() >= 0L) {
            long rightSize = this.estimateSize(rightDataSet);
            long leftSize = this.estimateSize(leftDataSet);
            if (rightSize <= 0x3200000L && leftSize <= 0x3200000L) {
                joinStrategy = JoinFactory.JoinStrategy.BNLJOIN;
                if (rightSize < leftSize) {
                    AbstractAtomicDataSet tempDataSet = rightDataSet;
                    rightDataSet = leftDataSet;
                    leftDataSet = tempDataSet;
                    joinDataSetModel = JoinDataSetModel.createJoinDataSetModelExchangeBothSide(joinDataSetModel);
                }
            }
        }
        if (joinStrategy == null) {
            joinStrategy = !this.joinOption.isPartitionIfNeed() ? JoinFactory.JoinStrategy.BNLJOIN : JoinFactory.JoinStrategy.SHJOIN;
        }
        this.joinTracer.setJoinStrategy(joinStrategy);
        JoinFactory joinFactory = JoinFactory.getJoinFactory(joinStrategy);
        if (leftDataSet != null && rightDataSet != null) {
            joinFactory.fullJoin(this.joinOption.isCacheJoinDataSet() ? this.multiDataSourceWrap : null, leftDataSet, rightDataSet, joinDataSetModel, this.joinOption, this.joinDataWriter, this.getTaskRuntime());
        } else {
            AbstractAtomicDataSet joininDataSet = null;
            if (leftDataSet != null) {
                joininDataSet = leftDataSet;
            }
            if (rightDataSet != null) {
                joininDataSet = rightDataSet;
            }
            if (joininDataSet != null) {
                joinFactory.writeOneDataSetResult(this.joinDataWriter, joinDataSetModel.getMetaInfo(), joininDataSet, this.getTaskRuntime());
            }
        }
    }
}

