/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.DataJoinCancelException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.base.AbstractDataSet;
import com.kingdee.bos.qing.datasource.join.base.PersistentDataSet;
import com.kingdee.bos.qing.datasource.join.cache.SharedJoinFile;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.datasource.join.task.DataSetJoinTask;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskTemplate;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskCancelType;
import com.kingdee.bos.qing.datasource.join.util.DeleteTempFileCloseListener;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import com.kingdee.bos.qing.datasource.model.DataSetModel;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceAsyncWriter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MessageDigestUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Set;

public class DataSetTask
extends JoinTaskTemplate<AbstractAtomicDataSet> {
    private static final long serialVersionUID = -5774752391572115304L;
    private AbstractDataSetModel dataSetModel;
    private MultiDataSourceWrap multiDataSourceWrap;
    private JoinOption joinOption;
    private boolean invokeByRootTask;

    public DataSetTask(AbstractDataSetModel dataSetModel, JoinTaskRuntime runtime) {
        super(runtime, false);
        this.dataSetModel = dataSetModel;
        this.multiDataSourceWrap = runtime.getTaskRequest().getMultiDataSourceWrap();
        this.joinOption = runtime.getTaskRequest().getJoinOption();
    }

    public DataSetTask(JoinTaskRuntime taskRuntime, AbstractDataSetModel dataSetModel, boolean invokeByRootTask) {
        this(dataSetModel, taskRuntime);
        this.invokeByRootTask = invokeByRootTask;
    }

    @Override
    protected AbstractAtomicDataSet doCompute() {
        if (this.dataSetModel instanceof DataSetModel) {
            return this.computeAtomicDataSet();
        }
        return this.computeJoinDataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQingFile querySharedJoinFile(String sharedJoinFileCacheKey) {
        JoinDataSetModel joinDataSetModel = (JoinDataSetModel)this.dataSetModel;
        Set<String> entityNames = joinDataSetModel.getEntityNames();
        SharedJoinFile sharedJoinFile = (SharedJoinFile)QingSessionUtil.getGlobalQingSessionImpl().getCache(sharedJoinFileCacheKey, SharedJoinFile.class);
        if (null != sharedJoinFile) {
            TraceSpan traceSpan = null;
            try {
                traceSpan = TraceSpan.createEmpty((String)"\u547d\u4e2d\u5171\u4eabJOIN\u4efb\u52a1");
                traceSpan.addClassMethodAttribute(this.getClass().getName() + ".computeJoinDataSet");
                traceSpan.addAttribute("\u5de6\u8868\u540d", joinDataSetModel.getLeftDataSetModel().getEntityNames().toString());
                traceSpan.addAttribute("\u53f3\u8868\u540d", joinDataSetModel.getRightDataSetModel().getEntityNames().toString());
                traceSpan.addAttribute("JOIN\u7c7b\u578b", joinDataSetModel.getJoinType().name());
                traceSpan.addAttribute("\u547d\u4e2d\u8868\u540d", entityNames.toString());
                traceSpan.addAttribute("\u5386\u53f2JOIN\u4efb\u52a1\u8017\u65f6", String.valueOf(sharedJoinFile.getCost()));
                IQingFileVisitor sharedJoinFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)sharedJoinFile.getJoinFileName());
                if (!sharedJoinFileVisitor.exists()) {
                    IQingFile iQingFile = null;
                    return iQingFile;
                }
                this.getTaskRuntime().addSharedJoinedFileKey(sharedJoinFileCacheKey);
                sharedJoinFile.increaseCount();
                QingSessionUtil.getGlobalQingSessionImpl().setCache((ISessionCacheable)sharedJoinFile);
                LogUtil.info((String)("use shared join file:" + sharedJoinFile.getJoinFileName() + ", left entity:" + sharedJoinFile.getLeftEntityNames() + ",rightEntity:" + sharedJoinFile.getRightEntityNames()));
                IQingFile iQingFile = (IQingFile)sharedJoinFileVisitor;
                return iQingFile;
            }
            finally {
                if (traceSpan != null) {
                    traceSpan.close();
                    this.taskRuntime.appendToParentTraceSpan(traceSpan);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private AbstractAtomicDataSet computeJoinDataSet() {
        block24: {
            joinDataSetModel = (JoinDataSetModel)this.dataSetModel;
            dataSourceVisitor = null;
            try {
                dataSourceVisitor = this.multiDataSourceWrap.get(this.dataSetModel.getEntityNames());
            }
            catch (AbstractDataSourceException e) {
                this.completeExceptionally(e);
                return null;
            }
            selectFields = joinDataSetModel.getMetaInfo().getFieldNames();
            if (null != dataSourceVisitor && dataSourceVisitor.isFieldsExisted(selectFields)) {
                return this.getHistoryJoinDataSet();
            }
            result = null;
            leftDataSetTask = new DataSetTask(joinDataSetModel.getLeftDataSetModel(), this.getTaskRuntime());
            rightDataSetTask = new DataSetTask(joinDataSetModel.getRightDataSetModel(), this.getTaskRuntime());
            DataSetTask.invokeAll(leftDataSetTask, rightDataSetTask);
            leftDataSet = null;
            rightDataSet = null;
            joinResultWriter = null;
            exception = null;
            newDataFile = null;
            joinUniqueKey = this.createJoinUniqueKey();
            lock = null;
            try {
                if (null != joinUniqueKey) {
                    lock = LockFactory.createGlobalLock((String)joinUniqueKey);
                }
                if ((reservedTime = (long)(QingJoinConfig.getInstance().getTimeout() * 1000) - this.getTaskRuntime().getRunningTime()) <= 0L) {
                    throw new DataJoinCancelException(TaskCancelType.TIMEOUT);
                }
                if (null != lock) {
                    if (lock.tryLock(reservedTime)) {
                        newDataFile = this.querySharedJoinFile(joinUniqueKey);
                    } else {
                        throw new DataJoinCancelException(TaskCancelType.TIMEOUT);
                    }
                }
                if (null != newDataFile) break block24;
                begin = System.currentTimeMillis();
                taskRuntime = this.getTaskRuntime();
                newDataFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
                leftDataSet = (AbstractAtomicDataSet)leftDataSetTask.join();
                rightDataSet = (AbstractAtomicDataSet)rightDataSetTask.join();
                joinResultWriter = new QSDataSourceAsyncWriter(newDataFile);
                joinResultWriter.start(this.dataSetModel.getMetaInfo());
                taskRuntime.addJoinAdviseRow(leftDataSet.getAdvisesRowCount() + rightDataSet.getAdvisesRowCount());
                dataSetJoinTask = new DataSetJoinTask(this.multiDataSourceWrap, leftDataSet, rightDataSet, joinDataSetModel, this.joinOption, this.getTaskRuntime());
                dataSetJoinTask.setJoinDataWriter(joinResultWriter);
                dataSetJoinTask.fork();
                dataSetJoinTask.join();
                joinResultWriter.finishWriteData();
                end = System.currentTimeMillis();
                cost = end - begin;
                this.cacheJoinFile(joinDataSetModel, newDataFile, joinUniqueKey, taskRuntime, cost);
            }
            catch (Exception e) {
                try {
                    exception = e;
                }
                catch (Throwable var24_23) {
                    CloseUtil.close((Closeable[])new Closeable[]{leftDataSet, rightDataSet});
                    if (null != joinResultWriter) {
                        joinResultWriter.close(exception);
                    }
                    if (null != lock) {
                        lock.unlock();
                    }
                    if (exception != null) {
                        this.completeExceptionally(exception);
                    }
                    throw var24_23;
                }
                CloseUtil.close((Closeable[])new Closeable[]{leftDataSet, rightDataSet});
                if (null != joinResultWriter) {
                    joinResultWriter.close(exception);
                }
                if (null != lock) {
                    lock.unlock();
                }
                if (exception != null) {
                    this.completeExceptionally(exception);
                } else {
                    ** GOTO lbl81
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{leftDataSet, rightDataSet});
        if (null != joinResultWriter) {
            joinResultWriter.close(exception);
        }
        if (null != lock) {
            lock.unlock();
        }
        if (exception != null) {
            this.completeExceptionally(exception);
        }
        try {
            if (newDataFile != null) {
                result = this.createDataSet(this.multiDataSourceWrap, newDataFile);
            }
        }
        catch (AbstractDataSourceException e) {
            this.completeExceptionally(e);
        }
        return result;
    }

    private void cacheJoinFile(JoinDataSetModel joinDataSetModel, IQingFile newDataFile, String joinUniqueKey, JoinTaskRuntime taskRuntime, long cost) {
        if (null == joinUniqueKey) {
            return;
        }
        SharedJoinFile sharedJoinFile = new SharedJoinFile();
        sharedJoinFile.setCacheKey(joinUniqueKey);
        sharedJoinFile.setLeftEntityNames(joinDataSetModel.getLeftDataSetModel().getEntityNames());
        sharedJoinFile.setRightEntityNames(joinDataSetModel.getRightDataSetModel().getEntityNames());
        sharedJoinFile.setJoinFileName(newDataFile.getName());
        sharedJoinFile.increaseCount();
        sharedJoinFile.setCost(cost);
        taskRuntime.addSharedJoinedFileKey(joinUniqueKey);
        LogUtil.info((String)("cache shared join file:" + sharedJoinFile.getJoinFileName() + ", left entity:" + sharedJoinFile.getLeftEntityNames() + ",rightEntity:" + sharedJoinFile.getRightEntityNames()));
        QingSessionUtil.getGlobalQingSessionImpl().setCache((ISessionCacheable)sharedJoinFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAtomicDataSet getHistoryJoinDataSet() {
        JoinDataSetModel joinDataSetModel = (JoinDataSetModel)this.dataSetModel;
        Set<String> entityNames = joinDataSetModel.getEntityNames();
        MetaInfo metaInfo = joinDataSetModel.getMetaInfo();
        PersistentDataSet result = null;
        TraceSpan traceSpan = null;
        try {
            traceSpan = TraceSpan.createEmpty((String)"\u547d\u4e2d\u5386\u53f2JOIN\u4efb\u52a1");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".computeJoinDataSet");
            traceSpan.addAttribute("\u5de6\u8868\u540d", joinDataSetModel.getLeftDataSetModel().getEntityNames().toString());
            traceSpan.addAttribute("\u53f3\u8868\u540d", joinDataSetModel.getRightDataSetModel().getEntityNames().toString());
            traceSpan.addAttribute("JOIN\u7c7b\u578b", joinDataSetModel.getJoinType().name());
            traceSpan.addAttribute("\u547d\u4e2d\u8868\u540d", entityNames.toString());
            ArrayList<IDataSourceVisitor> dataSourceVisitors = new ArrayList<IDataSourceVisitor>();
            dataSourceVisitors.add(this.multiDataSourceWrap.get(entityNames));
            DataSetModel atomicDataSetModel = new DataSetModel(entityNames, metaInfo, null, dataSourceVisitors);
            result = new PersistentDataSet(atomicDataSetModel, this.needVisitPrimitiveData());
        }
        catch (Exception e) {
            CloseUtil.close((Closeable[])new Closeable[]{result});
            this.completeExceptionally(e);
        }
        finally {
            if (traceSpan != null) {
                traceSpan.close();
                this.taskRuntime.appendToParentTraceSpan(traceSpan);
            }
        }
        return result;
    }

    private String createJoinUniqueKey() {
        try {
            JoinDataSetModel joinDataSetModel = (JoinDataSetModel)this.dataSetModel;
            AbstractSingleDataSourceVisitor leftDataSourceVisitor = this.multiDataSourceWrap.get(joinDataSetModel.getLeftDataSetModel().getEntityNames());
            AbstractSingleDataSourceVisitor rightDataSourceVisitor = this.multiDataSourceWrap.get(joinDataSetModel.getRightDataSetModel().getEntityNames());
            if (leftDataSourceVisitor instanceof QSDataSourceVisitor && rightDataSourceVisitor instanceof QSDataSourceVisitor) {
                String leftFileName = ((QSDataSourceVisitor)leftDataSourceVisitor).getDataFile().getName();
                String rightFileName = ((QSDataSourceVisitor)rightDataSourceVisitor).getDataFile().getName();
                return MessageDigestUtil.getUniqueCode((Object[])new String[]{leftFileName, rightFileName, joinDataSetModel.getModelDesc()});
            }
        }
        catch (AbstractDataSourceException e) {
            LogUtil.error((String)"", (Throwable)e);
        }
        return null;
    }

    private boolean needVisitPrimitiveData() {
        return !this.invokeByRootTask;
    }

    private AbstractAtomicDataSet computeAtomicDataSet() {
        PersistentDataSet result = new PersistentDataSet((DataSetModel)this.dataSetModel, this.needVisitPrimitiveData());
        try {
            return result;
        }
        catch (Exception e) {
            ((AbstractDataSet)result).close();
            this.completeExceptionally(e);
            return null;
        }
    }

    private AbstractAtomicDataSet createDataSet(MultiDataSourceWrap multiDataSourceWrap, IQingFile newdataFile) throws AbstractDataSourceException {
        PersistentDataSet result = null;
        try {
            Set<String> entityNameSet = this.dataSetModel.getEntityNames();
            MetaInfo metaInfo = this.dataSetModel.getMetaInfo();
            QSDataSourceVisitor dataSourceVisitor = new QSDataSourceVisitor((IQingFileVisitor)newdataFile);
            ArrayList<IDataSourceVisitor> dataSourceVisitors = new ArrayList<IDataSourceVisitor>();
            dataSourceVisitors.add(dataSourceVisitor);
            DataSetModel atomicDataSetModel = new DataSetModel(entityNameSet, metaInfo, null, dataSourceVisitors);
            result = new PersistentDataSet(atomicDataSetModel, this.needVisitPrimitiveData());
            if (multiDataSourceWrap != null) {
                multiDataSourceWrap.put(entityNameSet, dataSourceVisitor, newdataFile);
            } else {
                result.addCloseListener(new DeleteTempFileCloseListener(newdataFile));
            }
        }
        catch (AbstractDataSourceException e) {
            newdataFile.delete();
            CloseUtil.close((Closeable[])new Closeable[]{result});
            throw e;
        }
        return result;
    }
}

