/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.task.DataSetJoinPair;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskTemplate;
import com.kingdee.bos.qing.datasource.join.util.BloomFilterFunnel;
import com.kingdee.bos.qing.datasource.join.util.DataSetWriter;
import com.kingdee.bos.qing.datasource.memorymanage.DataRowSize;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import shaded.com.google.common.hash.BloomFilter;
import shaded.com.google.common.hash.Funnel;

public class HashTask
extends JoinTaskTemplate<List<DataSetJoinPair>> {
    private JoinDataSetModel joinDataSetModel;
    private AbstractAtomicDataSet leftDataSet;
    private AbstractAtomicDataSet rightDataSet;
    private JoinOption joinOption;
    private DataSetWriter notMatchDataSetWriter;
    private boolean collectLeftNotMatch;
    private boolean collectRightNotMatch;
    private DSFieldKey leftField;
    private DataType leftFieldDataType;
    private long rightRowCount;
    private boolean changeLeftToString;
    private DSFieldKey rightField;
    private long leftRowCount;
    private boolean changeRightToString;
    private JoinTaskRuntime runtime;
    private List<DataSetJoinPair> dataSetJoinPairList = new ArrayList<DataSetJoinPair>();

    public HashTask(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption, JoinTaskRuntime runtime) {
        super(runtime, false);
        this.leftDataSet = leftDataSet;
        this.rightDataSet = rightDataSet;
        this.joinOption = joinOption;
        this.joinDataSetModel = joinDataSetModel;
        JoinDataSetModel.JoinType joinType = joinDataSetModel.getJoinType();
        this.collectLeftNotMatch = JoinDataSetModel.JoinType.LeftJoin == joinType || JoinDataSetModel.JoinType.FullJoin == joinType;
        this.collectRightNotMatch = JoinDataSetModel.JoinType.FullJoin == joinType;
        this.leftField = joinDataSetModel.getLeftField();
        this.leftFieldDataType = joinDataSetModel.getLeftFieldDataType();
        this.changeLeftToString = joinDataSetModel.isChangeLeftToString();
        this.leftRowCount = leftDataSet.getAdvisesRowCount();
        this.rightField = joinDataSetModel.getRightField();
        this.changeRightToString = joinDataSetModel.isChangeRightToString();
        this.rightRowCount = rightDataSet.getAdvisesRowCount();
        this.runtime = runtime;
    }

    private void closeDataJoinPair(List<DataSetJoinPair> joinPairs) {
        for (DataSetJoinPair dataSetJoinPair : joinPairs) {
            dataSetJoinPair.close();
        }
    }

    private List<DataSetJoinPair> doHash() throws AbstractDataSourceException, InterruptedException {
        List<AbstractAtomicDataSet> leftAreas = null;
        List<AbstractAtomicDataSet> rightAreas = null;
        try {
            BloomFilterFunnel bloomFilterFunnel = new BloomFilterFunnel(this.leftFieldDataType, this.changeLeftToString || this.changeRightToString);
            BloomFilter bloomFilter = BloomFilter.create((Funnel)bloomFilterFunnel, (long)bloomFilterFunnel.getSuggestSize(Math.min(this.leftRowCount, this.rightRowCount)));
            bloomFilterFunnel.setBloomFilter((BloomFilter<Object>)bloomFilter);
            HashSuggestor hashSuggestor = this.createHashSuggest();
            if (hashSuggestor.getDataSetType() == 1) {
                rightAreas = this.hashPartitionDataSetAndCreateBloomFilter(bloomFilterFunnel, hashSuggestor.getBucketSize(), hashSuggestor.getDataSetType());
                leftAreas = this.hashPartitionDataSetAndCheckBloomFilter(rightAreas, bloomFilterFunnel, hashSuggestor.getBucketSize(), hashSuggestor.getDataSetType());
            } else {
                leftAreas = this.hashPartitionDataSetAndCreateBloomFilter(bloomFilterFunnel, hashSuggestor.getBucketSize(), hashSuggestor.getDataSetType());
                rightAreas = this.hashPartitionDataSetAndCheckBloomFilter(leftAreas, bloomFilterFunnel, hashSuggestor.getBucketSize(), hashSuggestor.getDataSetType());
            }
            for (int index = 0; index < hashSuggestor.getBucketSize(); ++index) {
                AbstractAtomicDataSet subLeftDataSet = leftAreas.get(index);
                AbstractAtomicDataSet subRightDataSet = rightAreas.get(index);
                this.dataSetJoinPairList.add(new DataSetJoinPair(subLeftDataSet, subRightDataSet));
            }
            this.collectNotMatchDataSet();
        }
        catch (AbstractDataSourceException e) {
            this.closeDataJoinPair(this.dataSetJoinPairList);
            this.clear(leftAreas, rightAreas, (Exception)((Object)e));
            throw e;
        }
        catch (InterruptedException e) {
            this.closeDataJoinPair(this.dataSetJoinPairList);
            this.clear(leftAreas, rightAreas, e);
            throw e;
        }
        return this.dataSetJoinPairList;
    }

    private void clear(List<AbstractAtomicDataSet> leftAreas, List<AbstractAtomicDataSet> rightAreas, Exception e) {
        CloseUtil.close(leftAreas);
        CloseUtil.close(rightAreas);
        if (this.notMatchDataSetWriter != null) {
            this.notMatchDataSetWriter.clear(e);
            this.notMatchDataSetWriter = null;
        }
    }

    private void collectNotMatchDataSet() throws AbstractDataSourceException, InterruptedException {
        if (this.notMatchDataSetWriter != null) {
            AbstractAtomicDataSet notMatchRowDataSet = this.notMatchDataSetWriter.createDataSet(false);
            this.dataSetJoinPairList.add(new DataSetJoinPair(notMatchRowDataSet, null));
            this.notMatchDataSetWriter = null;
        }
    }

    private void handlLeftNotMatchRow(Map<String, Object> row) throws AbstractDataSourceException, InterruptedException {
        if (this.collectLeftNotMatch) {
            if (this.notMatchDataSetWriter == null) {
                this.notMatchDataSetWriter = new DataSetWriter(this.joinDataSetModel, true, this.runtime.getTempQingFileCache());
            }
            this.notMatchDataSetWriter.addRow(row, 1);
        }
    }

    private void handleRightNotMatchRow(Map<String, Object> row) throws AbstractDataSourceException, InterruptedException {
        if (this.collectRightNotMatch) {
            if (this.notMatchDataSetWriter == null) {
                this.notMatchDataSetWriter = new DataSetWriter(this.joinDataSetModel, true, this.runtime.getTempQingFileCache());
            }
            this.notMatchDataSetWriter.addRow(row, 1);
        }
    }

    private long estimateSize(AbstractAtomicDataSet dataSet) {
        MetaInfo metaInfo = dataSet.getDataSetModel().getMetaInfo();
        DataRowSize rowSize = new DataRowSize(metaInfo);
        return rowSize.getMinRetainSize() * dataSet.getAdvisesRowCount();
    }

    private List<AbstractAtomicDataSet> hashPartitionDataSetAndCreateBloomFilter(BloomFilterFunnel bloomFilterFunnel, int bucketSize, int dataSetType) throws AbstractDataSourceException, InterruptedException {
        long begin = System.currentTimeMillis();
        AbstractAtomicDataSet dataSet = dataSetType == 0 ? this.leftDataSet : this.rightDataSet;
        DSFieldKey fieldKey = dataSetType == 0 ? this.leftField : this.rightField;
        DataSetWriter[] dataAreaWriters = new DataSetWriter[bucketSize];
        ArrayList<AbstractAtomicDataSet> dataAreas = new ArrayList<AbstractAtomicDataSet>(bucketSize);
        boolean isLeftField = this.joinDataSetModel.getLeftField().equals((Object)fieldKey);
        BloomFilterFunnel.IConverter converter = bloomFilterFunnel.getConverter();
        try {
            while (dataSet.hasNextRow()) {
                this.runtime.checkTaskNormal();
                Map<String, Object> row = dataSet.getCurrentRow();
                Object value = row.get(fieldKey.toFullName());
                value = converter.convert(value);
                if (value != null) {
                    int bucketNumber = 0;
                    bloomFilterFunnel.put(value);
                    bucketNumber = this.getPartitionKey(value, bucketSize);
                    DataSetWriter hashDataSetWriter = dataAreaWriters[bucketNumber];
                    if (hashDataSetWriter == null) {
                        dataAreaWriters[bucketNumber] = hashDataSetWriter = new DataSetWriter(dataSet.getDataSetModel(), false, this.runtime.getTempQingFileCache());
                    }
                    hashDataSetWriter.addRow(row, 500);
                } else if (isLeftField) {
                    this.handlLeftNotMatchRow(row);
                } else {
                    this.handleRightNotMatchRow(row);
                }
                dataSet.nextRow();
            }
            this.polulateDataSet(dataAreas, dataAreaWriters);
        }
        catch (AbstractDataSourceException e) {
            this.clearHashPartitionDataSet(dataAreas, dataAreaWriters, (Exception)((Object)e));
            throw e;
        }
        catch (InterruptedException e) {
            this.clearHashPartitionDataSet(dataAreas, dataAreaWriters, e);
            throw e;
        }
        LogUtil.info((String)("hashPartitionDataSetAndCreateBloomFilter:" + (double)(System.currentTimeMillis() - begin) / 1000.0));
        return dataAreas;
    }

    private void clearHashPartitionDataSet(List<AbstractAtomicDataSet> dataAreas, DataSetWriter[] dataAreaWriters, Exception e) throws DataSourcePersistenceException {
        CloseUtil.close(dataAreas);
        for (DataSetWriter tempDataSetWriter : dataAreaWriters) {
            if (tempDataSetWriter == null) continue;
            tempDataSetWriter.clear(e);
        }
    }

    private List<AbstractAtomicDataSet> hashPartitionDataSetAndCheckBloomFilter(List<AbstractAtomicDataSet> otherAreas, BloomFilterFunnel bloomFilterFunnel, int bucketSize, int dataSetType) throws AbstractDataSourceException, InterruptedException {
        long begin = System.currentTimeMillis();
        AbstractAtomicDataSet dataSet = dataSetType == 0 ? this.rightDataSet : this.leftDataSet;
        DSFieldKey fieldKey = dataSetType == 0 ? this.rightField : this.leftField;
        ArrayList<AbstractAtomicDataSet> dataAreas = new ArrayList<AbstractAtomicDataSet>(bucketSize);
        DataSetWriter[] dataAreaWriters = new DataSetWriter[bucketSize];
        boolean isLeftField = this.joinDataSetModel.getLeftField().equals((Object)fieldKey);
        BloomFilterFunnel.IConverter converter = bloomFilterFunnel.getConverter();
        try {
            while (dataSet.hasNextRow()) {
                this.runtime.checkTaskNormal();
                Map<String, Object> row = dataSet.getCurrentRow();
                Object value = row.get(fieldKey.toFullName());
                value = converter.convert(value);
                if (value != null && bloomFilterFunnel.mightContain(value)) {
                    int bucketNumber = this.getPartitionKey(value, bucketSize);
                    if (otherAreas.get(bucketNumber) != null) {
                        DataSetWriter hashDataSetWriter = dataAreaWriters[bucketNumber];
                        if (hashDataSetWriter == null) {
                            dataAreaWriters[bucketNumber] = hashDataSetWriter = new DataSetWriter(dataSet.getDataSetModel(), false, this.runtime.getTempQingFileCache());
                        }
                        hashDataSetWriter.addRow(row, 100);
                    } else if (isLeftField) {
                        this.handlLeftNotMatchRow(row);
                    } else {
                        this.handleRightNotMatchRow(row);
                    }
                } else if (isLeftField) {
                    this.handlLeftNotMatchRow(row);
                } else {
                    this.handleRightNotMatchRow(row);
                }
                dataSet.nextRow();
            }
            this.polulateDataSet(dataAreas, dataAreaWriters);
        }
        catch (AbstractDataSourceException e) {
            this.clearHashPartitionDataSet(dataAreas, dataAreaWriters, (Exception)((Object)e));
            throw e;
        }
        catch (InterruptedException e) {
            this.clearHashPartitionDataSet(dataAreas, dataAreaWriters, e);
            throw e;
        }
        LogUtil.info((String)("hashPartitionDataSetAndCheckBloomFilter:" + (double)(System.currentTimeMillis() - begin) / 1000.0));
        return dataAreas;
    }

    private void polulateDataSet(List<AbstractAtomicDataSet> dataAreas, DataSetWriter[] dataAreaWriters) throws InterruptedException, AbstractDataSourceException {
        for (int index = 0; index < dataAreaWriters.length; ++index) {
            DataSetWriter tempDataSetWriter = dataAreaWriters[index];
            if (tempDataSetWriter == null) {
                dataAreas.add(null);
                continue;
            }
            dataAreas.add(tempDataSetWriter.createDataSet(false));
        }
    }

    private int getPartitionKey(Object value, int bucketSize) {
        int bucketNumber = value.hashCode() % bucketSize;
        return bucketNumber < 0 ? bucketNumber + bucketSize : bucketNumber;
    }

    private HashSuggestor createHashSuggest() {
        if (this.leftRowCount > 0L && this.rightRowCount > 0L) {
            long righEstimateSize;
            long leftEstimateSize = this.estimateSize(this.leftDataSet);
            if (leftEstimateSize < (righEstimateSize = this.estimateSize(this.rightDataSet))) {
                long suggestSize = righEstimateSize / 0x3200000L;
                long bucketSize = Math.min(suggestSize == 0L ? 3L : suggestSize, 10L);
                return new HashSuggestor((int)bucketSize, 0);
            }
            long suggestSize = leftEstimateSize / 0x3200000L;
            long bucketSize = Math.min(suggestSize == 0L ? 3L : suggestSize, 10L);
            return new HashSuggestor((int)bucketSize, 1);
        }
        return new HashSuggestor(this.joinOption.getBucketSize(), 0);
    }

    @Override
    protected List<DataSetJoinPair> doCompute() {
        try {
            return this.doHash();
        }
        catch (Exception e) {
            this.completeExceptionally(e);
            return Collections.emptyList();
        }
    }

    private static class HashSuggestor {
        public static final int LEFT = 0;
        public static final int RIGHT = 1;
        private int bucketSize;
        private int dataSetTypeForCreate;

        public HashSuggestor(int bucketSize, int dataSetTypeForCreate) {
            this.bucketSize = bucketSize;
            this.dataSetTypeForCreate = dataSetTypeForCreate;
        }

        public int getBucketSize() {
            return this.bucketSize;
        }

        public int getDataSetType() {
            return this.dataSetTypeForCreate;
        }
    }
}

