/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.util;

import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.util.ConvertUtil;
import java.util.Comparator;
import java.util.Map;

public class RowValueComparator
implements Comparator<Map<String, Object>> {
    private DSFieldKey comparisonField;
    private boolean compareByString;

    public RowValueComparator(DSFieldKey comparisonField, boolean compareByString) {
        this.comparisonField = comparisonField;
        this.compareByString = compareByString;
    }

    public DSFieldKey getComparisonField() {
        return this.comparisonField;
    }

    @Override
    public int compare(Map<String, Object> leftMap, Map<String, Object> rightMap) {
        Comparable leftValue = (Comparable)leftMap.get(this.comparisonField.toFullName());
        Comparable rightValue = (Comparable)rightMap.get(this.comparisonField.toFullName());
        if (leftValue == null && rightValue == null) {
            return 0;
        }
        if (leftValue == null) {
            return 1;
        }
        if (rightValue == null) {
            return -1;
        }
        if (this.compareByString) {
            String leftValueString = ConvertUtil.convertToString((Object)leftValue);
            String rightValueString = ConvertUtil.convertToString((Object)rightValue);
            return leftValueString.compareTo(rightValueString);
        }
        return leftValue.compareTo(rightValue);
    }
}

