/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.worknodes;

import com.kingdee.bos.qing.common.memory.MemRuntimeMonitor;
import com.kingdee.bos.qing.common.memory.MemScanListener;
import com.kingdee.bos.qing.datasource.exception.JoinRejectedExecutionException;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskMonitorRecorder;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskPromise;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRequest;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.taskadvise.MemoryAdvisor;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskAdvisable;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskAdvise;
import com.kingdee.bos.qing.datasource.join.taskadvise.WorkNodeStateAdvisor;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.join.worknodes.JoinWorkNodeGroup;
import com.kingdee.bos.qing.datasource.join.worknodes.TaskReleaseListener;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class JoinTaskManager {
    private static JoinTaskManager instance = new JoinTaskManager();
    private List<TaskAdvisable> taskAdvisables = new ArrayList<TaskAdvisable>();
    private ScheduledExecutorService schedulor = Executors.newSingleThreadScheduledExecutor();
    private LinkedList<JoinTaskPromise> blockedTasks = new LinkedList();
    private static final int DELAY_SUBMIT_TIME = 5;
    private JoinWorkNodeGroup workNodeGroup = new JoinWorkNodeGroup();
    private JoinTaskMonitorRecorder taskMonitorDataRecorder = new JoinTaskMonitorRecorder();

    private JoinTaskManager() {
        this.taskAdvisables.add(new MemoryAdvisor());
        this.taskAdvisables.add(new WorkNodeStateAdvisor());
        this.workNodeGroup.regTaskReleaseListener(new TaskReleaseListenerImpl());
        this.workNodeGroup.regTaskReleaseListener(this.taskMonitorDataRecorder);
        MemRuntimeMonitor.getInstance().unSafeAddScanListener((MemScanListener)this.taskMonitorDataRecorder);
    }

    public static JoinTaskManager getInstance() {
        return instance;
    }

    public JoinTaskPromise addJoinTask(JoinTaskRequest taskRequest) {
        this.taskMonitorDataRecorder.incrementTotalSubmitCount();
        JoinTaskPromise joinTaskPromise = new JoinTaskPromise(taskRequest);
        this.processByAdvise(joinTaskPromise);
        return joinTaskPromise;
    }

    public JoinTaskMonitorRecorder getTaskMonitorDataRecorder() {
        return this.taskMonitorDataRecorder;
    }

    private synchronized void processByAdvise(JoinTaskPromise taskPromise) {
        JoinTaskRequest taskRequest = taskPromise.getTaskRequest();
        TaskAdvise advise = this.selectAdvise(taskRequest);
        switch (advise) {
            case BLOCK: {
                this.doBlock(taskPromise);
                break;
            }
            case DELAY: {
                this.doDelay(taskPromise);
                break;
            }
            case SUBMIT: {
                this.doSubmit(taskPromise);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBlock(JoinTaskPromise taskPromise) {
        LogUtil.info((String)(JoinUtil.joinLogPrefix() + "join task is blocked.taskId:" + taskPromise.getTaskRequest().getTaskId()));
        LinkedList<JoinTaskPromise> linkedList = this.blockedTasks;
        synchronized (linkedList) {
            this.blockedTasks.add(taskPromise);
            this.taskMonitorDataRecorder.incrementBlockedTask();
        }
    }

    private void doDelay(JoinTaskPromise taskPromise) {
        JoinTaskRequest taskConfig = taskPromise.getTaskRequest();
        taskConfig.increaseDelay();
        String entityNames = taskConfig.getDataSetModel().getEntityNames().toString();
        LogUtil.info((String)(JoinUtil.joinLogPrefix() + "join task is delayed,entityNames:" + entityNames + " ,delayCount=" + taskConfig.getDelayCount()));
        this.taskMonitorDataRecorder.incrementDelayedTask();
        this.schedulor.schedule(new DelayTaskRunner(taskPromise), 5L, TimeUnit.SECONDS);
    }

    private void doSubmit(JoinTaskPromise taskPromise) {
        try {
            JoinTaskRuntime runtime = this.workNodeGroup.submitTask(taskPromise.getTaskRequest());
            taskPromise.setRuntime(runtime);
        }
        catch (JoinRejectedExecutionException e) {
            this.doBlock(taskPromise);
        }
    }

    private TaskAdvise selectAdvise(JoinTaskRequest taskRequest) {
        TaskAdvisable taskAdvisor;
        TaskAdvise advise = TaskAdvise.SUBMIT;
        Iterator<TaskAdvisable> iterator = this.taskAdvisables.iterator();
        while (iterator.hasNext() && ((advise = (taskAdvisor = iterator.next()).getAdvise(taskRequest)) == TaskAdvise.SUBMIT || advise != TaskAdvise.BLOCK && advise != TaskAdvise.DELAY)) {
        }
        return advise;
    }

    public boolean isWorkNodesBusy() {
        return this.workNodeGroup.isFullLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JoinTaskPromise takeOneBlockedTask() {
        LinkedList<JoinTaskPromise> linkedList = this.blockedTasks;
        synchronized (linkedList) {
            while (this.blockedTasks.size() > 0) {
                JoinTaskPromise taskPromise = this.blockedTasks.removeFirst();
                if (!taskPromise.isTimeoutBeforeSubmit()) {
                    return taskPromise;
                }
                this.taskMonitorDataRecorder.timeout(taskPromise.getTaskRequest().getTaskId(), null);
            }
            return null;
        }
    }

    public int getTotalRunningTask() {
        return this.workNodeGroup.getCurrentTotalTask();
    }

    private class BlockTaskInvoker
    implements Runnable {
        private BlockTaskInvoker() {
        }

        @Override
        public void run() {
            JoinTaskPromise taskPromise = JoinTaskManager.this.takeOneBlockedTask();
            if (null != taskPromise) {
                JoinTaskManager.this.taskMonitorDataRecorder.decrementBlockedTask();
                LogUtil.info((String)(JoinUtil.joinLogPrefix() + "invoke block task, taskID:" + taskPromise.getTaskRequest().getTaskId()));
                JoinTaskManager.this.processByAdvise(taskPromise);
            }
        }
    }

    private class TaskReleaseListenerImpl
    implements TaskReleaseListener {
        private TaskReleaseListenerImpl() {
        }

        @Override
        public void taskReleased(int state) {
            JoinTaskManager.this.schedulor.schedule(new BlockTaskInvoker(), 0L, TimeUnit.MILLISECONDS);
        }
    }

    private class DelayTaskRunner
    implements Runnable {
        private JoinTaskPromise taskPromise;

        public DelayTaskRunner(JoinTaskPromise taskPromise) {
            this.taskPromise = taskPromise;
        }

        @Override
        public void run() {
            JoinTaskManager.this.taskMonitorDataRecorder.decrementDelayedTask();
            if (this.taskPromise.isTimeoutBeforeSubmit()) {
                JoinTaskManager.this.taskMonitorDataRecorder.timeout(this.taskPromise.getTaskRequest().getTaskId(), null);
                return;
            }
            JoinTaskManager.this.processByAdvise(this.taskPromise);
        }
    }
}

