/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.worknodes;

import com.kingdee.bos.qing.common.memory.MemRuntimeMonitor;
import com.kingdee.bos.qing.datasource.exception.JoinRejectedExecutionException;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRequest;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.join.worknodes.GlobalTaskCounter;
import com.kingdee.bos.qing.datasource.join.worknodes.JoinWorkNode;
import com.kingdee.bos.qing.datasource.join.worknodes.MinLoadedWorkNodeFilter;
import com.kingdee.bos.qing.datasource.join.worknodes.NoLargeTaskWorkNodeFilter;
import com.kingdee.bos.qing.datasource.join.worknodes.NoLongTimeTaskWorkNodeFilter;
import com.kingdee.bos.qing.datasource.join.worknodes.NodeStateChangLisener;
import com.kingdee.bos.qing.datasource.join.worknodes.NodeStateChangeEvent;
import com.kingdee.bos.qing.datasource.join.worknodes.NodeStateType;
import com.kingdee.bos.qing.datasource.join.worknodes.NotFullLoadNodeFilter;
import com.kingdee.bos.qing.datasource.join.worknodes.TaskReleaseListener;
import com.kingdee.bos.qing.datasource.join.worknodes.WorkNodeFilter;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class JoinWorkNodeGroup {
    private List<JoinWorkNode> workNodes = new ArrayList<JoinWorkNode>();
    private static ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private static final int EACH_NODE_POOLSIZE = 4;
    private GlobalTaskCounter globalTaskCounter = new GlobalTaskCounter();
    private List<WorkNodeFilter> nodeFilterChain = new ArrayList<WorkNodeFilter>();

    protected JoinWorkNodeGroup() {
        this.initWorkNodes();
        this.initFilterChain();
        executorService.scheduleAtFixedRate(new LongTimeRunTaskChecker(), 10L, 10L, TimeUnit.SECONDS);
    }

    private void initFilterChain() {
        this.nodeFilterChain.add(new NotFullLoadNodeFilter());
        this.nodeFilterChain.add(new NoLargeTaskWorkNodeFilter());
        this.nodeFilterChain.add(new NoLongTimeTaskWorkNodeFilter());
        this.nodeFilterChain.add(new MinLoadedWorkNodeFilter());
    }

    private void initWorkNodes() {
        int workNodeSize = this.calculateWorkNodeSize();
        int maxLimitCount = 0;
        for (int i = 0; i < workNodeSize; ++i) {
            JoinWorkNode workNode = new JoinWorkNode(4, this.globalTaskCounter);
            this.workNodes.add(workNode);
            maxLimitCount += workNode.getMaxLimit();
        }
        this.globalTaskCounter.initCount(maxLimitCount);
        this.registerNodeStateListener(new NodeStateChangeImpl());
    }

    void registerNodeStateListener(NodeStateChangLisener stateChangLisener) {
        for (JoinWorkNode workNode : this.workNodes) {
            workNode.setNodeStateListener(stateChangLisener);
        }
    }

    public void regTaskReleaseListener(TaskReleaseListener releaseListener) {
        this.globalTaskCounter.addTaskReleaseListener(releaseListener);
    }

    private int calculateWorkNodeSize() {
        int configSize = QingJoinConfig.getInstance().getWorkNodeSize();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        LogUtil.info((String)(JoinUtil.joinLogPrefix() + "current eviroment cpu processors:" + availableProcessors));
        if (configSize <= 0 || configSize > availableProcessors) {
            return availableProcessors + 1;
        }
        return configSize;
    }

    public boolean isFullLoad() {
        return this.globalTaskCounter.reachMaxLimit();
    }

    synchronized JoinTaskRuntime submitTask(JoinTaskRequest joinTaskRequest) throws JoinRejectedExecutionException {
        JoinWorkNode workNode = this.selectJoinWorkNode();
        if (null == workNode) {
            throw new JoinRejectedExecutionException("system is busy now");
        }
        if (!this.globalTaskCounter.aquire()) {
            throw new JoinRejectedExecutionException("system is busy now");
        }
        try {
            return workNode.submitJoin(joinTaskRequest);
        }
        catch (Exception e) {
            this.globalTaskCounter.release(-1);
            throw new JoinRejectedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private JoinWorkNode selectJoinWorkNode() {
        WorkNodeFilter nodeFilter;
        List<JoinWorkNode> filteredNodes = this.workNodes;
        Iterator<WorkNodeFilter> iterator = this.nodeFilterChain.iterator();
        while (iterator.hasNext() && !(filteredNodes = (nodeFilter = iterator.next()).filter(filteredNodes)).isEmpty()) {
        }
        return filteredNodes.isEmpty() ? null : filteredNodes.get(0);
    }

    private synchronized void tryStealWaitingTaskFromOtherNodes(String workNodeID) {
        JoinTaskRuntime waitingTask = null;
        try {
            waitingTask = this.selectWaitingTaskFromOtherNode(workNodeID);
        }
        catch (InterruptedException e) {
            LogUtil.error((String)"", (Throwable)e);
            return;
        }
        if (null != waitingTask) {
            JoinWorkNode idlWorkNode = this.getWorkNode(workNodeID);
            try {
                if (idlWorkNode != null) {
                    waitingTask.setPreStolenTime(System.currentTimeMillis());
                    waitingTask.increaseStolenCount();
                    idlWorkNode.submitJoin(waitingTask);
                }
            }
            catch (Exception e) {
                LogUtil.error((String)("steal join work error:" + waitingTask.getTaskId() + "on work node Id:" + workNodeID));
                waitingTask.setException(e);
                waitingTask.end(null);
            }
        }
    }

    private JoinWorkNode getWorkNode(String workNodeID) {
        for (JoinWorkNode workNode : this.workNodes) {
            if (!workNode.getMyWorkNodeId().equals(workNodeID)) continue;
            return workNode;
        }
        return null;
    }

    private JoinTaskRuntime selectWaitingTaskFromOtherNode(String excluedeWorkNodeID) throws InterruptedException {
        for (JoinWorkNode workNode : this.workNodes) {
            JoinTaskRuntime waitingTask;
            if (workNode.getMyWorkNodeId().equals(excluedeWorkNodeID) || null == (waitingTask = workNode.tryRemoveWaitingTask())) continue;
            return waitingTask;
        }
        return null;
    }

    public int getCurrentTotalTask() {
        return this.globalTaskCounter.getCurrentRunningCount();
    }

    private class NodeStateChangeEventRunner
    implements Runnable {
        private NodeStateChangeEvent nodeStateChangeEvent;

        public NodeStateChangeEventRunner(NodeStateChangeEvent nodeStateChangeEvent) {
            this.nodeStateChangeEvent = nodeStateChangeEvent;
        }

        @Override
        public void run() {
            NodeStateType target;
            NodeStateType source = this.nodeStateChangeEvent.getSourceType();
            if (source == (target = this.nodeStateChangeEvent.getTargetType())) {
                return;
            }
            String workNodeID = this.nodeStateChangeEvent.getJoinWorkNodeId();
            if (target == NodeStateType.IDLE) {
                MemRuntimeMonitor.getInstance().unRegister(workNodeID);
                JoinWorkNodeGroup.this.tryStealWaitingTaskFromOtherNodes(workNodeID);
                return;
            }
            if (source == NodeStateType.IDLE) {
                JoinWorkNode idlWorkNode = JoinWorkNodeGroup.this.getWorkNode(workNodeID);
                if (idlWorkNode != null) {
                    MemRuntimeMonitor.getInstance().registerIfAbsent(idlWorkNode.newMemObserver());
                }
                return;
            }
        }
    }

    private class NodeStateChangeImpl
    implements NodeStateChangLisener {
        private NodeStateChangeImpl() {
        }

        @Override
        public void onNodeStateChanged(NodeStateChangeEvent nodeStateChangeEvent) {
            executorService.schedule(new NodeStateChangeEventRunner(nodeStateChangeEvent), 0L, TimeUnit.MILLISECONDS);
        }
    }

    private class LongTimeRunTaskChecker
    implements Runnable {
        private LongTimeRunTaskChecker() {
        }

        @Override
        public void run() {
            for (JoinWorkNode workNode : JoinWorkNodeGroup.this.workNodes) {
                workNode.checkLongTimeRunningTask();
            }
        }
    }
}

