/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.csv;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceAccessException;
import com.kingdee.bos.qing.datasource.io.IMutiFileSupport;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractDataIterator;
import com.kingdee.bos.qing.datasource.spec.csv.CsvReader;
import com.kingdee.bos.qing.datasource.util.FilterUtil;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CsvDataIterator
extends AbstractDataIterator {
    private IQingFileVisitor _dataFile;
    private CsvReader _reader;
    private int readerIndex = 0;
    private boolean isMutiFileSupport = false;
    private Map<String, Object> values;
    private Set<IPushdownFilter> _dsFilters;

    public CsvDataIterator(MetaInfo metaInfo, IQingFileVisitor dataFile) {
        super(metaInfo);
        this._dataFile = dataFile;
        if (dataFile instanceof IMutiFileSupport) {
            this.isMutiFileSupport = true;
            IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
            mutiFileSupport.setCurrentFile(0);
        }
    }

    @Override
    protected void initImpl(Set<DSFieldKey> fields, Set<IPushdownFilter> dsFilters) throws AbstractDataSourceException {
        this._dsFilters = dsFilters;
        QingInputStream in = null;
        try {
            in = this._dataFile.getInputStream();
            this._reader = new CsvReader(new InputStreamReader((InputStream)in, "utf-8"));
        }
        catch (IOException e) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            AbstractDataSourceException.accessExcetpion((Throwable)e);
        }
        try {
            this._reader.readHeaders();
        }
        catch (IOException e) {
            AbstractDataSourceException.accessExcetpion((Throwable)e);
        }
    }

    @Override
    protected boolean hasNextRowImpl() throws AbstractDataSourceException {
        boolean success;
        block8: {
            if (!this._hasData) {
                return this._hasData;
            }
            success = false;
            try {
                block7: {
                    Map<String, Object> rowValues;
                    boolean isFilterAccept;
                    do {
                        success = this._reader.readRecord();
                        while (this.isMutiFileSupport && !success) {
                            this._reader.close();
                            this._reader = null;
                            IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
                            ++this.readerIndex;
                            if (this.readerIndex >= mutiFileSupport.getFileCount()) break;
                            mutiFileSupport.setCurrentFile(this.readerIndex);
                            QingInputStream in = null;
                            try {
                                in = this._dataFile.getInputStream();
                                this._reader = new CsvReader(new InputStreamReader((InputStream)in, "utf-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                CloseUtil.close((Closeable[])new Closeable[]{in});
                                throw new DataSourceAccessException((Throwable)e);
                            }
                            this._reader.readHeaders();
                            success = this._reader.readRecord();
                        }
                        if (!success) break block7;
                    } while (!(isFilterAccept = FilterUtil.isMatchFilter(this._dsFilters, rowValues = this.parseValue(this._reader.getValues()))));
                    this.values = rowValues;
                    break block8;
                }
                this.values = new HashMap<String, Object>();
            }
            catch (IOException e) {
                AbstractDataSourceException.accessExcetpion((Throwable)e);
            }
        }
        return success;
    }

    private Map<String, Object> parseValue(String[] values) {
        HashMap<String, Object> oneRow = new HashMap<String, Object>();
        Iterator iterator = this._interestingFieldIndexs.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            String fieldFullName = (String)this._allFullFieldNames.get(index);
            DataType dataType = this._metaInfo.getFieldDataType(index);
            String value = values[index];
            if (dataType == DataType.NUMBER || dataType == DataType.INT) {
                if (value == null || "".equals(value)) {
                    oneRow.put(fieldFullName, null);
                    continue;
                }
                if (this._interestingRowIDFieldIndexs.contains(index)) {
                    oneRow.put(fieldFullName, Long.valueOf(value));
                    continue;
                }
                oneRow.put(fieldFullName, new BigDecimal(value));
                continue;
            }
            if (dataType == DataType.DATE || dataType == DataType.DATETIME) {
                oneRow.put(fieldFullName, this.parseDateFieldValue(value));
                continue;
            }
            if (dataType == DataType.BOOLEAN) {
                oneRow.put(fieldFullName, Boolean.valueOf(value));
                continue;
            }
            oneRow.put(fieldFullName, value.length() == 0 ? null : value);
        }
        return oneRow;
    }

    @Override
    protected Map<String, Object> nextRowImpl() {
        return this.values;
    }

    private Calendar parseDateFieldValue(String value) {
        String dateSeparator;
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        String[] twoPart = value.split(" ", 2);
        String date = twoPart[0];
        if (date.indexOf("-") > 0) {
            dateSeparator = "-";
        } else if (date.indexOf("/") > 0) {
            dateSeparator = "/";
        } else {
            throw new RuntimeException("Reader and Writer not matched.");
        }
        String[] dateThreePart = date.split(dateSeparator, 3);
        int year = Integer.parseInt(dateThreePart[0]);
        int month = Integer.parseInt(dateThreePart[1]) - 1;
        int day = Integer.parseInt(dateThreePart[2]);
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (twoPart.length > 1) {
            String time = twoPart[1];
            time = time.trim();
            String[] timeThreePart = time.split(":");
            hour = Integer.parseInt(timeThreePart[0]);
            minute = Integer.parseInt(timeThreePart[1]);
            second = Integer.parseInt(timeThreePart[2]);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month, day, hour, minute, second);
        return calendar;
    }

    @Override
    protected void closeImpl() {
        CloseUtil.close((Closeable[])new Closeable[]{this._reader});
        this._reader = null;
    }

    public void setAllFieldsNeeded(boolean isAllFieldsNeeded) {
    }
}

