/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.csv;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.csv.CsvWriter;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class QingCsvWriterWraper {
    private IQingFileWriter qingFileWriter;
    private CsvWriter csvWriter;

    public QingCsvWriterWraper(IQingFileWriter qingFileWriter) {
        this.qingFileWriter = qingFileWriter;
    }

    public void start() throws DataSourcePersistenceException {
        try {
            this.csvWriter = new CsvWriter((OutputStream)this.qingFileWriter.getOutputStream(), ',', Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            AbstractDataSourceException.persistenceExcetpion((Throwable)e);
        }
    }

    public void writeRecord(String[] values) throws DataSourcePersistenceException {
        try {
            this.csvWriter.writeRecord(values);
        }
        catch (IOException e) {
            AbstractDataSourceException.persistenceExcetpion((Throwable)e);
        }
    }

    public void flush() throws DataSourcePersistenceException {
        try {
            this.csvWriter.flush();
        }
        catch (IOException e) {
            AbstractDataSourceException.persistenceExcetpion((Throwable)e);
        }
    }

    public void close(Exception e) {
        this.qingFileWriter.close(e);
    }
}

