/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.qs;

import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.IDataSourceCloseListener;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.IQsDataSourceClosable;
import com.kingdee.bos.qing.datasource.spec.qs.QingStorageWriterWraper;
import com.kingdee.bos.qing.filesystem.manager.ClientAndTmpFileRelationManager;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.util.LogUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import q.storage.columnar.api.impl.QingStorageRecord;
import q.storage.columnar.util.QingStorageUtils;
import shaded.org.apache.parquet.io.api.Binary;
import shaded.org.apache.parquet.schema.GroupType;
import shaded.org.apache.parquet.schema.MessageType;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;

public class QSDataSourceWriter
implements IDataSourceWriter,
IQsDataSourceClosable {
    private static Map<DataType, RecordSetter> RECORDSETTERMAP = new HashMap<DataType, RecordSetter>();
    public static final int BIGDECIMAL_LENGTH = 16;
    public static final String QS = ".QS";
    public static final String EXTRAMETA_DATA_KEY = ".metadata.";
    private QingStorageWriterWraper _recordWriter;
    private boolean _hasData;
    private MetaInfo _metaInfo;
    private IQingFile _dataFile;
    private MessageType _recordSchema;
    private List<DataType> _tempFieldTypesForWrite;
    private int _tempFieldTypesForWriteSize;
    private List<IDataSourceCloseListener> _closeListeners = new ArrayList<IDataSourceCloseListener>();
    private boolean finishedWriteData = false;

    @Override
    public void addBeforeCloseListener(IDataSourceCloseListener listener) {
        this._closeListeners.add(listener);
    }

    public QSDataSourceWriter(IQingFile dataFile) {
        this._dataFile = dataFile;
    }

    @Override
    public void start(MetaInfo metaInfo) {
        this._metaInfo = metaInfo;
        this._tempFieldTypesForWrite = metaInfo.getFieldDataTypes();
        this._tempFieldTypesForWriteSize = this._tempFieldTypesForWrite.size();
    }

    private MessageType createMessageType() {
        if (this._metaInfo == null) {
            return null;
        }
        PrimitiveType[] columns = new PrimitiveType[this._tempFieldTypesForWriteSize];
        for (int index = 0; index < this._tempFieldTypesForWriteSize; ++index) {
            DataType dataType = this._tempFieldTypesForWrite.get(index);
            String fieldId = this.getFieldID(index);
            columns[index] = DataType.DATE == dataType || DataType.DATETIME == dataType ? new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, fieldId) : (DataType.NUMBER == dataType ? new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 16, fieldId) : (DataType.INT == dataType ? new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, fieldId) : new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, fieldId)));
        }
        return new MessageType("envelope", (Type[])columns);
    }

    private String getFieldID(int index) {
        return index + "";
    }

    private void start() throws DataSourcePersistenceException {
        if (this._recordWriter != null) {
            return;
        }
        if (this._metaInfo == null) {
            throw new DataSourcePersistenceException("no metainfo");
        }
        this._recordSchema = this.createMessageType();
        this._recordWriter = new QingStorageWriterWraper(this._dataFile, this._recordSchema, this._metaInfo);
        ClientAndTmpFileRelationManager.getInstance().bindOnStartWrite(this._dataFile);
    }

    @Override
    public void writeData(Object[] row) throws DataSourcePersistenceException, InterruptedException {
        if (this._recordWriter == null) {
            this.start();
        }
        this._hasData = true;
        QingStorageRecord record = this.createQingStorageRecord(row);
        try {
            this._recordWriter.write(record);
        }
        catch (Exception e) {
            throw new DataSourcePersistenceException((Throwable)e);
        }
    }

    protected QingStorageRecord createQingStorageRecord(Object[] row) throws DataSourcePersistenceException {
        QingStorageRecord record = new QingStorageRecord((GroupType)this._recordSchema);
        for (int index = 0; index < this._tempFieldTypesForWriteSize; ++index) {
            Object oValue = row[index];
            if (oValue == null) continue;
            DataType dataType = this._tempFieldTypesForWrite.get(index);
            RecordSetter recordSetter = RECORDSETTERMAP.get(dataType);
            recordSetter.addRecord(record, index, oValue);
        }
        return record;
    }

    @Override
    public void finishWriteData() throws DataSourcePersistenceException {
        if (this.finishedWriteData) {
            return;
        }
        this.finishedWriteData = true;
        DataSourcePersistenceException dataSourcePersistenceException = null;
        if (!this._hasData) {
            try {
                this.start();
            }
            catch (DataSourcePersistenceException e) {
                dataSourcePersistenceException = e;
            }
        }
        if (this._recordWriter != null) {
            this.notifyCloseBefore();
            this._recordWriter.finishWriteData();
        }
        if (dataSourcePersistenceException != null) {
            throw dataSourcePersistenceException;
        }
    }

    @Override
    public void close(Exception exception) {
        if (this._recordWriter != null) {
            this.notifyCloseBefore();
            this._recordWriter.close(exception);
            this._recordWriter = null;
            ClientAndTmpFileRelationManager.getInstance().fileWriteFinish(this._dataFile);
        }
    }

    private void notifyCloseBefore() {
        try {
            for (IDataSourceCloseListener closeListener : this._closeListeners) {
                closeListener.doCloseBefore(this._recordWriter);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"listnener handle error before close", (Throwable)e);
        }
        this._closeListeners.clear();
    }

    static {
        DateRecordSetter dateRecordSetter = new DateRecordSetter();
        RECORDSETTERMAP.put(DataType.DATE, dateRecordSetter);
        RECORDSETTERMAP.put(DataType.DATETIME, dateRecordSetter);
        IntRecordSetter intRecordSetter = new IntRecordSetter();
        RECORDSETTERMAP.put(DataType.INT, intRecordSetter);
        NumberRecordSetter numberRecordSetter = new NumberRecordSetter();
        RECORDSETTERMAP.put(DataType.NUMBER, numberRecordSetter);
        StringRecordSetter stringRecordSetter = new StringRecordSetter();
        RECORDSETTERMAP.put(DataType.STRING, stringRecordSetter);
        RECORDSETTERMAP.put(DataType.BOOLEAN, stringRecordSetter);
    }

    static class StringRecordSetter
    implements RecordSetter {
        StringRecordSetter() {
        }

        @Override
        public void addRecord(QingStorageRecord record, int index, Object oValue) throws DataSourcePersistenceException {
            String value = oValue.toString();
            if (value.length() > 0) {
                record.add(index, value);
            }
        }
    }

    static class NumberRecordSetter
    implements RecordSetter {
        NumberRecordSetter() {
        }

        @Override
        public void addRecord(QingStorageRecord record, int index, Object oValue) throws DataSourcePersistenceException {
            BigDecimal v = null;
            if (oValue instanceof BigDecimal) {
                v = (BigDecimal)oValue;
            } else if (oValue instanceof Number) {
                v = new BigDecimal(oValue.toString());
            } else {
                throw new DataSourcePersistenceException("Expected " + oValue.toString() + " to be a Number,but a " + oValue.getClass().getName());
            }
            byte[] encode = null;
            try {
                encode = QingStorageUtils.encodeBigDecimal((BigDecimal)v, (int)16);
            }
            catch (Exception e) {
                throw new DataSourcePersistenceException("can not encode bigDecimal to byte[]:" + oValue, (Throwable)e);
            }
            record.add(index, Binary.fromConstantByteArray((byte[])encode));
        }
    }

    static class IntRecordSetter
    implements RecordSetter {
        IntRecordSetter() {
        }

        @Override
        public void addRecord(QingStorageRecord record, int index, Object oValue) throws DataSourcePersistenceException {
            Long v = null;
            try {
                if (oValue instanceof Long) {
                    v = (Long)oValue;
                } else if (oValue instanceof Short) {
                    v = ((Short)oValue).longValue();
                }
                if (oValue instanceof Integer) {
                    v = ((Integer)oValue).longValue();
                }
                if (oValue instanceof Byte) {
                    v = ((Byte)oValue).longValue();
                }
                if (oValue instanceof BigDecimal) {
                    v = ((BigDecimal)oValue).longValue();
                }
            }
            catch (Exception e) {
                throw new DataSourcePersistenceException("can not encode bigDecimal to byte[]:" + oValue, (Throwable)e);
            }
            if (v == null) {
                throw new DataSourcePersistenceException("Expected " + oValue.toString() + " to be a Number, but a " + oValue.getClass().getName());
            }
            record.add(index, v.longValue());
        }
    }

    static class DateRecordSetter
    implements RecordSetter {
        DateRecordSetter() {
        }

        @Override
        public void addRecord(QingStorageRecord record, int index, Object oValue) throws DataSourcePersistenceException {
            if (oValue instanceof Long) {
                record.add(index, ((Long)oValue).longValue());
            } else if (oValue instanceof Date) {
                long value = ((Date)oValue).getTime();
                record.add(index, value);
            } else if (oValue instanceof Calendar) {
                long value = ((Calendar)oValue).getTimeInMillis();
                record.add(index, value);
            } else {
                throw new DataSourcePersistenceException("Expected " + oValue.toString() + " to be a Date,but a " + oValue.getClass().getName() + " at column index:" + index);
            }
        }
    }

    static interface RecordSetter {
        public void addRecord(QingStorageRecord var1, int var2, Object var3) throws DataSourcePersistenceException;
    }
}

