/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.qs;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.meta.MetaInfoDecodeUtil;
import com.kingdee.bos.qing.datasource.spec.qs.QSOutputstream;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import org.xerial.snappy.OSInfo;
import q.datasource.io.AbstractOutputStream;
import q.storage.columnar.CodecFactory;
import q.storage.columnar.QingStorageFileWriter;
import q.storage.columnar.QingStorageRecordWriter;
import q.storage.columnar.a.c;
import q.storage.columnar.api.d;
import q.storage.columnar.api.impl.QingStorageRecord;
import q.storage.columnar.api.impl.QingStorageWriteSupport;
import q.storage.columnar.codec.GzipCodec;
import q.storage.columnar.codec.SnappyCodec;
import q.storage.columnar.metadata.CompressionCodecName;
import shaded.org.apache.parquet.column.ParquetProperties;
import shaded.org.apache.parquet.schema.MessageType;

public class QingStorageWriterWraper {
    private static boolean suppourtSnappy = true;
    private static final int DEFAULT_BLOCK_SIZE = 0xA00000;
    private static final int DEFAULT_PAGE_SIZE = 0x100000;
    private static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    private static final boolean DEFAULT_IS_VALIDATING_ENABLED = false;
    private static final ParquetProperties.WriterVersion DEFAULT_WRITER_VERSION = ParquetProperties.WriterVersion.PARQUET_2_0;
    private QingStorageRecordWriter _recordWriter;
    private IQingFileWriter _qingFileWriter;
    private HashMap<String, String> extraMetaData = new HashMap();
    private boolean closed = false;

    public QingStorageWriterWraper(IQingFile dataFile, MessageType messageType, MetaInfo metaInfo) throws DataSourcePersistenceException {
        this._qingFileWriter = dataFile.createWriter();
        QingOutputStream outputStream = null;
        QingStorageFileWriter fileWriter = null;
        try {
            outputStream = this._qingFileWriter.getOutputStream();
            fileWriter = new QingStorageFileWriter(messageType, (AbstractOutputStream)new QSOutputstream(outputStream), 0xA00000L);
            fileWriter.start();
        }
        catch (IOException e) {
            CloseUtil.close((Closeable[])new Closeable[]{outputStream});
            AbstractDataSourceException.persistenceExcetpion((Throwable)e);
        }
        QingStorageWriteSupport writeSupport = new QingStorageWriteSupport();
        writeSupport.setSchema(messageType);
        this.extraMetaData.put(".metadata.", MetaInfoDecodeUtil.encode((MetaInfo)metaInfo));
        CodecFactory.BytesCompressor bytesCompressor = null;
        bytesCompressor = suppourtSnappy ? new CodecFactory.BytesCompressor(CompressionCodecName.SNAPPY, (c)new SnappyCodec(), 0x100000) : new CodecFactory.BytesCompressor(CompressionCodecName.GZIP, (c)new GzipCodec(), 0x100000);
        this._recordWriter = new QingStorageRecordWriter(fileWriter, (d)writeSupport, messageType, this.extraMetaData, 0xA00000L, 0x100000, bytesCompressor, 0x100000, true, false, DEFAULT_WRITER_VERSION);
    }

    public void write(QingStorageRecord record) throws AbstractDataSourceException, InterruptedException {
        try {
            this._recordWriter.write((Object)record);
        }
        catch (IOException e) {
            AbstractDataSourceException.persistenceExcetpion((Throwable)e);
        }
    }

    public void addExtraData(String key, String value) {
        this.extraMetaData.put(key, value);
    }

    public String getExtraData(String key) {
        return this.extraMetaData.get(key);
    }

    public void finishWriteData() throws DataSourcePersistenceException {
        if (this._recordWriter != null) {
            try {
                this._recordWriter.close();
            }
            catch (Exception e) {
                AbstractDataSourceException.persistenceExcetpion((Throwable)e);
            }
            finally {
                this._recordWriter = null;
            }
        }
    }

    public void close(Exception exception) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this._qingFileWriter != null) {
            this._qingFileWriter.close(exception);
            this._qingFileWriter = null;
        }
    }

    static {
        try {
            Class.forName("org.xerial.snappy.Snappy");
            suppourtSnappy = true;
        }
        catch (Throwable e) {
            suppourtSnappy = false;
            LogUtil.warn((String)String.format("init snappy faile on OS:%s ARCH:%s, failback to GIZP.", OSInfo.getOSName(), OSInfo.getArchName()));
        }
    }
}

