/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.qs;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceCountable;
import com.kingdee.bos.qing.datasource.spec.IDistinctValueCollecter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataIterator;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.DefaultDataHandlerFactory;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class QsDataSourceVisitorWrapper
extends AbstractSingleDataSourceVisitor
implements IDataSourceCountable {
    private QSDataSourceVisitor qsDataSourceVisitor;
    private boolean visitPrimitiveData;

    public QsDataSourceVisitorWrapper(QSDataSourceVisitor qsDataSourceVisitor, boolean visitPrimitiveData) {
        this.qsDataSourceVisitor = qsDataSourceVisitor;
        this.visitPrimitiveData = visitPrimitiveData;
    }

    @Override
    public long getRowCount() {
        return this.qsDataSourceVisitor.getRowCount();
    }

    @Override
    public boolean hasData() {
        return this.qsDataSourceVisitor.hasData();
    }

    public IDataIterator iterator() throws AbstractDataSourceException {
        if (!this.hasData()) {
            throw new DataSourceNoDataException("no data in datasource");
        }
        return new QSDataIterator(this.qsDataSourceVisitor.getDataFile(), new DefaultDataHandlerFactory(this.visitPrimitiveData));
    }

    @Override
    public void collectDistinctValue(IDistinctValueCollecter valueCollecter, List<DSFieldKey> fields, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
        this.qsDataSourceVisitor.collectDistinctValue(valueCollecter, fields, filters);
    }

    public Calendar[] getDateScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        return this.qsDataSourceVisitor.getDateScope(field);
    }

    public BigDecimal[] getNumberScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        return this.qsDataSourceVisitor.getNumberScope(field);
    }

    @Override
    public boolean isFieldsExisted(Collection<String> searchFields) {
        return this.qsDataSourceVisitor.isFieldsExisted(searchFields);
    }

    public DSMeta getMeta() {
        return this.qsDataSourceVisitor.getMeta();
    }

    @Override
    public MetaInfo getMetaInfo() {
        return this.qsDataSourceVisitor.getMetaInfo();
    }
}

