/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.qsdatahandler;

import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.BinaryDataHandler;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.IQsDataHandler;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.IQsDataHandlerFactory;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.Int64DataHandler;
import java.util.HashMap;
import java.util.Map;
import shaded.org.apache.parquet.example.data.Group;

public class DefaultDataHandlerFactory
implements IQsDataHandlerFactory {
    private Map<DataType, IQsDataHandler> dataHandlerMap = new HashMap<DataType, IQsDataHandler>();
    private static IQsDataHandler NULL_DATAHANDLER = new NullDataHandler();

    public DefaultDataHandlerFactory(boolean usePrimitive) {
        this.initDataHandles(usePrimitive);
    }

    protected final void initDataHandles(boolean usePrimitive) {
        this.dataHandlerMap.put(DataType.STRING, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(DataType.NUMBER, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(DataType.DATE, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(DataType.DATETIME, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(DataType.INT, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(DataType.BOOLEAN, new BinaryDataHandler(usePrimitive));
    }

    @Override
    public IQsDataHandler getDataHandler(DataType dataType) {
        IQsDataHandler dataHandler = this.dataHandlerMap.get(dataType);
        return dataHandler == null ? NULL_DATAHANDLER : dataHandler;
    }

    private static class NullDataHandler
    implements IQsDataHandler {
        private NullDataHandler() {
        }

        @Override
        public Object handle(Group _record, int colIndex, DataType dataType) {
            return null;
        }
    }
}

