/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dbmanage.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.dbmanage.dao.DBConnectionDao;
import com.kingdee.bos.qing.dbmanage.dao.DBPermissionDao;
import com.kingdee.bos.qing.dbmanage.domain.BizSourceInfoCollector;
import com.kingdee.bos.qing.dbmanage.exception.DBDuplicateHashcodeException;
import com.kingdee.bos.qing.dbmanage.exception.DBDuplicateNameException;
import com.kingdee.bos.qing.dbmanage.exception.DBInfoNotFoundException;
import com.kingdee.bos.qing.dbmanage.exception.DBManageException;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.dbmanage.model.DBConnectionPO;
import com.kingdee.bos.qing.dbmanage.model.DBPermissionInfo;
import com.kingdee.bos.qing.dbmanage.model.DBRefInfo;
import com.kingdee.bos.qing.dbmanage.model.DBRefInfoVO;
import com.kingdee.bos.qing.dbmanage.model.RefFromType;
import com.kingdee.bos.qing.dbmanage.model.ValueTextPair;
import com.kingdee.bos.qing.dbmanage.oplog.DbMOpLog;
import com.kingdee.bos.qing.dbmanage.reference.DBRefDetailProviderFactory;
import com.kingdee.bos.qing.dbmanage.reference.IProviderDBRefDetail;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.sourcemanage.dao.SourceRefDao;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.JDOMException;

public class DBConnectionDomain {
    protected IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    protected QingContext qingContext;
    private DBConnectionDao dbConnectionDao;
    private DBPermissionDao dbPermissionDao;
    private SourceRefDao sourceRefDao;

    public DBConnectionDomain(IDBExcuter dbExcuter, ITransactionManagement tx, QingContext qingContext) {
        this.dbExcuter = dbExcuter;
        this.tx = tx;
        this.qingContext = qingContext;
    }

    private DBConnectionDao getDBConnectionDao() {
        if (this.dbConnectionDao == null) {
            this.dbConnectionDao = new DBConnectionDao(this.dbExcuter);
        }
        return this.dbConnectionDao;
    }

    protected DBPermissionDao getDBPermissionDao() {
        if (this.dbPermissionDao == null) {
            this.dbPermissionDao = new DBPermissionDao(this.dbExcuter);
        }
        return this.dbPermissionDao;
    }

    private SourceRefDao getSourceRefDao() {
        if (this.sourceRefDao == null) {
            this.sourceRefDao = new SourceRefDao(this.dbExcuter);
        }
        return this.sourceRefDao;
    }

    public DBConnection saveDBConnection(DBConnection dbConnection, boolean isPwdUpdated) throws AbstractQingIntegratedException, DBManageException {
        String name = dbConnection.getName();
        String userId = this.qingContext.getUserId();
        try {
            DBConnectionPO dbConnectionExist = this.getDBConnectionDao().loadDBConnectionByHashCode(dbConnection.getDBHashCode(), userId);
            if (dbConnectionExist != null) {
                throw new DBDuplicateHashcodeException(dbConnectionExist.getName());
            }
            if (!dbConnection.isDBCenterSource() && StringUtils.isNotBlank((CharSequence)name) && (dbConnectionExist = this.getDBConnectionDao().loadDBConnectionByName(name)) != null) {
                throw new DBDuplicateNameException();
            }
        }
        catch (SQLException e) {
            throw new DBManageException(e);
        }
        dbConnection.setCreatorId(userId);
        dbConnection.setModifierId(userId);
        ArrayList<IQingFile> saveQingFiles = new ArrayList<IQingFile>();
        try {
            this.tx.beginRequired();
            String fId = UUID.randomUUID().toString();
            dbConnection.setId(fId);
            AbstractSource source = dbConnection.getDbSource();
            if (source instanceof IFileSavable) {
                this.saveDBSourceFile(fId, source, saveQingFiles);
            }
            if (!isPwdUpdated) {
                this.getActualPassword(source, dbConnection.getId());
            }
            DBConnectionPO dbPO = dbConnection.toPO();
            Date date = new Date();
            dbPO.setCreateTime(date);
            dbPO.setModifyTime(date);
            fId = this.getDBConnectionDao().saveDBConnection(dbPO);
            this.repairRefByHashCode(dbConnection);
            long timeStamp = date.getTime();
            dbConnection.setId(fId);
            dbConnection.setCreateTime(timeStamp);
            dbConnection.setModifyTime(timeStamp);
            dbConnection.setCreatorName(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, dbConnection.getCreatorId()));
            dbConnection.setModifierName(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, dbConnection.getModifierId()));
        }
        catch (AbstractQingIntegratedException e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw e;
        }
        catch (Exception e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw new DBManageException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(name);
        DbMOpLog emptyDir = DbMOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u516c\u5171\u6570\u636e\u6e90");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)emptyDir, params));
        return dbConnection;
    }

    public String saveConnAndUpdateRefWithoutTx(DBConnection dbInfo, String refFromId, RefFromType refFromType) throws AbstractQingIntegratedException, SQLException, DBDuplicateHashcodeException, DBDuplicateNameException, IOException, ModelParseException, JDOMException {
        String dbInfoId = dbInfo.getId();
        if (dbInfoId == null) {
            DBConnectionPO dbConnectionExist = null;
            dbConnectionExist = this.getDBConnectionDao().loadDBConnectionByHashCode(dbInfo.getDBHashCode(), this.qingContext.getUserId());
            if (dbConnectionExist != null) {
                dbInfoId = dbConnectionExist.getId();
            } else {
                String name = dbInfo.getName();
                if (StringUtils.isBlank((CharSequence)name)) {
                    name = "";
                } else {
                    boolean isNameExist = true;
                    while (isNameExist) {
                        dbConnectionExist = this.getDBConnectionDao().loadDBConnectionByName(name);
                        if (dbConnectionExist == null) {
                            isNameExist = false;
                            continue;
                        }
                        name = this.addNameSuffix(name);
                    }
                }
                dbInfo.setName(name);
                dbInfoId = this.saveDBConnectionWithoutTx(dbInfo);
            }
        }
        this.getDBConnectionDao().deleteDBRefInfo(refFromId, refFromType);
        return this.getDBConnectionDao().saveDBInfoRef(refFromId, dbInfoId, dbInfo.getDBHashCode(), this.qingContext.getUserId(), refFromType);
    }

    public String saveDBRefByHashCodeWithoutTx(String fromId, RefFromType refFromType, String hashCode) throws AbstractQingIntegratedException, SQLException {
        DBConnectionPO dbConn = this.getDBConnectionDao().loadDBConnectionByHashCode(hashCode, this.qingContext.getUserId());
        String toId = "";
        if (dbConn != null) {
            toId = dbConn.getId();
        }
        return this.getDBConnectionDao().saveDBInfoRef(fromId, toId, hashCode, this.qingContext.getUserId(), refFromType);
    }

    public String saveDBConnectionWithoutTx(DBConnection dbConnection) throws AbstractQingIntegratedException, SQLException, DBDuplicateHashcodeException, DBDuplicateNameException, IOException, ModelParseException, JDOMException {
        String name = dbConnection.getName();
        String userId = this.qingContext.getUserId();
        DBConnectionPO dbConnectionExist = this.getDBConnectionDao().loadDBConnectionByHashCode(dbConnection.getDBHashCode(), userId);
        if (dbConnectionExist != null) {
            throw new DBDuplicateHashcodeException(dbConnectionExist.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)name) && (dbConnectionExist = this.getDBConnectionDao().loadDBConnectionByName(name)) != null) {
            throw new DBDuplicateNameException();
        }
        dbConnection.setCreatorId(userId);
        dbConnection.setModifierId(userId);
        ArrayList<IQingFile> saveQingFiles = new ArrayList<IQingFile>();
        try {
            String fId = UUID.randomUUID().toString();
            dbConnection.setId(fId);
            AbstractSource source = dbConnection.getDbSource();
            if (source instanceof IFileSavable) {
                this.saveDBSourceFile(fId, source, saveQingFiles);
            }
            this.getActualPassword(source, dbConnection.getId());
            DBConnectionPO dbInfo = dbConnection.toPO();
            this.repairRefByHashCode(dbConnection);
            return this.getDBConnectionDao().saveDBConnection(dbInfo);
        }
        catch (AbstractQingIntegratedException e) {
            FileFactory.clearFile(saveQingFiles);
            throw e;
        }
        catch (SQLException e) {
            FileFactory.clearFile(saveQingFiles);
            throw e;
        }
        catch (IOException e) {
            FileFactory.clearFile(saveQingFiles);
            throw e;
        }
        catch (ModelParseException e) {
            FileFactory.clearFile(saveQingFiles);
            throw e;
        }
        catch (JDOMException e) {
            FileFactory.clearFile(saveQingFiles);
            throw e;
        }
    }

    public List<DBConnection> loadDBConnections(String userId, boolean isSupportedOpenAPI) throws AbstractQingIntegratedException, SQLException, DBManageException, ModelParseException, IOException, JDOMException {
        Set<String> userRoleIds = IntegratedHelper.getUserRoleIds(this.qingContext, this.dbExcuter, userId);
        List<DBConnectionPO> dbConnectionPOs = this.getDBConnectionDao().loadPermDBConnections(userId, userRoleIds);
        ArrayList<DBConnection> dbConnections = new ArrayList<DBConnection>(dbConnectionPOs.size());
        for (DBConnectionPO dbInfoPO : dbConnectionPOs) {
            if (dbInfoPO.getDbSourceType() == 1 || !isSupportedOpenAPI && dbInfoPO.getDbSourceType() == 2) continue;
            DBConnection dbConnection = dbInfoPO.toDBConnection();
            dbConnection.setCreatorName(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, dbConnection.getCreatorId()));
            dbConnections.add(dbConnection);
        }
        Collections.sort(dbConnections, new Comparator<DBConnection>(){

            @Override
            public int compare(DBConnection o1, DBConnection o2) {
                Long createTime1 = o1.getCreateTime();
                Long createTime2 = o2.getCreateTime();
                return createTime2.compareTo(createTime1);
            }
        });
        return dbConnections;
    }

    public List<String> loadAllDBConnIdsWithoutDBCenter() throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> dbConnIds = new ArrayList<String>(16);
        List<DBConnectionPO> dbConnectionPOS = this.getDBConnectionDao().loadAllConnIdsWithoutDBCenter();
        for (DBConnectionPO dbConnection : dbConnectionPOS) {
            if (dbConnection.getDbSourceType() == 2) continue;
            dbConnIds.add(dbConnection.getId());
        }
        return dbConnIds;
    }

    public List<DBConnection> loadDBConnections(String userId) throws AbstractQingIntegratedException, SQLException, DBManageException, ModelParseException, IOException, JDOMException {
        return this.loadDBConnections(userId, false);
    }

    public Boolean isDBConnHasPermission(String userId, String dbInfoId) throws AbstractQingIntegratedException, SQLException {
        return true;
    }

    public List<DBConnection> loadDBConnWithoutDBCenter() throws AbstractQingIntegratedException, SQLException, DBManageException, ModelParseException, IOException, JDOMException {
        List<DBConnectionPO> dbInfoPOs = this.getDBConnectionDao().loadDBConnWithoutDBCenter();
        ArrayList<DBConnection> dbConnections = new ArrayList<DBConnection>(dbInfoPOs.size());
        for (DBConnectionPO dbInfoPO : dbInfoPOs) {
            DBConnection dbConnection = dbInfoPO.toDBConnection();
            this.replacePasswordWithUUID(dbConnection.getDbSource());
            dbConnections.add(dbConnection);
        }
        return dbConnections;
    }

    public DBConnection loadDBConnByName(String dbName) throws SQLException, AbstractQingIntegratedException, ModelParseException, JDOMException, IOException {
        DBConnectionPO po = this.getDBConnectionDao().loadDBConnectionByName(dbName);
        if (po != null) {
            return po.toDBConnection();
        }
        return null;
    }

    public DBConnection loadDBConnByHashCode(String hashCode) throws SQLException, AbstractQingIntegratedException, ModelParseException, JDOMException, IOException {
        DBConnectionPO po = this.getDBConnectionDao().loadDBConnectionByHashCode(hashCode, this.qingContext.getUserId());
        if (po != null) {
            return po.toDBConnection();
        }
        return null;
    }

    public void deleteDBConnection(String dbInfoId) throws DBManageException, AbstractQingIntegratedException {
        DBConnectionPO dbInfoPO;
        try {
            dbInfoPO = this.getDBConnectionDao().loadDBConnection(dbInfoId);
        }
        catch (SQLException e) {
            throw new DBManageException(e);
        }
        if (dbInfoPO == null) {
            return;
        }
        try {
            this.tx.beginRequired();
            this.getDBConnectionDao().deleteDBConnection(dbInfoId);
            DBConnection dbConnection = dbInfoPO.toDBConnection();
            AbstractSource source = dbConnection.getDbSource();
            if (source instanceof IFileSavable) {
                this.deleteDBSourceFile(source);
            }
            this.getDBPermissionDao().deleteDBPermission(dbInfoId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new DBManageException(e);
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw new DBManageException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public void deleteDBConnectionsWithoutTx(List<String> dbInfoIds) throws AbstractQingIntegratedException, SQLException, ModelParseException, JDOMException, IOException {
        List<DBConnectionPO> dbInfoPOs = this.getDBConnectionDao().loadDBConnWithoutDBCenter();
        HashMap<String, String> dbNameMap = new HashMap<String, String>(dbInfoPOs.size());
        this.getDBConnectionDao().deleteDBConnections(dbInfoIds);
        for (DBConnectionPO po : dbInfoPOs) {
            dbNameMap.put(po.getId(), po.getName());
            DBConnection db = po.toDBConnection();
            AbstractSource source = db.getDbSource();
            if (!(source instanceof IFileSavable)) continue;
            this.deleteDBSourceFile(source);
        }
        ArrayList<String> params = new ArrayList<String>(1);
        for (String dbInfoId : dbInfoIds) {
            params.clear();
            String name = (String)dbNameMap.get(dbInfoId);
            if (name == null) continue;
            params.add(name);
            DbMOpLog emptyDir = DbMOpLog.EMPTY_DIR;
            emptyDir.setLogScene("\u516c\u5171\u6570\u636e\u6e90");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)emptyDir, params));
        }
    }

    public void deleteDBConnRefWithoutTx(String refFromId, RefFromType refFromType) throws AbstractQingIntegratedException, SQLException {
        this.getDBConnectionDao().deleteDBRefInfo(refFromId, refFromType);
    }

    public DBConnection updateDBConnection(DBConnection dbConnection, boolean isPwdUpdated) throws AbstractQingIntegratedException, DBManageException {
        DBConnection oldDBConnection;
        DBConnectionPO oldDBPO;
        String userId = this.qingContext.getUserId();
        try {
            oldDBPO = this.getDBConnectionDao().loadDBConnection(dbConnection.getId());
        }
        catch (SQLException e) {
            throw new DBManageException(e);
        }
        if (oldDBPO == null) {
            throw new DBInfoNotFoundException();
        }
        try {
            DBConnectionPO dbConnectionExist = this.getDBConnectionDao().loadDBConnectionByHashCode(dbConnection.getDBHashCode(), userId);
            if (dbConnectionExist != null && !dbConnectionExist.getId().equals(dbConnection.getId())) {
                throw new DBDuplicateHashcodeException(dbConnectionExist.getName());
            }
            if (!dbConnection.isDBCenterSource()) {
                String name = dbConnection.getName();
                dbConnectionExist = this.getDBConnectionDao().loadDBConnectionByName(name);
                if (dbConnectionExist != null && !dbConnectionExist.getId().equals(dbConnection.getId())) {
                    throw new DBDuplicateNameException();
                }
            }
        }
        catch (SQLException e) {
            throw new DBManageException(e);
        }
        try {
            oldDBConnection = oldDBPO.toDBConnection();
        }
        catch (Exception e) {
            throw new DBManageException(e);
        }
        AbstractSource oldDbSource = oldDBConnection.getDbSource();
        if (oldDbSource instanceof IFileSavable) {
            this.deleteDBSourceFile(oldDbSource);
        }
        dbConnection.setModifierId(userId);
        ArrayList<IQingFile> saveQingFiles = new ArrayList<IQingFile>();
        try {
            this.tx.beginRequired();
            AbstractSource source = dbConnection.getDbSource();
            if (source instanceof IFileSavable) {
                this.saveDBSourceFile(dbConnection.getId(), source, saveQingFiles);
            }
            if (!isPwdUpdated) {
                this.getActualPassword(source, dbConnection.getId());
            }
            Date date = new Date();
            DBConnectionPO dbPO = dbConnection.toPO();
            dbPO.setModifyTime(date);
            this.getDBConnectionDao().updateDBConnection(dbPO);
            this.getDBConnectionDao().updateRefHashCodeByToId(dbPO.getId(), dbPO.getDBHashCode());
            dbConnection.setCreateTime(oldDBPO.getCreateTime().getTime());
            dbConnection.setCreatorName(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, oldDBPO.getCreatorId()));
            dbConnection.setModifyTime(date.getTime());
            dbConnection.setModifierName(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, dbConnection.getModifierId()));
            this.replacePasswordWithUUID(dbConnection.getDbSource());
        }
        catch (AbstractQingIntegratedException e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw new DBManageException(e);
        }
        catch (Exception e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw new DBManageException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(2);
        DbMOpLog emptyDir = DbMOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u516c\u5171\u6570\u636e\u6e90");
        if (!oldDBPO.getName().equals(dbConnection.getName())) {
            emptyDir.setParamsDesc("\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d");
            params.add(oldDBPO.getName());
        }
        params.add(dbConnection.getName());
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)emptyDir, params));
        if (dbConnection.isDBCenterSource()) {
            BizSourceInfoCollector.collect(dbConnection.getDbSource());
        }
        return dbConnection;
    }

    public List<DBRefInfoVO> loadDBRefInfo(String refToId) throws AbstractQingIntegratedException, SQLException {
        List<DBRefInfo> dbRefInfos = this.getDBConnectionDao().loadDBRefInfo(refToId);
        ArrayList<DBRefInfoVO> dbRefInfoVOs = new ArrayList<DBRefInfoVO>();
        for (DBRefInfo dbRefInfo : dbRefInfos) {
            DBRefInfoVO dbRefInfoVO;
            IProviderDBRefDetail provider;
            try {
                provider = DBRefDetailProviderFactory.getDBRefDetailProvider(dbRefInfo.getFromType(), this.dbExcuter, this.tx, this.qingContext);
            }
            catch (Exception e) {
                throw new IntegratedRuntimeException((Throwable)e);
            }
            if (provider == null || (dbRefInfoVO = provider.getDBRefDetail(dbRefInfo)) == null) continue;
            dbRefInfoVOs.add(dbRefInfoVO);
        }
        return dbRefInfoVOs;
    }

    public List<DBRefInfo> loadDBRefInfoByFromId(String refFromId, RefFromType refFromType) throws AbstractQingIntegratedException, SQLException {
        return this.getDBConnectionDao().loadDBRefInfoByFromId(refFromId, refFromType);
    }

    public void getActualPassword(AbstractSource source, String dbConnectId) throws AbstractQingIntegratedException, SQLException, ModelParseException, JDOMException, IOException {
        DBConnectionPO dbConnectionPO;
        DBSource dbSource;
        String encodePwd;
        String pwd;
        if (source instanceof DBSource && this.isUUID(pwd = new String(Base64.decodeBase64((String)(encodePwd = (dbSource = (DBSource)source).getPassword())))) && (dbConnectionPO = this.getDBConnectionDao().loadDBConnection(dbConnectId)) != null) {
            DBConnection dbConnection = dbConnectionPO.toDBConnection();
            DBSource dbSourceRaw = (DBSource)dbConnection.getDbSource();
            dbSource.setPassword(dbSourceRaw.getPassword());
        }
    }

    public void replacePasswordWithUUID(AbstractSource source) {
        if (source instanceof DBSource) {
            DBSource dbSource = (DBSource)source;
            dbSource.setPassword(StringUtils.encodeToBase64String((String)UUID.randomUUID().toString()));
        }
    }

    private void saveDBSourceFile(String fileResFromId, AbstractSource source, List<IQingFile> saveQingFiles) throws IOException {
        if (source instanceof IFileSavable) {
            String tempFilePathName = ((IFileSavable)((Object)source)).getFileUrl();
            String displayName = ((IFileSavable)((Object)source)).getFileName();
            IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)tempFilePathName);
            if (!file.exists()) {
                QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
                resourceInfo.setDisplayName(displayName);
                resourceInfo.setFromId(fileResFromId);
                resourceInfo.setFromType(ResourceFromType.MACRO);
                IQingFile qingFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_DS);
                IQingFileVisitor fileTemp = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempFilePathName);
                if (fileTemp.exists()) {
                    FileFactory.copy((IQingFileVisitor)fileTemp, (IQingFile)qingFile, (boolean)true);
                    saveQingFiles.add(qingFile);
                    ((IFileSavable)((Object)source)).setFileName(displayName);
                    ((IFileSavable)((Object)source)).setFileUrl(qingFile.getName());
                }
            }
        }
    }

    private void deleteDBSourceFile(AbstractSource source) {
        String filePath = ((IFileSavable)((Object)source)).getFileUrl();
        IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)filePath);
        fileUpdater.delete();
    }

    private String addNameSuffix(String name) {
        String newName = null;
        if (name.lastIndexOf("_") > 0) {
            String indexStr = name.substring(name.lastIndexOf("_") + 1, name.length());
            newName = name.substring(0, name.lastIndexOf("_"));
            try {
                Integer index = Integer.parseInt(indexStr);
                index = index + 1;
                newName = newName + "_" + index;
            }
            catch (NumberFormatException e) {
                newName = name + "_1";
            }
        } else {
            newName = name + "_1";
        }
        return newName;
    }

    private void repairRefByHashCode(DBConnection dbConn) throws AbstractQingIntegratedException, SQLException {
        String hashCode = dbConn.getDBHashCode();
        List<DBRefInfo> dbRefInfos = this.getDBConnectionDao().loadDBRefInfoByHashCode(hashCode);
        for (DBRefInfo dbRefInfo : dbRefInfos) {
            String toId = dbRefInfo.getToId();
            DBConnectionPO dbPO = this.getDBConnectionDao().loadDBConnection(toId);
            if (dbPO != null) continue;
            this.getDBConnectionDao().updateRefToIdByHashCode(dbConn.getId(), hashCode);
        }
    }

    private boolean isUUID(String uuid) {
        String[] components = uuid.split("-");
        return components.length == 5;
    }

    public void saveOrUpdateDBPermissionInfo(DBConnection dbConn, boolean bAuthToAll) throws AbstractQingIntegratedException, SQLException {
        String dbConnId = dbConn.getId();
        try {
            this.tx.beginRequired();
            if (!bAuthToAll) {
                List<DBPermissionInfo> dbPermissionInfos = this.buildDBPermissionInfo(dbConn);
                this.getDBPermissionDao().saveOrUpdateDBPermissionInfo(dbConnId, '0');
                this.getDBPermissionDao().saveOrUpdateDBPermissionInfo(dbConnId, dbPermissionInfos);
            } else {
                this.getDBPermissionDao().saveOrUpdateDBPermissionInfo(dbConnId, '1');
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException throwables) {
            this.tx.markRollback();
            throw throwables;
        }
        finally {
            this.tx.end();
        }
    }

    public void loadDBPermissionInfo(DBConnection dbConn) throws AbstractQingIntegratedException, DBManageException {
        try {
            List<DBPermissionInfo> connPermissionInfos = this.getDBPermissionDao().loadDBPermissionInfo(dbConn.getId());
            List<List<String>> availablePermissionId = this.getAvailablePermissionId(connPermissionInfos);
            this.setRoleAndUser(connPermissionInfos, dbConn, availablePermissionId);
        }
        catch (SQLException e) {
            throw new DBManageException(e);
        }
    }

    private List<List<String>> getAvailablePermissionId(List<DBPermissionInfo> permissionInfo) throws IntegratedRuntimeException {
        ArrayList<List<String>> availablePermission = new ArrayList<List<String>>(10);
        List<List<String>> roleAndUserId = DBConnectionDomain.getRoleAndUserId(permissionInfo);
        HashSet userIds = new HashSet(roleAndUserId.get(0));
        HashSet roleIds = new HashSet(roleAndUserId.get(1));
        List<String> newUserIds = IntegratedHelper.getValidUserIds(this.qingContext, this.dbExcuter, new ArrayList<String>(userIds));
        List<String> newRoleIds = IntegratedHelper.getValidRoleIds(this.qingContext, this.dbExcuter, new ArrayList<String>(roleIds));
        availablePermission.add(newUserIds);
        availablePermission.add(newRoleIds);
        return availablePermission;
    }

    private void setRoleAndUser(List<DBPermissionInfo> permissionInfos, DBConnection vo, List<List<String>> availablePermissionId) throws IntegratedRuntimeException {
        int i;
        if (permissionInfos == null) {
            return;
        }
        ArrayList<ValueTextPair> users = new ArrayList<ValueTextPair>();
        ArrayList<ValueTextPair> roles = new ArrayList<ValueTextPair>();
        List<List<String>> roleAndUserId = DBConnectionDomain.getRoleAndUserId(permissionInfos);
        List<String> userIds = roleAndUserId.get(0);
        List<String> roleIds = roleAndUserId.get(1);
        List<String> newUserIds = availablePermissionId.get(0);
        List<String> newRoleIds = availablePermissionId.get(1);
        if (userIds != null && userIds.size() > 0) {
            for (i = 0; i < userIds.size(); ++i) {
                if (!newUserIds.contains(userIds.get(i))) continue;
                ValueTextPair pairUser = new ValueTextPair();
                String userId = userIds.get(i);
                String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, userId);
                pairUser.setText(userName);
                pairUser.setValue(userId);
                users.add(pairUser);
            }
        }
        if (roleIds != null && roleIds.size() > 0) {
            for (i = 0; i < roleIds.size(); ++i) {
                if (!newRoleIds.contains(roleIds.get(i))) continue;
                ValueTextPair pairRole = new ValueTextPair();
                String roleId = roleIds.get(i);
                String roleName = IntegratedHelper.getRoleName(this.qingContext, this.dbExcuter, roleId);
                pairRole.setValue(roleId);
                pairRole.setText(roleName);
                roles.add(pairRole);
            }
        }
        vo.setUsers(users);
        vo.setRoles(roles);
    }

    private static List<List<String>> getRoleAndUserId(List<DBPermissionInfo> permissionInfos) {
        ArrayList<String> userIds = new ArrayList<String>(10);
        ArrayList<String> roleIds = new ArrayList<String>(10);
        for (DBPermissionInfo permissionInfo : permissionInfos) {
            int permType = permissionInfo.getType();
            if (permType == 0) {
                String userId = permissionInfo.getViewerId();
                userIds.add(userId);
                continue;
            }
            if (permType != 1) continue;
            String roleId = permissionInfo.getViewerId();
            roleIds.add(roleId);
        }
        ArrayList<List<String>> roleAndUser = new ArrayList<List<String>>();
        roleAndUser.add(userIds);
        roleAndUser.add(roleIds);
        return roleAndUser;
    }

    protected List<DBPermissionInfo> buildDBPermissionInfo(DBConnection vo) {
        ArrayList<DBPermissionInfo> permInfos = new ArrayList<DBPermissionInfo>();
        String dbInfoId = vo.getId();
        List<ValueTextPair> userPair = vo.getUsers();
        this.buildPermInfos(dbInfoId, userPair, 0, permInfos);
        List<ValueTextPair> rolePair = vo.getRoles();
        this.buildPermInfos(dbInfoId, rolePair, 1, permInfos);
        return permInfos;
    }

    private void buildPermInfos(String dbInfoId, List<ValueTextPair> pairs, int type, List<DBPermissionInfo> permInfos) {
        DBPermissionInfo permInfo = null;
        if (pairs == null || pairs.isEmpty()) {
            return;
        }
        Date date = new Date();
        for (ValueTextPair pair : pairs) {
            permInfo = new DBPermissionInfo();
            permInfo.setId(UUID.randomUUID().toString());
            permInfo.setDbinfoId(dbInfoId);
            permInfo.setViewerId(pair.getValue());
            permInfo.setType(type);
            permInfo.setCreatorId(this.qingContext.getUserId());
            permInfo.setCreateTime(date);
            permInfos.add(permInfo);
        }
    }

    public List<DBConnection> modelSetLoadDBConnections() throws AbstractQingIntegratedException, SQLException, DBManageException, ModelParseException, IOException, JDOMException {
        ArrayList<DBConnection> list = new ArrayList<DBConnection>();
        List<DBConnection> dbConnections = this.loadDBConnections(this.qingContext.getUserId());
        DBSource.DBType[] supportSourceType = new DBSource.DBType[]{DBSource.DBType.MYSQL, DBSource.DBType.SQLSERVER, DBSource.DBType.ORACLE, DBSource.DBType.POSTGRESQL, DBSource.DBType.GREENPLUM};
        for (DBConnection dbConnection : dbConnections) {
            if (dbConnection.getDbSourceType() != SourceType.DB) continue;
            DBSource dbSource = (DBSource)dbConnection.getDbSource();
            if (!Arrays.asList(supportSourceType).contains((Object)dbSource.getDbType())) continue;
            list.add(dbConnection);
        }
        return list;
    }
}

