/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dbmanage.model;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.util.SourceFactory;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class DBConnectionPO {
    private String id;
    private String name;
    private byte[] content;
    private int dbSourceType;
    private String creatorId;
    private String modifierId;
    private Date createTime;
    private Date modifyTime;
    private String dbHashCode;
    private boolean shared;
    public static final int DB = 0;
    public static final int BizMeta = 1;
    public static final int OPENAPI = 2;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public int getDbSourceType() {
        return this.dbSourceType;
    }

    public void setDbSourceType(int dbSourceType) {
        this.dbSourceType = dbSourceType;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getModifierId() {
        return this.modifierId;
    }

    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getDBHashCode() {
        return this.dbHashCode;
    }

    public void setDBHashCode(String dbHashCode) {
        this.dbHashCode = dbHashCode;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public DBConnection toDBConnection() throws JDOMException, IOException, ModelParseException {
        DBConnection dbConnection = new DBConnection();
        dbConnection.setId(this.id);
        dbConnection.setName(this.name);
        dbConnection.setShared(this.shared);
        dbConnection.setCreatorId(this.creatorId);
        dbConnection.setModifierId(this.modifierId);
        if (this.createTime != null) {
            dbConnection.setCreateTime(this.createTime.getTime());
        }
        if (this.modifyTime != null) {
            dbConnection.setModifyTime(this.modifyTime.getTime());
        }
        SourceType type = SourceType.DB;
        switch (this.dbSourceType) {
            case 0: {
                type = SourceType.DB;
                break;
            }
            case 1: {
                type = SourceType.BizMeta;
                break;
            }
            case 2: {
                type = SourceType.OPENAPI;
                break;
            }
            default: {
                type = SourceType.DB;
            }
        }
        dbConnection.setDbSourceType(type);
        if (this.content != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.content);
            if (dbConnection.isDBSource()) {
                DBSource dbSource = new DBSource();
                Element xmlNode = XmlUtil.loadRootElement((InputStream)bais);
                dbSource.fromXml(xmlNode);
                dbConnection.setDbSource(dbSource);
            } else {
                Element xmlNode = XmlUtil.loadRootElement((InputStream)bais);
                AbstractSource source = SourceFactory.instanceFromXml(xmlNode);
                if (source != null) {
                    source.fromXml(xmlNode);
                    dbConnection.setDbSource(source);
                }
            }
        }
        return dbConnection;
    }
}

