/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.macro.IMacroExecutor;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.db.DBSQLMacroExecuteException;
import com.kingdee.bos.qing.data.exception.macro.MacroDBUnsetException;
import com.kingdee.bos.qing.data.exception.macro.MacroExecuteException;
import com.kingdee.bos.qing.data.exception.macro.MacroNoAuthorityException;
import com.kingdee.bos.qing.data.exception.macro.MacroNotFoundException;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.macro.domain.MacroDomainFactory;
import com.kingdee.bos.qing.macro.model.po.SQLMacroPO;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.MacroValue;
import com.kingdee.bos.qing.macro.model.vo.SQLMacro;
import com.kingdee.bos.qing.macro.util.MacroFormatHelper;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.jdom2.JDOMException;

public abstract class AbstractMacroExecutor
implements IMacroExecutor {
    protected abstract IDBExcuter getDbExcuter();

    @Override
    public Set<Object> getMacroValues(String sql, QingContext qingContext) throws MacroExecuteException, MacroNotFoundException, MacroNoAuthorityException, MacroDBUnsetException {
        Matcher matcher = MacroFormatHelper.matcher(sql);
        HashSet<Object> rsSet = new HashSet<Object>();
        if (matcher.find()) {
            String macroUid = matcher.group();
            rsSet.addAll(this.getMacroExeResult(macroUid, qingContext));
        }
        return rsSet;
    }

    @Override
    public Set<String> getMacroKeys(String sql) throws MacroExecuteException {
        Matcher matcher = MacroFormatHelper.matcher(sql);
        HashSet<String> rsSet = new HashSet<String>();
        while (matcher.find()) {
            rsSet.add(MacroFormatHelper.format(matcher.group()));
        }
        return rsSet;
    }

    @Override
    public boolean containsMacro(String sql) {
        Matcher matcher = MacroFormatHelper.matcher(sql);
        return matcher.find();
    }

    @Override
    public void checkMacroValsPermission(QingContext qingContext, List<String> macroIds) throws AbstractQingIntegratedException, SQLException, ModelParseException, IOException, JDOMException, DBSQLMacroExecuteException {
        MacroCommonDomain macroDomain = new MacroCommonDomain(this.getDbExcuter(), qingContext);
        List<SQLMacroPO> macroPOs = macroDomain.getDataModelDesignTimeMacro(macroIds);
        HashMap<String, Boolean> dbCenterSourcePermissionCache = new HashMap<String, Boolean>();
        HashMap<String, Boolean> dbSourcePermissionCache = new HashMap<String, Boolean>();
        for (SQLMacroPO macroPO : macroPOs) {
            SQLMacro sqlMacro = macroPO.toSQLMacro();
            boolean hasPermission = macroDomain.checkMacroAvailable(dbCenterSourcePermissionCache, dbSourcePermissionCache, sqlMacro.getDBInfo(), macroPO.getModifierId());
            if (hasPermission) continue;
            throw new DBSQLMacroExecuteException(macroPO.getUid());
        }
    }

    private Set<Object> getMacroExeResult(String macroUid, QingContext qingContext) throws MacroExecuteException, MacroNotFoundException, MacroNoAuthorityException, MacroDBUnsetException {
        MacroCommonDomain macroCommonDomain = new MacroCommonDomain(this.getDbExcuter(), qingContext);
        Macro macro = null;
        try {
            macro = macroCommonDomain.loadCommonMacroByUid(macroUid);
            if (macro == null) {
                throw new com.kingdee.bos.qing.macro.exception.MacroNotFoundException();
            }
            AbstractMacroDomain macroDomain = MacroDomainFactory.getDomain(macro.getType(), this.getDbExcuter(), null, qingContext);
            MacroValue macroValue = macroDomain.getMacroExecuteResult(macro.getFid());
            if (macroValue != null && CollectionUtils.isNotEmpty(macroValue.getColumnValues()) && macroValue.getColumnValues().get(0) != null) {
                return new HashSet<Object>((Collection)macroValue.getColumnValues().get(0));
            }
            return new HashSet<Object>();
        }
        catch (com.kingdee.bos.qing.macro.exception.MacroNotFoundException e) {
            throw new MacroNotFoundException(macroUid);
        }
        catch (com.kingdee.bos.qing.macro.exception.MacroDBUnsetException e) {
            throw new MacroDBUnsetException(macro != null ? macro.getName() : "");
        }
        catch (Exception e) {
            throw new MacroExecuteException(e);
        }
    }
}

