/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.domain.source.db.util.DataTypeUtil;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.dbmanage.exception.DBManageException;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.dbmanage.model.RefFromType;
import com.kingdee.bos.qing.macro.dao.SQLMacroManageDao;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.exception.MacroDBUnsetException;
import com.kingdee.bos.qing.macro.exception.MacroExecuteException;
import com.kingdee.bos.qing.macro.exception.MacroNotFoundException;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.macro.model.po.SQLMacroPO;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.MacroValue;
import com.kingdee.bos.qing.macro.model.vo.MacrosPaginationVo;
import com.kingdee.bos.qing.macro.model.vo.PreviewData;
import com.kingdee.bos.qing.macro.model.vo.SQLMacro;
import com.kingdee.bos.qing.macro.oplog.MacroOpLog;
import com.kingdee.bos.qing.macro.strategy.IMacroCheckPermission;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.util.DateUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.MacroCheckPermissionUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.pagination.PaginationRequestData;
import com.kingdee.bos.qing.util.pagination.PaginationUtil;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLMacroDomain
extends AbstractMacroDomain {
    private SQLMacroManageDao manageDao;

    public SQLMacroDomain(IDBExcuter dbExcuter, ITransactionManagement tx, QingContext qingContext) {
        super(dbExcuter, tx, qingContext);
    }

    private SQLMacroManageDao getManageDao() {
        if (this.manageDao == null) {
            this.manageDao = new SQLMacroManageDao(this.dbExcuter);
        }
        return this.manageDao;
    }

    @Override
    protected void saveWithoutTx(Macro macro, boolean checkExecutable) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        SQLMacro sqlMacro = (SQLMacro)macro;
        try {
            if (checkExecutable) {
                this.checkSQLValid(sqlMacro);
            }
            SQLMacroPO macroPO = sqlMacro.toSQLMacroPO();
            if (sqlMacro.getDBInfo() != null) {
                this.getDBConnectionDomain().saveConnAndUpdateRefWithoutTx(sqlMacro.getDBInfo(), macroPO.getFid(), RefFromType.Macro);
            } else if (sqlMacro.getRefDBHashCode() != null) {
                this.getDBConnectionDomain().saveDBRefByHashCodeWithoutTx(macroPO.getFid(), RefFromType.Macro, sqlMacro.getRefDBHashCode());
            }
            this.getManageDao().saveSQLMacro(macroPO);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
    }

    @Override
    protected void updateWithoutTx(Macro newMacro, Macro oldMacro) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        SQLMacro newSqlMacro = (SQLMacro)newMacro;
        try {
            this.checkSQLValid(newSqlMacro);
            SQLMacroPO oldSQLMacroPO = this.getManageDao().loadMacro(oldMacro.getFid());
            if (oldSQLMacroPO != null) {
                DBConnection newDBConnection = newSqlMacro.getDBInfo();
                this.getDBConnectionDomain().saveConnAndUpdateRefWithoutTx(newDBConnection, newSqlMacro.getFid(), RefFromType.Macro);
                SQLMacroPO po = newSqlMacro.toSQLMacroPO();
                this.getManageDao().updateSQLMacro(po);
            }
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
    }

    @Override
    protected void deleteWithoutTx(String macroId) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        SQLMacroPO sqlMacroPO = this.getManageDao().loadMacro(macroId);
        if (sqlMacroPO == null) {
            return;
        }
        try {
            SQLMacro sqlMacro = sqlMacroPO.toSQLMacro();
            this.getDBConnectionDomain().deleteDBConnRefWithoutTx(sqlMacro.getFid(), RefFromType.Macro);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
        this.getManageDao().deleteSQLMacro(sqlMacroPO.getFid());
    }

    @Override
    protected void deleteWithoutTx(List<String> macroIds) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        ArrayList<String> dbConnsToDel = new ArrayList<String>(10);
        ArrayList<String> macroNames = new ArrayList<String>(macroIds.size());
        try {
            for (String macroId : macroIds) {
                SQLMacroPO sqlMacroPO = this.getManageDao().loadMacro(macroId);
                macroNames.add(sqlMacroPO.getName());
                SQLMacro sqlMacro = sqlMacroPO.toSQLMacro();
                this.getDBConnectionDomain().deleteDBConnRefWithoutTx(sqlMacro.getFid(), RefFromType.Macro);
            }
            this.getManageDao().deleteSQLMacrosByMacroIds(macroIds);
            this.getDBConnectionDomain().deleteDBConnectionsWithoutTx(dbConnsToDel);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
        ArrayList params = new ArrayList(1);
        MacroOpLog emptyDir = MacroOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u5b8f\u5b9a\u4e49");
        for (int i = 0; i < macroNames.size(); ++i) {
            params.clear();
            params.add(macroNames.get(i));
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)emptyDir, params));
        }
    }

    @Override
    public Macro loadMacro(String macroId) throws AbstractQingIntegratedException, QingMacroException {
        try {
            SQLMacroPO sqlMacroPO = this.getManageDao().loadMacro(macroId);
            SQLMacro sqlMacro = sqlMacroPO.toSQLMacro();
            String creatorName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, sqlMacroPO.getCreatorId());
            sqlMacro.setCreatorName(creatorName);
            String modifierName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, sqlMacroPO.getModifierId());
            sqlMacro.setModifierName(modifierName);
            return sqlMacro;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
    }

    @Override
    public List<String> loadMacroIds(String searchText) throws AbstractQingIntegratedException, QingMacroException {
        try {
            List<String> macroIds = this.getManageDao().getMacroIds(searchText);
            return macroIds;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
    }

    @Override
    public Integer getRefTimeOfDeleteMacros(List<String> macroIds) throws AbstractQingIntegratedException, QingMacroException {
        try {
            if (macroIds != null && macroIds.size() != 0) {
                return this.getManageDao().getRefTimeOfDeleteMacroIds(macroIds);
            }
            return 0;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
    }

    @Override
    public boolean checkMacroPermissionByUid(String macroUid) throws QingMacroException {
        try {
            IMacroCheckPermission macroCheckPermission = this.getMacroCheckPermission();
            SQLMacroPO sqlMacroPO = this.getManageDao().loadSQLMacroByUid(macroUid);
            SQLMacro sqlMacro = sqlMacroPO.toSQLMacro();
            DBConnection dbConnection = sqlMacro.getDBInfo();
            if (dbConnection != null) {
                if (dbConnection.isDBSource()) {
                    return this.checkMacroDBSourcePermission(sqlMacroPO.getModifierId(), sqlMacro);
                }
                if (dbConnection.isDBCenterSource()) {
                    return MacroCheckPermissionUtil.checkDBCenterSourcePermission(macroCheckPermission, sqlMacroPO.getModifierId());
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
    }

    @Override
    public MacrosPaginationVo loadMacros(Integer targetPage, Integer pageSize, String searchText) throws AbstractQingIntegratedException, QingMacroException {
        try {
            MacrosPaginationVo macrosPaginationVo = new MacrosPaginationVo();
            IMacroCheckPermission macroCheckPermission = this.getMacroCheckPermission();
            Integer macroCount = this.getManageDao().getMacrosCount(searchText);
            PaginationRequestData requestData = PaginationUtil.getCorrectRequestData(macroCount, targetPage, pageSize);
            ArrayList<SQLMacro> sqlMacros = new ArrayList<SQLMacro>(requestData.getPageSize());
            if (requestData.getTotalRow() > 0) {
                Integer offset = (requestData.getTargetPage() - 1) * requestData.getPageSize();
                List<SQLMacroPO> macroPOs = this.getManageDao().loadSQLMacros(offset, requestData.getPageSize(), searchText);
                HashMap<String, Boolean> dbCenterSourcePermissionCache = new HashMap<String, Boolean>(16);
                HashMap<String, Boolean> dbConnectionsCache = new HashMap<String, Boolean>(16);
                for (SQLMacroPO macroPO : macroPOs) {
                    String creatorName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, macroPO.getCreatorId());
                    String modifierName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, macroPO.getModifierId());
                    SQLMacro sqlMacro = macroPO.toSQLMacro();
                    sqlMacro.setReference(this.loadMacroReference(sqlMacro.getFid()));
                    sqlMacro.setCreatorName(creatorName);
                    sqlMacro.setModifierName(modifierName);
                    if (sqlMacro.getDBInfo() != null) {
                        this.processMacroPermission(macroPO.getModifierId(), sqlMacro, macroCheckPermission, dbCenterSourcePermissionCache, dbConnectionsCache);
                    }
                    sqlMacros.add(sqlMacro);
                }
            }
            macrosPaginationVo.setTotalRow(requestData.getTotalRow());
            macrosPaginationVo.setPageSize(requestData.getPageSize());
            macrosPaginationVo.setCurrentPage(requestData.getTargetPage());
            macrosPaginationVo.setMacros(sqlMacros);
            return macrosPaginationVo;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
    }

    private void processMacroPermission(String modifierId, SQLMacro sqlMacro, IMacroCheckPermission macroCheckPermission, Map<String, Boolean> dbCenterSourcePermissionCache, Map<String, Boolean> dbConnectionsCache) throws AbstractQingIntegratedException, SQLException {
        DBConnection dbInfo = sqlMacro.getDBInfo();
        if (dbInfo.isDBSource()) {
            String cacheKey = modifierId + dbInfo.getId();
            Boolean isDbConnHasPermission = dbConnectionsCache.get(cacheKey);
            if (isDbConnHasPermission == null) {
                isDbConnHasPermission = this.checkMacroDBSourcePermission(modifierId, sqlMacro);
                dbConnectionsCache.put(cacheKey, isDbConnHasPermission);
            }
            if (!isDbConnHasPermission.booleanValue()) {
                sqlMacro.setConnAuthorized(false);
                sqlMacro.setDBInfo(null);
            } else {
                this.getDBConnectionDomain().replacePasswordWithUUID(dbInfo.getDbSource());
            }
        } else if (dbInfo.isDBCenterSource()) {
            Boolean isPermission = dbCenterSourcePermissionCache.get(modifierId);
            if (isPermission == null) {
                isPermission = MacroCheckPermissionUtil.checkDBCenterSourcePermission(macroCheckPermission, modifierId);
                dbCenterSourcePermissionCache.put(modifierId, isPermission);
            }
            if (!isPermission.booleanValue()) {
                sqlMacro.setDbCenterAuthorized(false);
                sqlMacro.setDBInfo(null);
            } else {
                this.getDBConnectionDomain().replacePasswordWithUUID(dbInfo.getDbSource());
            }
        } else {
            AbstractSource dbSource = dbInfo.getDbSource();
            this.getDBConnectionDomain().replacePasswordWithUUID(dbSource);
        }
    }

    private boolean checkMacroDBSourcePermission(String modifierId, SQLMacro sqlMacro) throws AbstractQingIntegratedException, SQLException {
        DBConnection dbInfo = sqlMacro.getDBInfo();
        return this.getDBConnectionDomain().isDBConnHasPermission(modifierId, dbInfo.getId());
    }

    @Override
    public List<? extends Macro> loadAllMacros() throws AbstractQingIntegratedException, QingMacroException {
        try {
            List<SQLMacroPO> macroPOs = this.getManageDao().loadAllSQLMacros();
            IMacroCheckPermission macroCheckPermission = this.getMacroCheckPermission();
            ArrayList<SQLMacro> sqlMacros = new ArrayList<SQLMacro>(macroPOs.size());
            HashMap<String, Boolean> dbCenterSourcePermissionCache = new HashMap<String, Boolean>(16);
            HashMap<String, Boolean> dbConnectionsCache = new HashMap<String, Boolean>(16);
            for (SQLMacroPO macroPO : macroPOs) {
                SQLMacro sqlMacro = macroPO.toSQLMacro();
                sqlMacro.setReference(this.loadMacroReference(sqlMacro.getFid()));
                String creatorName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, macroPO.getCreatorId());
                sqlMacro.setCreatorName(creatorName);
                String modifierName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, macroPO.getModifierId());
                sqlMacro.setModifierName(modifierName);
                if (sqlMacro.getDBInfo() != null) {
                    this.processMacroPermission(macroPO.getModifierId(), sqlMacro, macroCheckPermission, dbCenterSourcePermissionCache, dbConnectionsCache);
                }
                sqlMacros.add(sqlMacro);
            }
            return sqlMacros;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
    }

    @Override
    public PreviewData getPreviewData(Macro macro) throws QingMacroException, DBManageException, SQLException, AbstractQingIntegratedException {
        SQLMacro sqlMacro = (SQLMacro)macro;
        AbstractSource source = sqlMacro.getDBInfo().getDbSource();
        String sql = sqlMacro.getContent();
        boolean multiValued = sqlMacro.isMultiValued();
        DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource(source, this.qingContext);
        if (sqlMacro.getDBInfo() != null) {
            try {
                this.getDBConnectionDomain().getActualPassword(source, sqlMacro.getDBInfo().getId());
            }
            catch (Exception e) {
                throw new QingMacroException(e);
            }
        }
        IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource(source, this.qingContext);
        AbstractDBSourceJDBCAdapter jdbcAdapter = null;
        try {
            jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance(dbSource);
            jdbcAdapter.setConnectionFactory(connFactory);
        }
        catch (UnSupportDataSourceException e) {
            throw new QingMacroException((Throwable)((Object)e));
        }
        try {
            return this.getPreviewData(jdbcAdapter, dbSource, sql, sqlMacro.getSQLType(), multiValued);
        }
        catch (Exception e) {
            throw new MacroExecuteException(e);
        }
    }

    @Override
    public PreviewData getPreviewDataByID(String macroId) throws QingMacroException, AbstractQingIntegratedException, SQLException, DBManageException {
        Macro macro = this.loadMacro(macroId);
        if (macro == null) {
            return new PreviewData();
        }
        PreviewData previewData = this.getPreviewData(macro);
        return previewData;
    }

    private void checkSQLValid(SQLMacro sqlMacro) throws MacroExecuteException {
        DBConnection dbConnection = sqlMacro.getDBInfo();
        AbstractSource source = dbConnection.getDbSource();
        DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource(source, this.qingContext);
        IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource(source, this.qingContext);
        AbstractDBSourceJDBCAdapter jdbcAdapter = null;
        try {
            jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance(dbSource);
            jdbcAdapter.setConnectionFactory(connFactory);
            jdbcAdapter.checkSQLExecutable(this.qingContext, dbSource, sqlMacro.getSQLType(), sqlMacro.getContent());
        }
        catch (AbstractSourceException e) {
            throw new MacroExecuteException((Throwable)((Object)e));
        }
    }

    private PreviewData getPreviewData(AbstractDBSourceJDBCAdapter jdbcAdapter, DBSource dbSource, String sql, DBSource.UserSQL.SQLType sqlType, final boolean multiValued) throws AbstractDBSourceException, SQLException, MacroExecuteException {
        try {
            return jdbcAdapter.query(this.qingContext, dbSource, sql, sqlType, new AbstractDBSourceJDBCAdapter.QueryResultHandler<PreviewData>(){

                @Override
                public PreviewData handle(ResultSet rs) throws SQLException {
                    int rowLimit = 100;
                    PreviewData previewData = new PreviewData();
                    ArrayList allColumnValuesList = new ArrayList(10);
                    if (rs.next()) {
                        ResultSetMetaData meta = rs.getMetaData();
                        int columnCount = meta.getColumnCount();
                        if (columnCount >= 1) {
                            ArrayList<String> allColumnNameList = new ArrayList<String>(columnCount);
                            ArrayList<DataType> columnDataTypes = new ArrayList<DataType>(columnCount);
                            for (int i = 1; i <= columnCount; ++i) {
                                int columnIdx = i;
                                String columnName = meta.getColumnLabel(columnIdx);
                                previewData.addField(columnName);
                                ArrayList<String> columnValueList = new ArrayList<String>(10);
                                int type = meta.getColumnType(columnIdx);
                                String className = meta.getColumnClassName(columnIdx);
                                DataType dataType = null;
                                dataType = DataTypeUtil.checkSqlTypes(type) ? DataTypeUtil.parseDataType(type) : DataTypeUtil.parseDataType(className);
                                if (dataType == null) continue;
                                allColumnNameList.add(columnName);
                                columnDataTypes.add(dataType);
                                columnValueList.add(SQLMacroDomain.this.getPreviewText(dataType, columnName, rs));
                                allColumnValuesList.add(columnValueList);
                            }
                            int totalCount = 1;
                            if (multiValued) {
                                while (rs.next()) {
                                    if (totalCount < rowLimit) {
                                        int cols = allColumnNameList.size();
                                        for (int i = 0; i < cols; ++i) {
                                            DataType dataType = (DataType)columnDataTypes.get(i);
                                            String columnName = (String)allColumnNameList.get(i);
                                            ((List)allColumnValuesList.get(i)).add(SQLMacroDomain.this.getPreviewText(dataType, columnName, rs));
                                        }
                                    }
                                    ++totalCount;
                                }
                            }
                            previewData.setTotalRowCount(totalCount);
                        }
                        if (allColumnValuesList.size() > 0) {
                            List columnValueList = (List)allColumnValuesList.get(0);
                            int size = columnValueList.size();
                            for (int i = 0; i < size; ++i) {
                                PreviewData.Row row = previewData.createRow();
                                int allColumnSize = allColumnValuesList.size();
                                for (int j = 0; j < allColumnSize; ++j) {
                                    PreviewData.Column column = row.createColumn();
                                    column.setValue(((List)allColumnValuesList.get(j)).get(i));
                                }
                            }
                        }
                    }
                    return previewData;
                }
            });
        }
        catch (AbstractSourceException e) {
            throw new MacroExecuteException((Throwable)((Object)e));
        }
    }

    @Override
    public MacroValue getMacroExecuteResult(String macroId) throws QingMacroException {
        return this.executeMacro(macroId, new DBSourceExecutor<MacroValue>(){

            @Override
            public MacroValue execute(AbstractDBSourceJDBCAdapter jdbcAdapter, DBSource dbSource, String sql, DBSource.UserSQL.SQLType sqlType, final boolean multiValued) throws SQLException, AbstractDBSourceException {
                return jdbcAdapter.query(SQLMacroDomain.this.qingContext, dbSource, sql, sqlType, new AbstractDBSourceJDBCAdapter.QueryResultHandler<MacroValue>(){

                    @Override
                    public MacroValue handle(ResultSet rs) throws SQLException {
                        ResultSetMetaData meta;
                        int columnCount;
                        MacroValue rsMacroValue = new MacroValue();
                        ArrayList<String> allColumnNames = new ArrayList<String>(10);
                        ArrayList<List<Object>> allColumnValues = new ArrayList<List<Object>>(10);
                        if (rs.next() && (columnCount = (meta = rs.getMetaData()).getColumnCount()) >= 1) {
                            String columnName;
                            int i = 1;
                            while (i <= columnCount) {
                                int columnIdx = i++;
                                columnName = meta.getColumnLabel(columnIdx);
                                allColumnNames.add(columnName);
                                ArrayList<Object> oneColumnValues = new ArrayList<Object>(10);
                                oneColumnValues.add(rs.getObject(columnName));
                                allColumnValues.add(oneColumnValues);
                            }
                            if (multiValued) {
                                while (rs.next()) {
                                    int cols = allColumnNames.size();
                                    for (i = 0; i < cols; ++i) {
                                        columnName = (String)allColumnNames.get(i);
                                        ((List)allColumnValues.get(i)).add(rs.getObject(columnName));
                                    }
                                }
                            }
                        }
                        rsMacroValue.setColumnNames(allColumnNames);
                        rsMacroValue.setColumnValues(allColumnValues);
                        return rsMacroValue;
                    }
                });
            }
        });
    }

    public <T> T executeMacro(String macroId, DBSourceExecutor<T> dbSourceExecutor) throws QingMacroException {
        SQLMacro sqlMacro = null;
        try {
            SQLMacroPO macroPO = this.getManageDao().loadMacro(macroId);
            if (macroPO == null) {
                throw new MacroNotFoundException();
            }
            sqlMacro = macroPO.toSQLMacro();
        }
        catch (MacroNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException(e);
        }
        DBConnection dbConnection = sqlMacro.getDBInfo();
        if (dbConnection == null) {
            throw new MacroDBUnsetException();
        }
        AbstractSource source = dbConnection.getDbSource();
        String sql = sqlMacro.getContent();
        boolean multiValued = sqlMacro.isMultiValued();
        DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource(source, this.qingContext);
        IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource(source, this.qingContext);
        AbstractDBSourceJDBCAdapter jdbcAdapter = null;
        try {
            jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance(dbSource);
            jdbcAdapter.setConnectionFactory(connFactory);
        }
        catch (UnSupportDataSourceException e) {
            throw new QingMacroException((Throwable)((Object)e));
        }
        try {
            return dbSourceExecutor.execute(jdbcAdapter, dbSource, sql, sqlMacro.getSQLType(), multiValued);
        }
        catch (AbstractDBConnectException e) {
            throw new QingMacroException((Throwable)((Object)e));
        }
        catch (SQLException e) {
            throw new QingMacroException(e);
        }
        catch (AbstractSourceException e) {
            throw new MacroExecuteException((Throwable)((Object)e));
        }
    }

    private String getPreviewText(DataType dataType, String columnName, ResultSet rs) throws SQLException {
        switch (dataType) {
            case DATE: {
                Date date = rs.getDate(columnName);
                return date == null ? "" : DateUtils.DateToString((java.util.Date)date);
            }
            case DATETIME: {
                Timestamp ts = rs.getTimestamp(columnName);
                return ts == null ? "" : DateUtils.DateTimeToString((java.util.Date)ts);
            }
        }
        Object obj = rs.getObject(columnName);
        return obj == null ? "" : obj.toString();
    }

    private static interface DBSourceExecutor<T> {
        public T execute(AbstractDBSourceJDBCAdapter var1, DBSource var2, String var3, DBSource.UserSQL.SQLType var4, boolean var5) throws AbstractDBSourceException, SQLException;
    }
}

